/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.modules;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.auth.CryptoException;
import com.mathworks.toolbox.distcomp.auth.modules.CryptoModuleHelper;
import com.mathworks.toolbox.distcomp.auth.modules.KeyPairProvider;
import com.mathworks.toolbox.distcomp.auth.modules.ModuleCreationException;
import com.mathworks.toolbox.distcomp.auth.modules.PackageInfo;
import com.mathworks.toolbox.distcomp.auth.modules.UnableToCreateSecurityDirectoryIOException;
import com.mathworks.toolbox.distcomp.auth.modules.UnableToWriteKeyInformationToPathException;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import com.mathworks.util.PlatformInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.EnumSet;
import java.util.Set;

public final class FileKeyPairProvider
implements KeyPairProvider {
    private File fSecurityDir;
    private static final Set<PosixFilePermission> POSIX_OWNER_READ_ONLY = EnumSet.of(PosixFilePermission.OWNER_READ);
    private static final Set<PosixFilePermission> POSIX_OWNER_WRITABLE_ONLY = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE);

    public FileKeyPairProvider(String string) {
        this.fSecurityDir = new File(string);
    }

    @Override
    public KeyPair getKeyPair() throws ModuleCreationException {
        try {
            return FileKeyPairProvider.readKeyPair(this.fSecurityDir);
        }
        catch (IncorrectPermissionsException | IOException | ClassNotFoundException exception) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Unable to read keys from " + this.fSecurityDir);
            try {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Creating new key pair.");
                KeyPair keyPair = this.createKeyPair();
                FileKeyPairProvider.storeKeyPair(keyPair, this.fSecurityDir);
                return keyPair;
            }
            catch (CryptoException cryptoException) {
                throw new CouldNotGenerateKeyPairException(cryptoException);
            }
            catch (IOException iOException) {
                throw new UnableToWriteKeyInformationToPathException(this.fSecurityDir, (Throwable)iOException);
            }
        }
    }

    private KeyPair createKeyPair() throws CryptoException {
        return CryptoModuleHelper.INSTANCE.generateKeyPair();
    }

    private static KeyPair readKeyPair(File file) throws IOException, ClassNotFoundException, IncorrectPermissionsException {
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Reading key pair from " + file);
        File file2 = new File(file, "public");
        File file3 = new File(file, "private");
        Path path = file3.toPath();
        if (Files.isWritable(path)) {
            throw new IncorrectPermissionsException(path);
        }
        PublicKey publicKey = (PublicKey)FileKeyPairProvider.readKey(file2);
        PrivateKey privateKey = (PrivateKey)FileKeyPairProvider.readKey(file3);
        return new KeyPair(publicKey, privateKey);
    }

    private static void storeKeyPair(KeyPair keyPair, File file) throws IOException {
        boolean bl;
        File file2 = new File(file, "public");
        File file3 = new File(file, "private");
        if (!file.exists() && !(bl = file.mkdirs())) {
            throw new UnableToCreateSecurityDirectoryIOException(file);
        }
        FileKeyPairProvider.writeKey(keyPair.getPublic(), file2);
        FileKeyPairProvider.writeKey(keyPair.getPrivate(), file3);
        if (!PlatformInfo.isWindows()) {
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Setting security directory to read only.");
            Files.setPosixFilePermissions(file3.toPath(), POSIX_OWNER_READ_ONLY);
            Files.setPosixFilePermissions(file.toPath(), POSIX_OWNER_WRITABLE_ONLY);
        }
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Wrote key pair to security dir " + file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Key readKey(File file) throws IOException, ClassNotFoundException {
        try (ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));){
            Key key = (Key)objectInputStream.readObject();
            return key;
        }
    }

    private static void writeKey(Key key, File file) throws IOException {
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));){
            objectOutputStream.writeObject(key);
        }
    }

    private static class CouldNotGenerateKeyPairException
    extends ModuleCreationException {
        CouldNotGenerateKeyPairException(Throwable throwable) {
            super(throwable);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new mjs.CouldNotGenerateKeyPair(this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new mjs.CouldNotGenerateKeyPair(this.getCause().getLocalizedMessage());
        }
    }

    private static final class IncorrectPermissionsException
    extends CryptoException {
        private final BaseMsgID fBaseMsgID;

        IncorrectPermissionsException(Path path) {
            this.fBaseMsgID = new mjs.IncorrectPermissionOnKeyFile(path.getFileName().toString());
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }
}

