/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.modules;

import com.mathworks.toolbox.distcomp.auth.CryptoModule;
import com.mathworks.toolbox.distcomp.auth.EncryptedObject;
import com.mathworks.toolbox.distcomp.auth.Erasable;
import java.io.Serializable;
import java.util.Random;

public final class CryptoModuleTrivialImpl
implements CryptoModule {
    private Random fRandom;

    @Override
    public CryptoModule.Encryptor getEncryptor() {
        return new TrivialEncryptor();
    }

    @Override
    public CryptoModule.Decryptor getDecryptor() {
        return new CryptoModule.Decryptor(){

            @Override
            public Erasable decrypt(EncryptedObject encryptedObject) {
                return new Erasable(encryptedObject.get());
            }

            @Override
            public Erasable decryptWithSalt(EncryptedObject encryptedObject, byte[] byArray) {
                return this.decrypt(encryptedObject);
            }
        };
    }

    @Override
    public byte[] createSalt(int n) {
        byte[] byArray = new byte[n];
        this.getRandom().nextBytes(byArray);
        return byArray;
    }

    private Random getRandom() {
        if (this.fRandom == null) {
            this.fRandom = new Random();
        }
        return this.fRandom;
    }

    private static class TrivialEncryptor
    implements CryptoModule.Encryptor,
    Serializable {
        private TrivialEncryptor() {
        }

        @Override
        public EncryptedObject encrypt(Erasable erasable) {
            return new EncryptedObject(erasable.get());
        }

        @Override
        public EncryptedObject encryptWithSalt(Erasable erasable, byte[] byArray) {
            return this.encrypt(erasable);
        }
    }
}

