/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.modules;

import com.mathworks.toolbox.distcomp.auth.AuthorisationModuleConfig;
import com.mathworks.toolbox.distcomp.auth.Erasable;
import com.mathworks.toolbox.distcomp.auth.InvalidPasswordException;
import com.mathworks.toolbox.distcomp.auth.RemoteAuthorisationModule;
import com.mathworks.toolbox.distcomp.auth.credentials.AuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CredentialConsumerConfig;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CurrentTokenReturn;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.NoCredentialsEnteredException;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.RememberChoice;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialStoreFactory;
import com.mathworks.toolbox.distcomp.auth.modules.AuthorisationModuleWithPasswordImpl;
import com.mathworks.toolbox.distcomp.auth.modules.DialogUnavailableException;
import com.mathworks.toolbox.distcomp.auth.modules.PackageInfo;
import com.mathworks.toolbox.distcomp.storage.StorageInitException;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.UnsupportedEncodingException;

public final class AuthorisationModuleGlobalPasswordlessImpl
extends AuthorisationModuleWithPasswordImpl {
    public AuthorisationModuleGlobalPasswordlessImpl(AuthorisationModuleConfig authorisationModuleConfig) throws StorageInitException {
        super(authorisationModuleConfig);
    }

    @Override
    protected void checkTokens(AuthenticationToken authenticationToken, AuthenticationToken authenticationToken2) throws InvalidPasswordException {
        if (!authenticationToken2.equals(AuthorisationModuleGlobalPasswordlessImpl.createSystemToken(authenticationToken2.getUserIdentity()))) {
            super.checkTokens(authenticationToken, authenticationToken2);
        }
    }

    @Override
    public RemoteAuthorisationModule getRemoteAuthorisationModule() {
        return new RemoteAMGlobalPasswordlessImpl(this.fConsumerConfig, this.fStoreFactory);
    }

    private static AuthenticationToken createSystemToken(UserIdentity userIdentity) {
        Erasable erasable;
        try {
            erasable = new Erasable("some random password".getBytes("UTF-16LE"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to create dummy Erasable", unsupportedEncodingException);
            throw new InvalidEncodingException(unsupportedEncodingException);
        }
        return new AuthenticationToken(userIdentity, erasable);
    }

    private static class InvalidEncodingException
    extends RuntimeException {
        InvalidEncodingException(UnsupportedEncodingException unsupportedEncodingException) {
            super(unsupportedEncodingException);
        }
    }

    private static class RemoteAMGlobalPasswordlessImpl
    extends AuthorisationModuleWithPasswordImpl.RemoteAMWithPasswordImpl {
        private static final long serialVersionUID = -5652964258270283283L;

        public RemoteAMGlobalPasswordlessImpl(CredentialConsumerConfig credentialConsumerConfig, CredentialStoreFactory credentialStoreFactory) {
            super(credentialConsumerConfig, credentialStoreFactory);
        }

        @Override
        public CurrentTokenReturn promptForCurrentPassword(UserIdentity userIdentity, Throwable throwable) throws DialogUnavailableException, NoCredentialsEnteredException {
            if (userIdentity.equals(UserIdentity.createDefaultUserIdentity())) {
                return new CurrentTokenReturn(AuthorisationModuleGlobalPasswordlessImpl.createSystemToken(userIdentity), RememberChoice.SESSION);
            }
            return super.promptForCurrentPassword(userIdentity, throwable);
        }
    }
}

