/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.credentials.store;

import com.mathworks.toolbox.distcomp.auth.CryptoException;
import com.mathworks.toolbox.distcomp.auth.CryptoModule;
import com.mathworks.toolbox.distcomp.auth.credentials.CredentialCreationException;
import com.mathworks.toolbox.distcomp.auth.credentials.NontransferableCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.TransferableCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialProviderLocal;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialProviderRemote;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialTransferException;
import com.mathworks.toolbox.distcomp.auth.credentials.store.NoCredentialsException;
import com.mathworks.toolbox.distcomp.auth.credentials.store.PackageInfo;
import com.mathworks.toolbox.distcomp.distcompobjects.DistcompProxy;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.logging.Level;

class CredentialStoreProxy
implements CredentialProviderLocal,
Serializable {
    private static final int SALT_LENGTH = 32;
    private final Serializable fCredentialProviderRemote;

    CredentialStoreProxy(CredentialProviderRemote credentialProviderRemote) throws DistcompProxy.SerializeProxyException {
        this.fCredentialProviderRemote = (Serializable)((Object)credentialProviderRemote);
    }

    @Override
    public NontransferableCredentials getCredentials(UserIdentity userIdentity, CryptoModule cryptoModule) throws CredentialTransferException, NoCredentialsException {
        try {
            byte[] byArray = cryptoModule.createSalt(32);
            TransferableCredentials transferableCredentials = ((CredentialProviderRemote)((Object)this.fCredentialProviderRemote)).getCredentials(userIdentity, byArray, cryptoModule.getEncryptor());
            return transferableCredentials.unpack(byArray, cryptoModule.getDecryptor());
        }
        catch (CryptoException | CredentialCreationException | RemoteException exception) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Failed to get credentials from remote provider. ", exception);
            throw new CredentialTransferException(userIdentity, (Throwable)exception);
        }
    }
}

