/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.credentials.consumer;

import com.mathworks.toolbox.distcomp.auth.CryptoModule;
import com.mathworks.toolbox.distcomp.auth.Erasable;
import com.mathworks.toolbox.distcomp.auth.credentials.PlainCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.ChangePasswordReturn;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CredentialConsumer;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CredentialConsumerConfig;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CurrentTokenReturn;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.NewPasswordReturn;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.NoCredentialsEnteredException;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.model.RememberChoice;
import java.util.Map;

public class AutomatedCredentialConsumer
implements CredentialConsumer {
    private final CryptoModule.Hasher fHasher;
    private final UserIdentity fAdminIdentity;
    private final Map<UserIdentity, Erasable> fPredefinedPasswordMap;
    private final UserIdentity fDefaultUserIdentity;

    public AutomatedCredentialConsumer(CredentialConsumerConfig credentialConsumerConfig, Map<UserIdentity, Erasable> map, UserIdentity userIdentity) {
        this.fHasher = credentialConsumerConfig.getHasher();
        this.fAdminIdentity = credentialConsumerConfig.getAdminUserIdentity();
        this.fPredefinedPasswordMap = map;
        this.fDefaultUserIdentity = userIdentity;
    }

    @Override
    public CurrentTokenReturn promptForCurrentPassword(UserIdentity userIdentity, Throwable throwable) throws NoCredentialsEnteredException {
        PlainCredentials plainCredentials = this.createPlainCredentials(userIdentity);
        return new CurrentTokenReturn(plainCredentials.createAuthenticationToken(this.fHasher), RememberChoice.ALWAYS);
    }

    @Override
    public NewPasswordReturn promptForNewPassword(UserIdentity userIdentity) throws NoCredentialsEnteredException {
        PlainCredentials plainCredentials = this.createPlainCredentials(userIdentity);
        return new NewPasswordReturn(plainCredentials, plainCredentials.createAuthenticationToken(this.fHasher), RememberChoice.ALWAYS);
    }

    @Override
    public ChangePasswordReturn promptForChangePassword(UserIdentity userIdentity, UserIdentity userIdentity2) throws NoCredentialsEnteredException {
        PlainCredentials plainCredentials = this.createPlainCredentials(userIdentity);
        PlainCredentials plainCredentials2 = this.createPlainCredentials(userIdentity2);
        return new ChangePasswordReturn(plainCredentials2.createAuthenticationToken(this.fHasher), plainCredentials, plainCredentials.createAuthenticationToken(this.fHasher), RememberChoice.ALWAYS);
    }

    @Override
    public CurrentTokenReturn promptForTemporaryUserSwitch(UserIdentity userIdentity) throws NoCredentialsEnteredException {
        PlainCredentials plainCredentials = this.createPlainCredentials(this.fAdminIdentity);
        return new CurrentTokenReturn(plainCredentials.createAuthenticationToken(this.fHasher), RememberChoice.ALWAYS);
    }

    @Override
    public UserIdentity promptForIdentity(UserIdentity userIdentity) {
        return this.fDefaultUserIdentity == null ? userIdentity : this.fDefaultUserIdentity;
    }

    private PlainCredentials createPlainCredentials(UserIdentity userIdentity) throws NoCredentialsEnteredException {
        if (this.fPredefinedPasswordMap.containsKey(userIdentity)) {
            return new PlainCredentials(userIdentity, this.fPredefinedPasswordMap.get(userIdentity).copy());
        }
        throw new NoCredentialsEnteredException(userIdentity);
    }
}

