/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.credentials;

import com.mathworks.toolbox.distcomp.auth.CryptoModule;
import com.mathworks.toolbox.distcomp.auth.credentials.AuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.CredentialCreationException;
import com.mathworks.toolbox.distcomp.auth.credentials.CredentialRole;
import com.mathworks.toolbox.distcomp.auth.credentials.EncryptedUserCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.NontransferableCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.TransferableCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import java.util.HashMap;
import java.util.Map;

public class UserCredentials
implements NontransferableCredentials {
    public static final UserCredentials AUTH_ONLY = new UserCredentials(new UserIdentity("nobody"));
    private UserIdentity fUserIdentity;
    private Map<CredentialRole, NontransferableCredentials> fCredentialsMap;

    public UserCredentials(UserIdentity userIdentity) {
        this.fUserIdentity = userIdentity;
        this.fCredentialsMap = new HashMap<CredentialRole, NontransferableCredentials>();
    }

    public UserCredentials(UserIdentity userIdentity, Map<CredentialRole, NontransferableCredentials> map) {
        this.fUserIdentity = userIdentity;
        this.fCredentialsMap = new HashMap<CredentialRole, NontransferableCredentials>(map);
    }

    @Override
    public UserIdentity getUserIdentity() {
        return this.fUserIdentity;
    }

    public void putCredentialsForRole(CredentialRole credentialRole, NontransferableCredentials nontransferableCredentials) {
        this.fCredentialsMap.put(credentialRole, nontransferableCredentials);
    }

    public NontransferableCredentials getCredentialsForRole(CredentialRole credentialRole) {
        return this.fCredentialsMap.get((Object)credentialRole);
    }

    public boolean hasCredentialsForRole(CredentialRole credentialRole) {
        return this.fCredentialsMap.containsKey((Object)credentialRole);
    }

    @Override
    public EncryptedUserCredentials prepare(boolean bl, byte[] byArray, CryptoModule.Encryptor encryptor) throws CredentialCreationException {
        HashMap<CredentialRole, TransferableCredentials> hashMap = new HashMap<CredentialRole, TransferableCredentials>();
        for (Map.Entry<CredentialRole, NontransferableCredentials> entry : this.fCredentialsMap.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().prepare(bl, byArray, encryptor));
        }
        return new EncryptedUserCredentials(this.fUserIdentity, hashMap);
    }

    @Override
    public void erase() {
        for (NontransferableCredentials nontransferableCredentials : this.fCredentialsMap.values()) {
            nontransferableCredentials.erase();
        }
    }

    static {
        AUTH_ONLY.putCredentialsForRole(CredentialRole.AUTH_TOKEN, AuthenticationToken.EMPTY);
    }
}

