/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.credentials;

import com.mathworks.toolbox.distcomp.auth.CryptoException;
import com.mathworks.toolbox.distcomp.auth.CryptoModule;
import com.mathworks.toolbox.distcomp.auth.EncryptedObject;
import com.mathworks.toolbox.distcomp.auth.Erasable;
import com.mathworks.toolbox.distcomp.auth.credentials.CredentialCreationException;
import com.mathworks.toolbox.distcomp.auth.credentials.EncryptFailedException;
import com.mathworks.toolbox.distcomp.auth.credentials.EncryptedLoginTokenCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.NontransferableCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.TransferableCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class LoginTokenCredentials
implements NontransferableCredentials {
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private final Erasable fLoginToken;
    private final UserIdentity fUserIdentity;

    public LoginTokenCredentials(UserIdentity userIdentity, String string) {
        this.fLoginToken = new Erasable(string.getBytes(CHARSET));
        this.fUserIdentity = userIdentity;
    }

    protected LoginTokenCredentials(UserIdentity userIdentity, Erasable erasable) {
        this.fLoginToken = erasable;
        this.fUserIdentity = userIdentity;
    }

    public String getLoginToken() {
        return new String(this.fLoginToken.get(), CHARSET);
    }

    @Override
    public TransferableCredentials prepare(boolean bl, byte[] byArray, CryptoModule.Encryptor encryptor) throws CredentialCreationException {
        if (!bl) {
            return new EncryptedLoginTokenCredentials(this.fUserIdentity, this.fLoginToken);
        }
        try {
            EncryptedObject encryptedObject = encryptor.encryptWithSalt(this.fLoginToken, byArray);
            return new EncryptedLoginTokenCredentials(this.fUserIdentity, encryptedObject, byArray);
        }
        catch (CryptoException cryptoException) {
            throw new EncryptFailedException(this.fUserIdentity, (Throwable)cryptoException);
        }
    }

    @Override
    public void erase() {
        this.fLoginToken.erase();
    }

    @Override
    public UserIdentity getUserIdentity() {
        return this.fUserIdentity;
    }

    public String toString() {
        return "LoginToken: " + this.getLoginToken();
    }
}

