/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.credentials;

import com.mathworks.toolbox.distcomp.auth.CryptoException;
import com.mathworks.toolbox.distcomp.auth.CryptoModule;
import com.mathworks.toolbox.distcomp.auth.EncryptedObject;
import com.mathworks.toolbox.distcomp.auth.Erasable;
import com.mathworks.toolbox.distcomp.auth.credentials.AuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.CredentialCreationException;
import com.mathworks.toolbox.distcomp.auth.credentials.DecryptFailedException;
import com.mathworks.toolbox.distcomp.auth.credentials.TransferableCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;

public final class EncryptedAuthenticationToken
implements TransferableCredentials {
    public static final EncryptedAuthenticationToken EMPTY = new EncryptedAuthenticationToken(new UserIdentity("nobody"), new Erasable());
    private final UserIdentity fUserIdentity;
    private final EncryptedObject fEncryptedToken;
    private final byte[] fSalt;
    private final boolean fEncrypted;

    public EncryptedAuthenticationToken(UserIdentity userIdentity, EncryptedObject encryptedObject, byte[] byArray) {
        this.fUserIdentity = userIdentity;
        this.fEncryptedToken = encryptedObject;
        this.fSalt = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.fSalt, 0, byArray.length);
        this.fEncrypted = true;
    }

    public EncryptedAuthenticationToken(UserIdentity userIdentity, Erasable erasable) {
        this.fUserIdentity = userIdentity;
        this.fEncryptedToken = new EncryptedObject(erasable.get());
        this.fSalt = new byte[0];
        this.fEncrypted = false;
    }

    @Override
    public UserIdentity getUserIdentity() {
        return this.fUserIdentity;
    }

    @Override
    public AuthenticationToken unpack(byte[] byArray, CryptoModule.Decryptor decryptor) throws CredentialCreationException {
        if (!this.fEncrypted) {
            return this.unpack();
        }
        try {
            Erasable erasable = decryptor.decryptWithSalt(this.fEncryptedToken, byArray);
            return new AuthenticationToken(this.fUserIdentity, erasable);
        }
        catch (CryptoException cryptoException) {
            throw new DecryptFailedException(this.fUserIdentity, (Throwable)cryptoException);
        }
    }

    public AuthenticationToken unpack() {
        Erasable erasable = new Erasable(this.fEncryptedToken.get());
        return new AuthenticationToken(this.fUserIdentity, erasable);
    }
}

