/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth;

import com.mathworks.toolbox.distcomp.auth.AuthorisationFailedException;
import com.mathworks.toolbox.distcomp.auth.RemoteAuthorisationModule;
import com.mathworks.toolbox.distcomp.auth.credentials.AuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.Credentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialProviderImpl;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialProviderLocal;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialStore;
import com.mathworks.toolbox.distcomp.auth.credentials.store.MultiUserCredentialStore;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.service.Exporter;
import com.mathworks.toolbox.distcomp.service.ExporterFactory;
import java.rmi.RemoteException;

public abstract class AbstractInvocationWithAuth<T> {
    private CredentialProviderLocal fCredentialProvider;
    private UserIdentity fUserIdentity;
    private boolean fInteractive;
    private ExporterFactory fExporterFactory;

    public AbstractInvocationWithAuth(UserIdentity userIdentity) {
        if (userIdentity == null) {
            throw new NullPointerException("User identity must not be null");
        }
        this.fUserIdentity = userIdentity;
        this.fInteractive = true;
    }

    public CredentialProviderLocal getCredentialProvider() {
        return this.fCredentialProvider;
    }

    public void setCredentialProvider(CredentialProviderLocal credentialProviderLocal) {
        this.fCredentialProvider = credentialProviderLocal;
    }

    public UserIdentity getUserIdentity() {
        return this.fUserIdentity;
    }

    public boolean isInteractive() {
        return this.fInteractive;
    }

    public void setInteractive(boolean bl) {
        this.fInteractive = bl;
    }

    public void setExporterFactory(ExporterFactory exporterFactory) {
        this.fExporterFactory = exporterFactory;
    }

    public abstract T makeInvocation(CredentialStore<AuthenticationToken> var1, RemoteAuthorisationModule var2) throws AuthorisationFailedException, RemoteException, MJSException;

    public abstract T invoke() throws RemoteException, MJSException;

    protected final <C extends Credentials> CredentialProviderImpl<C> makeCredentialProvider() {
        assert (this.fExporterFactory != null) : "ExporterFactory has not been set";
        MultiUserCredentialStore multiUserCredentialStore = new MultiUserCredentialStore();
        Exporter exporter = this.fExporterFactory.createExporter();
        return new CredentialProviderImpl(multiUserCredentialStore, exporter);
    }
}

