/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.swing.DocView;
import ice.pilots.html4.swing.Movable;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class FormInputUpload
extends JPanel
implements ObjectPainter,
DocumentListener,
Movable,
ActionListener {
    private DocView I;
    private DInputElement OEAB;
    private ObjectBox add;
    private JTextField addActionListener = null;
    private JButton addDocumentListener = null;
    private JInternalFrame black = null;
    private JFileChooser checkAwtTree = null;
    private int dispatchChange = 100;
    private String drawRect;

    FormInputUpload(DocView docView, DElement dElement) {
        this.I = docView;
        this.OEAB = (DInputElement)dElement;
        this.addActionListener = new JTextField();
        this.addDocumentListener = new JButton("Browse");
        this.checkAwtTree = new JFileChooser(".");
        this.black = new JInternalFrame();
        this.I();
        int n = this.OEAB.getAttributeAsInt("size");
        if (n <= 0) {
            n = 20;
        }
        this.addActionListener.setColumns(n);
        this.setLayout(new BorderLayout());
        this.add((Component)this.addActionListener, "Center");
        this.add((Component)this.addDocumentListener, "East");
        this.addActionListener.setBackground(Color.white);
        this.addActionListener.setFont(new Font("Monospaced", 0, 12));
        this.enableEvents(28L);
        this.addDocumentListener.addActionListener(this);
        this.addActionListener.getDocument().addDocumentListener(this);
        this.validateTree();
    }

    public void paintComponent(Graphics graphics) {
        if (this.isShowing()) {
            super.paintComponent(graphics);
        }
    }

    public void paintChildren(Graphics graphics) {
        if (this.isShowing()) {
            super.paintChildren(graphics);
        } else {
            this.addDocumentListener.setBounds(154, 5, 78, 26);
            this.addActionListener.setBounds(5, 7, 144, 21);
            graphics.setColor(Color.lightGray);
            graphics.drawRect(0, 0, this.addActionListener.getBounds().width + 2, this.addActionListener.getBounds().height + 2);
            graphics.translate(1, 1);
            this.addActionListener.paint(graphics);
            graphics.translate(this.addActionListener.getBounds().width + 2, -1);
            String string = this.addDocumentListener.getText();
            graphics.setFont(this.addDocumentListener.getFont());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            fontMetrics = ((Component)this).getFontMetrics(this.getFont());
            int n = fontMetrics.getDescent();
            int n2 = fontMetrics.stringWidth(string);
            graphics.setColor(Color.lightGray);
            graphics.fill3DRect(0, 0, this.addDocumentListener.getBounds().width, this.addDocumentListener.getBounds().height - 2, true);
            if (!this.OEAB.getDisabled()) {
                graphics.setColor(Color.black);
            } else {
                graphics.setColor(Color.gray);
            }
            graphics.drawString(string, (this.addDocumentListener.getBounds().width - n2) / 2, this.addDocumentListener.getBounds().height / 2 + n);
        }
    }

    private void I() {
        String string;
        this.addActionListener.setEditable(!this.OEAB.getReadOnly());
        this.addActionListener.setEnabled(!this.OEAB.getDisabled());
        int n = this.OEAB.getMaxLength();
        if (n != 0) {
            this.dispatchChange = n;
        }
        if ((string = this.OEAB.getValue()) != null && !string.equals(this.addActionListener.getText())) {
            this.addActionListener.setText(string);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.OEAB.setValue(this.addActionListener.getText());
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.OEAB.setValue(this.addActionListener.getText());
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.OEAB.setValue(this.addActionListener.getText());
    }

    public void onElementAttrChange(DElement dElement, DAttr dAttr) {
        this.I();
    }

    public void dispose() {
        Container container = this.getParent();
        if (container != null) {
            container.remove(this);
        }
    }

    public void setBox(ObjectBox objectBox) {
        this.add = objectBox;
        this.I.checkAwtTree(objectBox, this);
    }

    public ObjectBox getBox() {
        return this.add;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int n, int n2) {
        this.setSize(n, n2);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void draw(Graphics graphics) {
        if (this.isVisible()) {
            return;
        }
        graphics.setColor(Color.lightGray);
        graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
    }

    public void syncDom(int n, int n2, boolean bl) {
        this.setLocation(n, n2);
        if (!this.isValid()) {
            this.validate();
        }
        this.setVisible(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.checkAwtTree.showDialog(this.black, "Choose");
        String string = this.checkAwtTree.getSelectedFile().toString();
        this.addActionListener.setText(string);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (this.I.onComponentEvent(this, aWTEvent)) {
            super.processEvent(aWTEvent);
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        int n = focusEvent.getID();
        if (n == 1004) {
            this.OEAB(focusEvent);
        } else if (n == 1005) {
            this.add(focusEvent);
        }
        super.processFocusEvent(focusEvent);
    }

    private void OEAB(FocusEvent focusEvent) {
        if (this.drawRect == null) {
            this.drawRect = this.addActionListener.getText();
        }
    }

    private void add(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        String string = this.addActionListener.getText();
        if (!string.equals(this.drawRect)) {
            this.OEAB.dispatchChange();
        }
        this.drawRect = null;
    }

    public void setBorderVisible(boolean bl) {
    }

    public void setFontHints(CSSAttribs cSSAttribs) {
    }
}

