/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.util.ArrayQueue;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.ConfigurationProcessor;
import org.eclipse.jetty.xml.ConfigurationProcessorFactory;
import org.eclipse.jetty.xml.XmlParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlConfiguration {
    private static final Logger LOG = Log.getLogger(XmlConfiguration.class);
    private static final Class<?>[] __primitives = new Class[]{Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE};
    private static final Class<?>[] __primitiveHolders = new Class[]{Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Void.class};
    private static final Class<?>[] __supportedCollections = new Class[]{ArrayList.class, ArrayQueue.class, HashSet.class, Queue.class, List.class, Set.class, Collection.class};
    private static final Iterable<?> __factoryLoader;
    private static final XmlParser __parser;
    private URL _url;
    private String _dtd;
    private ConfigurationProcessor _processor;
    private final Map<String, Object> _idMap = new HashMap<String, Object>();
    private final Map<String, String> _propertyMap = new HashMap<String, String>();

    private static synchronized XmlParser initParser() {
        XmlParser parser = new XmlParser();
        URL config60 = Loader.getResource(XmlConfiguration.class, "org/eclipse/jetty/xml/configure_6_0.dtd", true);
        URL config76 = Loader.getResource(XmlConfiguration.class, "org/eclipse/jetty/xml/configure_7_6.dtd", true);
        parser.redirectEntity("configure.dtd", config76);
        parser.redirectEntity("configure_1_0.dtd", config60);
        parser.redirectEntity("configure_1_1.dtd", config60);
        parser.redirectEntity("configure_1_2.dtd", config60);
        parser.redirectEntity("configure_1_3.dtd", config60);
        parser.redirectEntity("configure_6_0.dtd", config60);
        parser.redirectEntity("configure_7_6.dtd", config76);
        parser.redirectEntity("http://jetty.mortbay.org/configure.dtd", config76);
        parser.redirectEntity("http://jetty.eclipse.org/configure.dtd", config76);
        parser.redirectEntity("http://www.eclipse.org/jetty/configure.dtd", config76);
        parser.redirectEntity("-//Mort Bay Consulting//DTD Configure//EN", config76);
        parser.redirectEntity("-//Jetty//Configure//EN", config76);
        return parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlConfiguration(URL configuration) throws SAXException, IOException {
        XmlParser xmlParser = __parser;
        synchronized (xmlParser) {
            this._url = configuration;
            this.setConfig(__parser.parse(configuration.toString()));
            this._dtd = __parser.getDTD();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlConfiguration(String configuration) throws SAXException, IOException {
        configuration = "<?xml version=\"1.0\"  encoding=\"ISO-8859-1\"?>\n<!DOCTYPE Configure PUBLIC \"-//Mort Bay Consulting//DTD Configure 1.2//EN\" \"http://jetty.eclipse.org/configure_1_2.dtd\">" + configuration;
        InputSource source = new InputSource(new StringReader(configuration));
        XmlParser xmlParser = __parser;
        synchronized (xmlParser) {
            this.setConfig(__parser.parse(source));
            this._dtd = __parser.getDTD();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlConfiguration(InputStream configuration) throws SAXException, IOException {
        InputSource source = new InputSource(configuration);
        XmlParser xmlParser = __parser;
        synchronized (xmlParser) {
            this.setConfig(__parser.parse(source));
            this._dtd = __parser.getDTD();
        }
    }

    private void setConfig(XmlParser.Node config) {
        if ("Configure".equals(config.getTag())) {
            this._processor = new JettyXmlConfiguration();
        } else if (__factoryLoader != null) {
            for (Object factory : __factoryLoader) {
                try {
                    Method gcp = factory.getClass().getMethod("getConfigurationProcessor", String.class, String.class);
                    this._processor = (ConfigurationProcessor)gcp.invoke(factory, this._dtd, config.getTag());
                }
                catch (Exception e2) {
                    LOG.warn(e2);
                }
                if (this._processor == null) continue;
                break;
            }
            if (this._processor == null) {
                throw new IllegalStateException("Unknown configuration type: " + config.getTag() + " in " + this);
            }
        } else {
            throw new IllegalArgumentException("Unknown XML tag:" + config.getTag());
        }
        this._processor.init(this._url, config, this._idMap, this._propertyMap);
    }

    public Map<String, Object> getIdMap() {
        return this._idMap;
    }

    @Deprecated
    public void setIdMap(Map<String, Object> map) {
        this._idMap.clear();
        this._idMap.putAll(map);
    }

    @Deprecated
    public void setProperties(Map<String, String> map) {
        this._propertyMap.clear();
        this._propertyMap.putAll(map);
    }

    public Map<String, String> getProperties() {
        return this._propertyMap;
    }

    public Object configure(Object obj) throws Exception {
        return this._processor.configure(obj);
    }

    public Object configure() throws Exception {
        return this._processor.configure();
    }

    public static void main(final String[] args) throws Exception {
        final AtomicReference exception = new AtomicReference();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    int i2;
                    Properties properties = null;
                    try {
                        Class<?> config = XmlConfiguration.class.getClassLoader().loadClass("org.eclipse.jetty.start.Config");
                        properties = (Properties)config.getMethod("getProperties", new Class[0]).invoke(null, new Object[0]);
                        LOG.debug("org.eclipse.jetty.start.Config properties = {}", properties);
                    }
                    catch (NoClassDefFoundError e2) {
                        LOG.ignore(e2);
                    }
                    catch (ClassNotFoundException e3) {
                        LOG.ignore(e3);
                    }
                    catch (Exception e4) {
                        LOG.warn(e4);
                    }
                    if (properties == null) {
                        properties = new Properties();
                        Enumeration<?> ensysprop = System.getProperties().propertyNames();
                        while (ensysprop.hasMoreElements()) {
                            String name = (String)ensysprop.nextElement();
                            properties.put(name, System.getProperty(name));
                        }
                    }
                    XmlConfiguration last = null;
                    Object[] obj = new Object[args.length];
                    for (i2 = 0; i2 < args.length; ++i2) {
                        if (args[i2].toLowerCase(Locale.ENGLISH).endsWith(".properties")) {
                            properties.load(Resource.newResource(args[i2]).getInputStream());
                            continue;
                        }
                        XmlConfiguration configuration = new XmlConfiguration(Resource.newResource(args[i2]).getURL());
                        if (last != null) {
                            configuration.getIdMap().putAll(last.getIdMap());
                        }
                        if (properties.size() > 0) {
                            HashMap<String, String> props = new HashMap<String, String>();
                            for (Object key : properties.keySet()) {
                                props.put(key.toString(), String.valueOf(properties.get(key)));
                            }
                            configuration.getProperties().putAll(props);
                        }
                        obj[i2] = configuration.configure();
                        last = configuration;
                    }
                    for (i2 = 0; i2 < args.length; ++i2) {
                        LifeCycle lc;
                        if (!(obj[i2] instanceof LifeCycle) || (lc = (LifeCycle)obj[i2]).isRunning()) continue;
                        lc.start();
                    }
                }
                catch (Exception e5) {
                    LOG.debug("EXCEPTION ", e5);
                    exception.set(e5);
                }
                return null;
            }
        });
        Throwable th = (Throwable)exception.get();
        if (th != null) {
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            if (th instanceof Exception) {
                throw (Exception)th;
            }
            if (th instanceof Error) {
                throw (Error)th;
            }
            throw new Error(th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        __parser = XmlConfiguration.initParser();
        Iterable loader = null;
        try {
            Class<?> slc = ClassLoader.getSystemClassLoader().loadClass("java.util.ServiceLoader");
            Method load = slc.getMethod("load", Class.class);
            loader = (Iterable)load.invoke(null, ConfigurationProcessorFactory.class);
        }
        catch (Exception e2) {
            LOG.ignore(e2);
        }
        finally {
            __factoryLoader = loader;
        }
    }

    private static class JettyXmlConfiguration
    implements ConfigurationProcessor {
        XmlParser.Node _config;
        Map<String, Object> _idMap;
        Map<String, String> _propertyMap;

        private JettyXmlConfiguration() {
        }

        @Override
        public void init(URL url, XmlParser.Node config, Map<String, Object> idMap, Map<String, String> properties) {
            this._config = config;
            this._idMap = idMap;
            this._propertyMap = properties;
        }

        @Override
        public Object configure(Object obj) throws Exception {
            Class<?> oClass = JettyXmlConfiguration.nodeClass(this._config);
            if (oClass != null && !oClass.isInstance(obj)) {
                String loaders = oClass.getClassLoader() == obj.getClass().getClassLoader() ? "" : "Object Class and type Class are from different loaders.";
                throw new IllegalArgumentException("Object of class '" + obj.getClass().getCanonicalName() + "' is not of type '" + oClass.getCanonicalName() + "'. " + loaders);
            }
            this.configure(obj, this._config, 0);
            return obj;
        }

        @Override
        public Object configure() throws Exception {
            Object obj;
            Class<?> oClass = JettyXmlConfiguration.nodeClass(this._config);
            String id = this._config.getAttribute("id");
            Object object = obj = id == null ? null : this._idMap.get(id);
            if (obj == null && oClass != null) {
                obj = oClass.newInstance();
            }
            if (oClass != null && !oClass.isInstance(obj)) {
                throw new ClassCastException(oClass.toString());
            }
            this.configure(obj, this._config, 0);
            return obj;
        }

        private static Class<?> nodeClass(XmlParser.Node node) throws ClassNotFoundException {
            String className = node.getAttribute("class");
            if (className == null) {
                return null;
            }
            return Loader.loadClass(XmlConfiguration.class, className, true);
        }

        public void configure(Object obj, XmlParser.Node cfg, int i2) throws Exception {
            String id = cfg.getAttribute("id");
            if (id != null) {
                this._idMap.put(id, obj);
            }
            while (i2 < cfg.size()) {
                block13: {
                    Object o2 = cfg.get(i2);
                    if (!(o2 instanceof String)) {
                        XmlParser.Node node = (XmlParser.Node)o2;
                        try {
                            String tag = node.getTag();
                            if ("Set".equals(tag)) {
                                this.set(obj, node);
                                break block13;
                            }
                            if ("Put".equals(tag)) {
                                this.put(obj, node);
                                break block13;
                            }
                            if ("Call".equals(tag)) {
                                this.call(obj, node);
                                break block13;
                            }
                            if ("Get".equals(tag)) {
                                this.get(obj, node);
                                break block13;
                            }
                            if ("New".equals(tag)) {
                                this.newObj(obj, node);
                                break block13;
                            }
                            if ("Array".equals(tag)) {
                                this.newArray(obj, node);
                                break block13;
                            }
                            if ("Ref".equals(tag)) {
                                this.refObj(obj, node);
                                break block13;
                            }
                            if ("Property".equals(tag)) {
                                this.propertyObj(node);
                                break block13;
                            }
                            throw new IllegalStateException("Unknown tag: " + tag);
                        }
                        catch (Exception e2) {
                            LOG.warn("Config error at " + node, e2.toString());
                            throw e2;
                        }
                    }
                }
                ++i2;
            }
        }

        private void set(Object obj, XmlParser.Node node) throws Exception {
            String attr = node.getAttribute("name");
            String name = "set" + attr.substring(0, 1).toUpperCase(Locale.ENGLISH) + attr.substring(1);
            Object value = this.value(obj, node);
            Object[] arg = new Object[]{value};
            Class<?> oClass = JettyXmlConfiguration.nodeClass(node);
            if (oClass != null) {
                obj = null;
            } else {
                oClass = obj.getClass();
            }
            Class[] vClass = new Class[]{Object.class};
            if (value != null) {
                vClass[0] = value.getClass();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("XML " + (obj != null ? obj.toString() : oClass.getName()) + "." + name + "(" + value + ")", new Object[0]);
            }
            try {
                Method set = oClass.getMethod(name, vClass);
                set.invoke(obj, arg);
                return;
            }
            catch (IllegalArgumentException e2) {
                LOG.ignore(e2);
            }
            catch (IllegalAccessException e3) {
                LOG.ignore(e3);
            }
            catch (NoSuchMethodException e4) {
                LOG.ignore(e4);
            }
            try {
                Field type = vClass[0].getField("TYPE");
                vClass[0] = (Class)type.get(null);
                Method set = oClass.getMethod(name, vClass);
                set.invoke(obj, arg);
                return;
            }
            catch (NoSuchFieldException e5) {
                LOG.ignore(e5);
            }
            catch (IllegalArgumentException e6) {
                LOG.ignore(e6);
            }
            catch (IllegalAccessException e7) {
                LOG.ignore(e7);
            }
            catch (NoSuchMethodException e8) {
                LOG.ignore(e8);
            }
            try {
                Field field = oClass.getField(attr);
                if (Modifier.isPublic(field.getModifiers())) {
                    field.set(obj, value);
                    return;
                }
            }
            catch (NoSuchFieldException e9) {
                LOG.ignore(e9);
            }
            Method[] sets = oClass.getMethods();
            Method set = null;
            for (int s = 0; sets != null && s < sets.length; ++s) {
                Class<?>[] paramTypes = sets[s].getParameterTypes();
                if (!name.equals(sets[s].getName()) || paramTypes.length != 1) continue;
                try {
                    set = sets[s];
                    sets[s].invoke(obj, arg);
                    return;
                }
                catch (IllegalArgumentException e10) {
                    LOG.ignore(e10);
                }
                catch (IllegalAccessException e11) {
                    LOG.ignore(e11);
                }
                try {
                    for (Class c2 : __supportedCollections) {
                        if (!paramTypes[0].isAssignableFrom(c2)) continue;
                        sets[s].invoke(obj, JettyXmlConfiguration.convertArrayToCollection(value, c2));
                        return;
                    }
                    continue;
                }
                catch (IllegalAccessException e12) {
                    LOG.ignore(e12);
                }
            }
            if (set != null) {
                try {
                    Class sClass = set.getParameterTypes()[0];
                    if (sClass.isPrimitive()) {
                        for (int t = 0; t < __primitives.length; ++t) {
                            if (!sClass.equals(__primitives[t])) continue;
                            sClass = __primitiveHolders[t];
                            break;
                        }
                    }
                    Constructor<?> cons = sClass.getConstructor(vClass);
                    arg[0] = cons.newInstance(arg);
                    set.invoke(obj, arg);
                    return;
                }
                catch (NoSuchMethodException e13) {
                    LOG.ignore(e13);
                }
                catch (IllegalAccessException e14) {
                    LOG.ignore(e14);
                }
                catch (InstantiationException e15) {
                    LOG.ignore(e15);
                }
            }
            throw new NoSuchMethodException(oClass + "." + name + "(" + vClass[0] + ")");
        }

        private static Collection<?> convertArrayToCollection(Object array, Class<?> collectionType) {
            AbstractCollection collection = null;
            if (array.getClass().isArray()) {
                if (collectionType.isAssignableFrom(ArrayList.class)) {
                    collection = JettyXmlConfiguration.convertArrayToArrayList(array);
                } else if (collectionType.isAssignableFrom(HashSet.class)) {
                    collection = new HashSet<Object>(JettyXmlConfiguration.convertArrayToArrayList(array));
                } else if (collectionType.isAssignableFrom(ArrayQueue.class)) {
                    ArrayQueue<Object> q = new ArrayQueue<Object>();
                    q.addAll(JettyXmlConfiguration.convertArrayToArrayList(array));
                    collection = q;
                }
            }
            if (collection == null) {
                throw new IllegalArgumentException("Can't convert \"" + array.getClass() + "\" to " + collectionType);
            }
            return collection;
        }

        private static ArrayList<Object> convertArrayToArrayList(Object array) {
            int length = Array.getLength(array);
            ArrayList<Object> list = new ArrayList<Object>(length);
            for (int i2 = 0; i2 < length; ++i2) {
                list.add(Array.get(array, i2));
            }
            return list;
        }

        private void put(Object obj, XmlParser.Node node) throws Exception {
            if (!(obj instanceof Map)) {
                throw new IllegalArgumentException("Object for put is not a Map: " + obj);
            }
            Map map = (Map)obj;
            String name = node.getAttribute("name");
            Object value = this.value(obj, node);
            map.put(name, value);
            if (LOG.isDebugEnabled()) {
                LOG.debug("XML " + obj + ".put(" + name + "," + value + ")", new Object[0]);
            }
        }

        private Object get(Object obj, XmlParser.Node node) throws Exception {
            Class<?> oClass = JettyXmlConfiguration.nodeClass(node);
            if (oClass != null) {
                obj = null;
            } else {
                oClass = obj.getClass();
            }
            String name = node.getAttribute("name");
            String id = node.getAttribute("id");
            if (LOG.isDebugEnabled()) {
                LOG.debug("XML get " + name, new Object[0]);
            }
            try {
                Method method = oClass.getMethod("get" + name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1), null);
                obj = method.invoke(obj, (Object[])null);
                this.configure(obj, node, 0);
            }
            catch (NoSuchMethodException nsme) {
                try {
                    Field field = oClass.getField(name);
                    obj = field.get(obj);
                    this.configure(obj, node, 0);
                }
                catch (NoSuchFieldException nsfe) {
                    throw nsme;
                }
            }
            if (id != null) {
                this._idMap.put(id, obj);
            }
            return obj;
        }

        private Object call(Object obj, XmlParser.Node node) throws Exception {
            String id = node.getAttribute("id");
            Class<?> oClass = JettyXmlConfiguration.nodeClass(node);
            if (oClass != null) {
                obj = null;
            } else if (obj != null) {
                oClass = obj.getClass();
            }
            if (oClass == null) {
                throw new IllegalArgumentException(node.toString());
            }
            int size = 0;
            int argi = node.size();
            for (int i2 = 0; i2 < node.size(); ++i2) {
                Object o2 = node.get(i2);
                if (o2 instanceof String) continue;
                if (!((XmlParser.Node)o2).getTag().equals("Arg")) {
                    argi = i2;
                    break;
                }
                ++size;
            }
            Object[] arg = new Object[size];
            int i3 = 0;
            int j2 = 0;
            while (j2 < size) {
                Object o3 = node.get(i3);
                if (!(o3 instanceof String)) {
                    arg[j2++] = this.value(obj, (XmlParser.Node)o3);
                }
                ++i3;
            }
            String method = node.getAttribute("name");
            if (LOG.isDebugEnabled()) {
                LOG.debug("XML call " + method, new Object[0]);
            }
            try {
                Object n2 = TypeUtil.call(oClass, method, obj, arg);
                if (id != null) {
                    this._idMap.put(id, n2);
                }
                this.configure(n2, node, argi);
                return n2;
            }
            catch (NoSuchMethodException e2) {
                IllegalStateException ise = new IllegalStateException("No Method: " + node + " on " + oClass);
                ise.initCause(e2);
                throw ise;
            }
        }

        private Object newObj(Object obj, XmlParser.Node node) throws Exception {
            Class<?> oClass = JettyXmlConfiguration.nodeClass(node);
            String id = node.getAttribute("id");
            int size = 0;
            int argi = node.size();
            for (int i2 = 0; i2 < node.size(); ++i2) {
                Object o2 = node.get(i2);
                if (o2 instanceof String) continue;
                if (!((XmlParser.Node)o2).getTag().equals("Arg")) {
                    argi = i2;
                    break;
                }
                ++size;
            }
            Object[] arg = new Object[size];
            int i3 = 0;
            int j2 = 0;
            while (j2 < size) {
                Object o3 = node.get(i3);
                if (!(o3 instanceof String)) {
                    arg[j2++] = this.value(obj, (XmlParser.Node)o3);
                }
                ++i3;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("XML new " + oClass, new Object[0]);
            }
            Constructor<?>[] constructors = oClass.getConstructors();
            for (int c2 = 0; constructors != null && c2 < constructors.length; ++c2) {
                if (constructors[c2].getParameterTypes().length != size) continue;
                Object n2 = null;
                boolean called = false;
                try {
                    n2 = constructors[c2].newInstance(arg);
                    called = true;
                }
                catch (IllegalAccessException e2) {
                    LOG.ignore(e2);
                }
                catch (InstantiationException e3) {
                    LOG.ignore(e3);
                }
                catch (IllegalArgumentException e4) {
                    LOG.ignore(e4);
                }
                if (!called) continue;
                if (id != null) {
                    this._idMap.put(id, n2);
                }
                this.configure(n2, node, argi);
                return n2;
            }
            throw new IllegalStateException("No Constructor: " + node + " on " + obj);
        }

        private Object refObj(Object obj, XmlParser.Node node) throws Exception {
            String id = node.getAttribute("id");
            obj = this._idMap.get(id);
            if (obj == null) {
                throw new IllegalStateException("No object for id=" + id);
            }
            this.configure(obj, node, 0);
            return obj;
        }

        private Object newArray(Object obj, XmlParser.Node node) throws Exception {
            Class aClass = Object.class;
            String type = node.getAttribute("type");
            String id = node.getAttribute("id");
            if (type != null && (aClass = TypeUtil.fromName(type)) == null) {
                aClass = "String".equals(type) ? String.class : ("URL".equals(type) ? URL.class : ("InetAddress".equals(type) ? InetAddress.class : Loader.loadClass(XmlConfiguration.class, type, true)));
            }
            Object al = null;
            for (Object nodeObject : node) {
                XmlParser.Node item = (XmlParser.Node)nodeObject;
                String nid = item.getAttribute("id");
                Object v = this.value(obj, item);
                al = LazyList.add(al, v == null && aClass.isPrimitive() ? Integer.valueOf(0) : v);
                if (nid == null) continue;
                this._idMap.put(nid, v);
            }
            Object array = LazyList.toArray(al, aClass);
            if (id != null) {
                this._idMap.put(id, array);
            }
            return array;
        }

        private Object newMap(Object obj, XmlParser.Node node) throws Exception {
            String id = node.getAttribute("id");
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            if (id != null) {
                this._idMap.put(id, map);
            }
            for (Object o2 : node) {
                if (o2 instanceof String) continue;
                XmlParser.Node entry = (XmlParser.Node)o2;
                if (!entry.getTag().equals("Entry")) {
                    throw new IllegalStateException("Not an Entry");
                }
                XmlParser.Node key = null;
                XmlParser.Node value = null;
                for (Object object : entry) {
                    if (object instanceof String) continue;
                    XmlParser.Node item = (XmlParser.Node)object;
                    if (!item.getTag().equals("Item")) {
                        throw new IllegalStateException("Not an Item");
                    }
                    if (key == null) {
                        key = item;
                        continue;
                    }
                    value = item;
                }
                if (key == null || value == null) {
                    throw new IllegalStateException("Missing Item in Entry");
                }
                String kid = key.getAttribute("id");
                String vid = value.getAttribute("id");
                Object k2 = this.value(obj, key);
                Object v = this.value(obj, value);
                map.put(k2, v);
                if (kid != null) {
                    this._idMap.put(kid, k2);
                }
                if (vid == null) continue;
                this._idMap.put(vid, v);
            }
            return map;
        }

        private Object propertyObj(XmlParser.Node node) throws Exception {
            String id = node.getAttribute("id");
            String name = node.getAttribute("name");
            String defaultValue = node.getAttribute("default");
            String prop = this._propertyMap != null && this._propertyMap.containsKey(name) ? this._propertyMap.get(name) : defaultValue;
            if (id != null) {
                this._idMap.put(id, prop);
            }
            if (prop != null) {
                this.configure(prop, node, 0);
            }
            return prop;
        }

        private Object value(Object obj, XmlParser.Node node) throws Exception {
            Object value;
            String type = node.getAttribute("type");
            String ref = node.getAttribute("ref");
            if (ref != null) {
                value = this._idMap.get(ref);
            } else {
                int first;
                if (node.size() == 0) {
                    if ("String".equals(type)) {
                        return "";
                    }
                    return null;
                }
                int last = node.size() - 1;
                if (type == null || !"String".equals(type)) {
                    Object item;
                    for (first = 0; first <= last && (item = node.get(first)) instanceof String && ((String)(item = ((String)item).trim())).length() <= 0; ++first) {
                    }
                    while (first < last && (item = node.get(last)) instanceof String && ((String)(item = ((String)item).trim())).length() <= 0) {
                        --last;
                    }
                    if (first > last) {
                        return null;
                    }
                }
                if (first == last) {
                    value = this.itemValue(obj, node.get(first));
                } else {
                    StringBuilder buf = new StringBuilder();
                    for (int i2 = first; i2 <= last; ++i2) {
                        Object item = node.get(i2);
                        buf.append(this.itemValue(obj, item));
                    }
                    value = buf.toString();
                }
            }
            if (value == null) {
                if ("String".equals(type)) {
                    return "";
                }
                return null;
            }
            if (type == null) {
                if (value instanceof String) {
                    return ((String)value).trim();
                }
                return value;
            }
            if (JettyXmlConfiguration.isTypeMatchingClass(type, String.class)) {
                return value.toString();
            }
            Class<?> pClass = TypeUtil.fromName(type);
            if (pClass != null) {
                return TypeUtil.valueOf(pClass, value.toString());
            }
            if (JettyXmlConfiguration.isTypeMatchingClass(type, URL.class)) {
                if (value instanceof URL) {
                    return value;
                }
                try {
                    return new URL(value.toString());
                }
                catch (MalformedURLException e2) {
                    throw new InvocationTargetException(e2);
                }
            }
            if (JettyXmlConfiguration.isTypeMatchingClass(type, InetAddress.class)) {
                if (value instanceof InetAddress) {
                    return value;
                }
                try {
                    return InetAddress.getByName(value.toString());
                }
                catch (UnknownHostException e3) {
                    throw new InvocationTargetException(e3);
                }
            }
            for (Class collectionClass : __supportedCollections) {
                if (!JettyXmlConfiguration.isTypeMatchingClass(type, collectionClass)) continue;
                return JettyXmlConfiguration.convertArrayToCollection(value, collectionClass);
            }
            throw new IllegalStateException("Unknown type " + type);
        }

        private static boolean isTypeMatchingClass(String type, Class<?> classToMatch) {
            return classToMatch.getSimpleName().equalsIgnoreCase(type) || classToMatch.getName().equals(type);
        }

        private Object itemValue(Object obj, Object item) throws Exception {
            if (item instanceof String) {
                return item;
            }
            XmlParser.Node node = (XmlParser.Node)item;
            String tag = node.getTag();
            if ("Call".equals(tag)) {
                return this.call(obj, node);
            }
            if ("Get".equals(tag)) {
                return this.get(obj, node);
            }
            if ("New".equals(tag)) {
                return this.newObj(obj, node);
            }
            if ("Ref".equals(tag)) {
                return this.refObj(obj, node);
            }
            if ("Array".equals(tag)) {
                return this.newArray(obj, node);
            }
            if ("Map".equals(tag)) {
                return this.newMap(obj, node);
            }
            if ("Property".equals(tag)) {
                return this.propertyObj(node);
            }
            if ("SystemProperty".equals(tag)) {
                String name = node.getAttribute("name");
                String defaultValue = node.getAttribute("default");
                return System.getProperty(name, defaultValue);
            }
            if ("Env".equals(tag)) {
                String name = node.getAttribute("name");
                String defaultValue = node.getAttribute("default");
                String value = System.getenv(name);
                return value == null ? defaultValue : value;
            }
            LOG.warn("Unknown value tag: " + node, new Throwable());
            return null;
        }
    }
}

