/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.jetty.io.AbstractBuffer;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.util.StringUtil;

public class ByteArrayBuffer
extends AbstractBuffer {
    protected final byte[] _bytes;

    protected ByteArrayBuffer(int size, int access, boolean isVolatile) {
        this(new byte[size], 0, 0, access, isVolatile);
    }

    public ByteArrayBuffer(byte[] bytes) {
        this(bytes, 0, bytes.length, 2);
    }

    public ByteArrayBuffer(byte[] bytes, int index, int length) {
        this(bytes, index, length, 2);
    }

    public ByteArrayBuffer(byte[] bytes, int index, int length, int access) {
        super(2, false);
        this._bytes = bytes;
        this.setPutIndex(index + length);
        this.setGetIndex(index);
        this._access = access;
    }

    public ByteArrayBuffer(byte[] bytes, int index, int length, int access, boolean isVolatile) {
        super(2, isVolatile);
        this._bytes = bytes;
        this.setPutIndex(index + length);
        this.setGetIndex(index);
        this._access = access;
    }

    public ByteArrayBuffer(int size) {
        this(new byte[size], 0, 0, 2);
        this.setPutIndex(0);
    }

    public ByteArrayBuffer(String value) {
        super(2, false);
        this._bytes = StringUtil.getBytes(value);
        this.setGetIndex(0);
        this.setPutIndex(this._bytes.length);
        this._access = 0;
        this._string = value;
    }

    public ByteArrayBuffer(String value, boolean immutable) {
        super(2, false);
        this._bytes = StringUtil.getBytes(value);
        this.setGetIndex(0);
        this.setPutIndex(this._bytes.length);
        if (immutable) {
            this._access = 0;
            this._string = value;
        }
    }

    public ByteArrayBuffer(String value, String encoding) throws UnsupportedEncodingException {
        super(2, false);
        this._bytes = value.getBytes(encoding);
        this.setGetIndex(0);
        this.setPutIndex(this._bytes.length);
        this._access = 0;
        this._string = value;
    }

    @Override
    public byte[] array() {
        return this._bytes;
    }

    @Override
    public int capacity() {
        return this._bytes.length;
    }

    @Override
    public void compact() {
        int s;
        if (this.isReadOnly()) {
            throw new IllegalStateException("READONLY");
        }
        int n2 = s = this.markIndex() >= 0 ? this.markIndex() : this.getIndex();
        if (s > 0) {
            int length = this.putIndex() - s;
            if (length > 0) {
                System.arraycopy(this._bytes, s, this._bytes, 0, length);
            }
            if (this.markIndex() > 0) {
                this.setMarkIndex(this.markIndex() - s);
            }
            this.setGetIndex(this.getIndex() - s);
            this.setPutIndex(this.putIndex() - s);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Buffer)) {
            return false;
        }
        if (obj instanceof Buffer.CaseInsensitve) {
            return this.equalsIgnoreCase((Buffer)obj);
        }
        Buffer b2 = (Buffer)obj;
        if (b2.length() != this.length()) {
            return false;
        }
        if (this._hash != 0 && obj instanceof AbstractBuffer) {
            AbstractBuffer ab = (AbstractBuffer)obj;
            if (ab._hash != 0 && this._hash != ab._hash) {
                return false;
            }
        }
        int get = this.getIndex();
        int bi = b2.putIndex();
        int i2 = this.putIndex();
        while (i2-- > get) {
            byte b22;
            byte b1 = this._bytes[i2];
            if (b1 == (b22 = b2.peek(--bi))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsIgnoreCase(Buffer b2) {
        if (b2 == this) {
            return true;
        }
        if (b2 == null || b2.length() != this.length()) {
            return false;
        }
        if (this._hash != 0 && b2 instanceof AbstractBuffer) {
            AbstractBuffer ab = (AbstractBuffer)b2;
            if (ab._hash != 0 && this._hash != ab._hash) {
                return false;
            }
        }
        int get = this.getIndex();
        int bi = b2.putIndex();
        byte[] barray = b2.array();
        if (barray == null) {
            int i2 = this.putIndex();
            while (i2-- > get) {
                byte b22;
                byte b1 = this._bytes[i2];
                if (b1 == (b22 = b2.peek(--bi))) continue;
                if (97 <= b1 && b1 <= 122) {
                    b1 = (byte)(b1 - 97 + 65);
                }
                if (97 <= b22 && b22 <= 122) {
                    b22 = (byte)(b22 - 97 + 65);
                }
                if (b1 == b22) continue;
                return false;
            }
        } else {
            int i3 = this.putIndex();
            while (i3-- > get) {
                byte b23;
                byte b1 = this._bytes[i3];
                if (b1 == (b23 = barray[--bi])) continue;
                if (97 <= b1 && b1 <= 122) {
                    b1 = (byte)(b1 - 97 + 65);
                }
                if (97 <= b23 && b23 <= 122) {
                    b23 = (byte)(b23 - 97 + 65);
                }
                if (b1 == b23) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public byte get() {
        return this._bytes[this._get++];
    }

    @Override
    public int hashCode() {
        if (this._hash == 0 || this._hashGet != this._get || this._hashPut != this._put) {
            int get = this.getIndex();
            int i2 = this.putIndex();
            while (i2-- > get) {
                byte b2 = this._bytes[i2];
                if (97 <= b2 && b2 <= 122) {
                    b2 = (byte)(b2 - 97 + 65);
                }
                this._hash = 31 * this._hash + b2;
            }
            if (this._hash == 0) {
                this._hash = -1;
            }
            this._hashGet = this._get;
            this._hashPut = this._put;
        }
        return this._hash;
    }

    @Override
    public byte peek(int index) {
        return this._bytes[index];
    }

    @Override
    public int peek(int index, byte[] b2, int offset, int length) {
        int l2 = length;
        if (index + l2 > this.capacity() && (l2 = this.capacity() - index) == 0) {
            return -1;
        }
        if (l2 < 0) {
            return -1;
        }
        System.arraycopy(this._bytes, index, b2, offset, l2);
        return l2;
    }

    @Override
    public void poke(int index, byte b2) {
        this._bytes[index] = b2;
    }

    @Override
    public int poke(int index, Buffer src) {
        byte[] src_array;
        this._hash = 0;
        int length = src.length();
        if (index + length > this.capacity()) {
            length = this.capacity() - index;
        }
        if ((src_array = src.array()) != null) {
            System.arraycopy(src_array, src.getIndex(), this._bytes, index, length);
        } else {
            int s = src.getIndex();
            for (int i2 = 0; i2 < length; ++i2) {
                this._bytes[index++] = src.peek(s++);
            }
        }
        return length;
    }

    @Override
    public int poke(int index, byte[] b2, int offset, int length) {
        this._hash = 0;
        if (index + length > this.capacity()) {
            length = this.capacity() - index;
        }
        System.arraycopy(b2, offset, this._bytes, index, length);
        return length;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        out.write(this._bytes, this.getIndex(), this.length());
        if (!this.isImmutable()) {
            this.clear();
        }
    }

    @Override
    public int readFrom(InputStream in, int max) throws IOException {
        if (max < 0 || max > this.space()) {
            max = this.space();
        }
        int p2 = this.putIndex();
        int len = 0;
        int total = 0;
        int available = max;
        while (total < max && (len = in.read(this._bytes, p2, available)) >= 0) {
            if (len > 0) {
                total += len;
                available -= len;
                this.setPutIndex(p2 += len);
            }
            if (in.available() > 0) continue;
        }
        if (len < 0 && total == 0) {
            return -1;
        }
        return total;
    }

    @Override
    public int space() {
        return this._bytes.length - this._put;
    }

    public static class CaseInsensitive
    extends ByteArrayBuffer
    implements Buffer.CaseInsensitve {
        public CaseInsensitive(String s) {
            super(s);
        }

        public CaseInsensitive(byte[] b2, int o2, int l2, int rw) {
            super(b2, o2, l2, rw);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof Buffer && this.equalsIgnoreCase((Buffer)obj);
        }
    }
}

