/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.websocket.client;

import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.cometd.bayeux.Message;
import org.cometd.client.transport.HttpClientTransport;
import org.cometd.client.transport.MessageClientTransport;
import org.cometd.client.transport.TransportListener;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketClient;
import org.eclipse.jetty.websocket.WebSocketClientFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSocketTransport
extends HttpClientTransport
implements MessageClientTransport {
    public static final String PREFIX = "ws";
    public static final String NAME = "websocket";
    public static final String PROTOCOL_OPTION = "protocol";
    public static final String CONNECT_TIMEOUT_OPTION = "connectTimeout";
    public static final String IDLE_TIMEOUT_OPTION = "idleTimeout";
    public static final String MAX_MESSAGE_SIZE_OPTION = "maxMessageSize";
    private final WebSocket _websocket = new CometDWebSocket();
    private final Map<String, WebSocketExchange> _metaExchanges = new ConcurrentHashMap<String, WebSocketExchange>();
    private final WebSocketClientFactory _webSocketClientFactory;
    private volatile ScheduledExecutorService _scheduler;
    private volatile boolean _shutdownScheduler;
    private volatile String _protocol = "cometd";
    private volatile long _maxNetworkDelay = 15000L;
    private volatile long _connectTimeout = 30000L;
    private volatile int _idleTimeout = 60000;
    private volatile int _maxMessageSize;
    private volatile boolean _connected;
    private volatile boolean _disconnected;
    private volatile boolean _aborted;
    private volatile boolean _webSocketSupported = true;
    private volatile WebSocket.Connection _connection;
    private volatile TransportListener _listener;
    private volatile Map<String, Object> _advice;

    public static WebSocketTransport create(Map<String, Object> options, WebSocketClientFactory webSocketClientFactory) {
        return WebSocketTransport.create(options, webSocketClientFactory, null);
    }

    public static WebSocketTransport create(Map<String, Object> options, WebSocketClientFactory webSocketClientFactory, ScheduledExecutorService scheduler) {
        WebSocketTransport transport = new WebSocketTransport(options, webSocketClientFactory, scheduler);
        if (!webSocketClientFactory.isStarted()) {
            try {
                webSocketClientFactory.start();
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }
        return transport;
    }

    public WebSocketTransport(Map<String, Object> options, WebSocketClientFactory webSocketClientFactory, ScheduledExecutorService scheduler) {
        super(NAME, options);
        this._webSocketClientFactory = webSocketClientFactory;
        this._scheduler = scheduler;
        this.setOptionPrefix(PREFIX);
    }

    @Override
    public void setMessageTransportListener(TransportListener listener) {
        this._listener = listener;
    }

    @Override
    public boolean accept(String version) {
        return this._webSocketSupported;
    }

    @Override
    public void init() {
        super.init();
        this._aborted = false;
        this._protocol = this.getOption(PROTOCOL_OPTION, this._protocol);
        this._maxNetworkDelay = this.getOption("maxNetworkDelay", this._maxNetworkDelay);
        this._connectTimeout = this.getOption(CONNECT_TIMEOUT_OPTION, this._connectTimeout);
        this._idleTimeout = this.getOption(IDLE_TIMEOUT_OPTION, this._idleTimeout);
        this._maxMessageSize = this.getOption(MAX_MESSAGE_SIZE_OPTION, this._webSocketClientFactory.getBufferSize());
        if (this._scheduler == null) {
            this._shutdownScheduler = true;
            this._scheduler = Executors.newSingleThreadScheduledExecutor();
        }
    }

    private long getMaxNetworkDelay() {
        return this._maxNetworkDelay;
    }

    private long getConnectTimeout() {
        return this._connectTimeout;
    }

    @Override
    public void abort() {
        this._aborted = true;
        this.disconnect("Aborted");
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        if (this._shutdownScheduler) {
            this._shutdownScheduler = false;
            this._scheduler.shutdown();
            this._scheduler = null;
        }
    }

    @Override
    public void terminate() {
        super.terminate();
        this.disconnect("Terminated");
    }

    protected void disconnect(String reason) {
        WebSocket.Connection connection = this._connection;
        this._connection = null;
        if (connection != null && connection.isOpen()) {
            this.debug("Closing websocket connection {}", connection);
            connection.close(1000, reason);
        }
    }

    @Override
    public void send(TransportListener listener, Message.Mutable ... messages) {
        if (this._aborted) {
            throw new IllegalStateException("Aborted");
        }
        try {
            WebSocket.Connection connection = this.connect(listener, messages);
            if (connection == null) {
                return;
            }
            for (Message.Mutable message : messages) {
                this.registerMessage(message, listener);
            }
            String content = this.generateJSON(messages);
            this.debug("Sending messages {}", content);
            listener.onSending(messages);
            connection.sendMessage(content);
        }
        catch (Exception x) {
            this.complete(messages);
            this.disconnect("Exception");
            listener.onException(x, messages);
        }
    }

    private WebSocket.Connection connect(TransportListener listener, Message.Mutable[] messages) {
        WebSocket.Connection connection = this._connection;
        if (connection != null) {
            return connection;
        }
        try {
            String url = this.getURL();
            url = url.replaceFirst("^http", PREFIX);
            URI uri = new URI(url);
            this.debug("Opening websocket connection to {}", uri);
            HashMap<String, String> cookies = new HashMap<String, String>();
            for (HttpClientTransport.Cookie cookie : this.getCookieProvider().getCookies()) {
                cookies.put(cookie.getName(), cookie.getValue());
            }
            WebSocketClient client = this.newWebSocketClient();
            client.setProtocol(this._protocol);
            client.getCookies().putAll(cookies);
            this._connection = client.open(uri, this._websocket, this.getConnectTimeout(), TimeUnit.MILLISECONDS);
            if (this._aborted) {
                listener.onException(new IOException("Aborted"), messages);
            }
            return this._connection;
        }
        catch (ConnectException x) {
            listener.onConnectException(x, messages);
        }
        catch (SocketTimeoutException x) {
            listener.onConnectException(x, messages);
        }
        catch (TimeoutException x) {
            listener.onConnectException(x, messages);
        }
        catch (URISyntaxException x) {
            this._webSocketSupported = false;
            listener.onProtocolError(x.getMessage(), messages);
        }
        catch (InterruptedException x) {
            this._webSocketSupported = false;
            listener.onException(x, messages);
        }
        catch (ProtocolException x) {
            this._webSocketSupported = false;
            listener.onProtocolError(x.getMessage(), messages);
        }
        catch (IOException x) {
            this._webSocketSupported = false;
            listener.onException(x, messages);
        }
        return this._connection;
    }

    protected WebSocketClient newWebSocketClient() {
        WebSocketClient result = this._webSocketClientFactory.newWebSocketClient();
        result.setMaxTextMessageSize(this._maxMessageSize);
        result.setMaxIdleTime(this._idleTimeout);
        return result;
    }

    private void complete(Message.Mutable[] messages) {
        for (Message.Mutable message : messages) {
            this.deregisterMessage(message);
        }
    }

    private void registerMessage(final Message.Mutable message, final TransportListener listener) {
        long maxNetworkDelay = this.getMaxNetworkDelay();
        if ("/meta/connect".equals(message.getChannel())) {
            Map<String, Object> advice = message.getAdvice();
            if (advice == null) {
                advice = this._advice;
            }
            if (advice != null) {
                Object timeout = advice.get("timeout");
                if (timeout instanceof Number) {
                    maxNetworkDelay += (long)((Number)timeout).intValue();
                } else if (timeout != null) {
                    maxNetworkDelay += (long)Integer.parseInt(timeout.toString());
                }
            }
            this._connected = true;
        }
        final long expiration = System.currentTimeMillis() + maxNetworkDelay;
        ScheduledFuture<?> task = this._scheduler.schedule(new Runnable(){

            public void run() {
                WebSocketExchange exchange;
                long now = System.currentTimeMillis();
                long jitter = now - expiration;
                if (jitter > 5000L) {
                    WebSocketTransport.this.debug("Expired too late {} for {}", new Object[]{jitter, message});
                }
                if ((exchange = WebSocketTransport.this.deregisterMessage(message)) != null) {
                    listener.onExpire(new Message[]{message});
                }
            }
        }, maxNetworkDelay, TimeUnit.MILLISECONDS);
        WebSocketExchange exchange = new WebSocketExchange(message, listener, task);
        this.debug("Registering {}", exchange);
        WebSocketExchange existing = this._metaExchanges.put(message.getId(), exchange);
        if (existing != null) {
            throw new IllegalStateException();
        }
    }

    private WebSocketExchange deregisterMessage(Message message) {
        WebSocketExchange exchange = this._metaExchanges.remove(message.getId());
        if ("/meta/connect".equals(message.getChannel())) {
            this._connected = false;
        } else if ("/meta/disconnect".equals(message.getChannel())) {
            this._disconnected = true;
        }
        this.debug("Deregistering {} for message {}", exchange, message);
        if (exchange != null) {
            exchange.task.cancel(false);
        }
        return exchange;
    }

    private boolean isReply(Message message) {
        return message.isMeta() || message.isPublishReply();
    }

    private void failMessages(Throwable cause) {
        ArrayList<WebSocketExchange> exchanges = new ArrayList<WebSocketExchange>(this._metaExchanges.values());
        for (WebSocketExchange exchange : exchanges) {
            this.deregisterMessage(exchange.message);
            exchange.listener.onException(cause, new Message[]{exchange.message});
        }
    }

    protected void onMessages(List<Message.Mutable> messages) {
        for (Message.Mutable message : messages) {
            if (this.isReply(message)) {
                WebSocketExchange exchange;
                Map<String, Object> advice;
                if ("/meta/connect".equals(message.getChannel()) && message.isSuccessful() && (advice = message.getAdvice()) != null && advice.get("timeout") != null) {
                    this._advice = advice;
                }
                if ((exchange = this.deregisterMessage(message)) != null) {
                    exchange.listener.onMessages(Collections.singletonList(message));
                } else {
                    this.debug("Could not find request for reply {}", message);
                }
                if (!this._disconnected || this._connected) continue;
                this.disconnect("Disconnect");
                continue;
            }
            this._listener.onMessages(Collections.singletonList(message));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WebSocketExchange {
        private final Message.Mutable message;
        private final TransportListener listener;
        private final ScheduledFuture<?> task;

        public WebSocketExchange(Message.Mutable message, TransportListener listener, ScheduledFuture<?> task) {
            this.message = message;
            this.listener = listener;
            this.task = task;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " " + this.message;
        }
    }

    protected class CometDWebSocket
    implements WebSocket.OnTextMessage {
        protected CometDWebSocket() {
        }

        public void onOpen(WebSocket.Connection connection) {
            WebSocketTransport.this.debug("Opened websocket connection {}", new Object[]{connection});
        }

        public void onClose(int closeCode, String message) {
            WebSocket.Connection connection = WebSocketTransport.this._connection;
            WebSocketTransport.this._connection = null;
            WebSocketTransport.this.debug("Closed websocket connection with code {} {}: {} ", new Object[]{closeCode, message, connection});
            WebSocketTransport.this.failMessages(new EOFException("Connection closed " + closeCode + " " + message));
        }

        public void onMessage(String data) {
            try {
                List messages = WebSocketTransport.this.parseMessages(data);
                WebSocketTransport.this.debug("Received messages {}", new Object[]{data});
                WebSocketTransport.this.onMessages(messages);
            }
            catch (ParseException x) {
                WebSocketTransport.this.failMessages(x);
                WebSocketTransport.this.disconnect("Exception");
            }
        }
    }
}

