/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jocl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ConstructorUtil {
    public static Constructor getConstructor(Class type, Class[] argTypes) {
        if (null == type || null == argTypes) {
            throw new NullPointerException();
        }
        Constructor<Object> ctor = null;
        try {
            ctor = type.getConstructor(argTypes);
        }
        catch (Exception e2) {
            ctor = null;
        }
        if (null == ctor) {
            Constructor<?>[] ctors = type.getConstructors();
            for (int i2 = 0; i2 < ctors.length; ++i2) {
                Class<?>[] paramtypes = ctors[i2].getParameterTypes();
                if (paramtypes.length != argTypes.length) continue;
                boolean canuse = true;
                for (int j2 = 0; j2 < paramtypes.length; ++j2) {
                    if (paramtypes[j2].isAssignableFrom(argTypes[j2])) continue;
                    canuse = false;
                    break;
                }
                if (!canuse) continue;
                ctor = ctors[i2];
                break;
            }
        }
        return ctor;
    }

    public static Object invokeConstructor(Class type, Class[] argTypes, Object[] argValues) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        return ConstructorUtil.getConstructor(type, argTypes).newInstance(argValues);
    }
}

