/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.gzip;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class GzipUtils {
    private static final Map compressSuffix = new HashMap();
    private static final Map uncompressSuffix = new HashMap();

    private GzipUtils() {
    }

    public static boolean isCompressedFilename(String filename) {
        String lower = filename.toLowerCase(Locale.ENGLISH);
        int n2 = lower.length();
        for (int i2 = 2; i2 <= 5 && i2 < n2; ++i2) {
            if (!uncompressSuffix.containsKey(lower.substring(n2 - i2))) continue;
            return true;
        }
        return false;
    }

    public static String getUncompressedFilename(String filename) {
        String lower = filename.toLowerCase(Locale.ENGLISH);
        int n2 = lower.length();
        for (int i2 = 2; i2 <= 5 && i2 < n2; ++i2) {
            Object suffix = uncompressSuffix.get(lower.substring(n2 - i2));
            if (suffix == null) continue;
            return filename.substring(0, n2 - i2) + suffix;
        }
        return filename;
    }

    public static String getCompressedFilename(String filename) {
        String lower = filename.toLowerCase(Locale.ENGLISH);
        int n2 = lower.length();
        for (int i2 = 4; i2 <= 5 && i2 < n2; ++i2) {
            Object suffix = compressSuffix.get(lower.substring(n2 - i2));
            if (suffix == null) continue;
            return filename.substring(0, n2 - i2) + suffix;
        }
        return filename + ".gz";
    }

    static {
        compressSuffix.put(".tar", ".tgz");
        compressSuffix.put(".svg", ".svgz");
        compressSuffix.put(".cpio", ".cpgz");
        compressSuffix.put(".wmf", ".wmz");
        compressSuffix.put(".emf", ".emz");
        uncompressSuffix.put(".tgz", ".tar");
        uncompressSuffix.put(".taz", ".tar");
        uncompressSuffix.put(".svgz", ".svg");
        uncompressSuffix.put(".cpgz", ".cpio");
        uncompressSuffix.put(".wmz", ".wmf");
        uncompressSuffix.put(".emz", ".emf");
        uncompressSuffix.put(".gz", "");
        uncompressSuffix.put(".z", "");
        uncompressSuffix.put("-gz", "");
        uncompressSuffix.put("-z", "");
        uncompressSuffix.put("_z", "");
    }
}

