/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import javax.activation.DataHandler;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.attachments.impl.BufferUtils;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.MIMEOutputUtils;
import org.apache.axiom.om.util.CommonUtils;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MTOMXMLStreamWriter
implements XMLStreamWriter {
    private static Log log = LogFactory.getLog(class$org$apache$axiom$om$impl$MTOMXMLStreamWriter == null ? (class$org$apache$axiom$om$impl$MTOMXMLStreamWriter = MTOMXMLStreamWriter.class$("org.apache.axiom.om.impl.MTOMXMLStreamWriter")) : class$org$apache$axiom$om$impl$MTOMXMLStreamWriter);
    private static boolean isDebugEnabled = log.isDebugEnabled();
    private static boolean isTraceEnabled = log.isTraceEnabled();
    private static final int UNSUPPORTED = -1;
    private static final int EXCEED_LIMIT = 1;
    private XMLStreamWriter xmlWriter;
    private OutputStream outStream;
    private LinkedList binaryNodeList = new LinkedList();
    private ByteArrayOutputStream bufferedXML;
    private OMOutputFormat format = new OMOutputFormat();
    private boolean isEndDocument = false;
    private boolean isComplete = false;
    private int depth = 0;
    static /* synthetic */ Class class$org$apache$axiom$om$impl$MTOMXMLStreamWriter;

    public MTOMXMLStreamWriter(XMLStreamWriter xmlWriter) {
        this.xmlWriter = xmlWriter;
        if (isTraceEnabled) {
            log.trace("Call Stack =" + CommonUtils.callStackToString());
        }
    }

    public MTOMXMLStreamWriter(OutputStream outStream, OMOutputFormat format) throws XMLStreamException, FactoryConfigurationError {
        if (isDebugEnabled) {
            log.debug("OutputStream =" + outStream.getClass());
            log.debug("OMFormat = " + format.toString());
        }
        if (isTraceEnabled) {
            log.trace("Call Stack =" + CommonUtils.callStackToString());
        }
        this.format = format;
        this.outStream = outStream;
        if (format.getCharSetEncoding() == null) {
            format.setCharSetEncoding("utf-8");
        }
        if (format.isOptimized()) {
            this.bufferedXML = new ByteArrayOutputStream();
            this.xmlWriter = StAXUtils.createXMLStreamWriter(this.bufferedXML, format.getCharSetEncoding());
        } else {
            this.xmlWriter = StAXUtils.createXMLStreamWriter(outStream, format.getCharSetEncoding());
        }
    }

    public void writeStartElement(String string) throws XMLStreamException {
        this.xmlWriter.writeStartElement(string);
        ++this.depth;
    }

    public void writeStartElement(String string, String string1) throws XMLStreamException {
        this.xmlWriter.writeStartElement(string, string1);
        ++this.depth;
    }

    public void writeStartElement(String string, String string1, String string2) throws XMLStreamException {
        this.xmlWriter.writeStartElement(string, string1, string2);
        ++this.depth;
    }

    public void writeEmptyElement(String string, String string1) throws XMLStreamException {
        this.xmlWriter.writeEmptyElement(string, string1);
    }

    public void writeEmptyElement(String string, String string1, String string2) throws XMLStreamException {
        this.xmlWriter.writeEmptyElement(string, string1, string2);
    }

    public void writeEmptyElement(String string) throws XMLStreamException {
        this.xmlWriter.writeEmptyElement(string);
    }

    public void writeEndElement() throws XMLStreamException {
        this.xmlWriter.writeEndElement();
        --this.depth;
    }

    public void writeEndDocument() throws XMLStreamException {
        if (isDebugEnabled) {
            log.debug("writeEndDocument");
        }
        this.xmlWriter.writeEndDocument();
        this.isEndDocument = true;
    }

    public void close() throws XMLStreamException {
        if (isDebugEnabled) {
            log.debug("close");
        }
        this.xmlWriter.close();
    }

    public void flush() throws XMLStreamException {
        if (isDebugEnabled) {
            log.debug("Calling MTOMXMLStreamWriter.flush");
        }
        this.xmlWriter.flush();
        if (this.format.isOptimized() && !this.isComplete & (this.isEndDocument || this.depth == 0)) {
            if (isDebugEnabled) {
                log.debug("The XML writing is completed.  Now the attachments are written");
            }
            this.isComplete = true;
            String SOAPContentType = this.format.isSOAP11() ? "text/xml" : "application/soap+xml";
            try {
                MIMEOutputUtils.complete(this.outStream, this.bufferedXML.toByteArray(), this.binaryNodeList, this.format.getMimeBoundary(), this.format.getRootContentId(), this.format.getCharSetEncoding(), SOAPContentType, this.format);
                this.bufferedXML.close();
                this.bufferedXML = null;
            }
            catch (UnsupportedEncodingException e2) {
                throw new OMException(e2);
            }
            catch (IOException e3) {
                throw new OMException(e3);
            }
        }
    }

    public void writeAttribute(String string, String string1) throws XMLStreamException {
        this.xmlWriter.writeAttribute(string, string1);
    }

    public void writeAttribute(String string, String string1, String string2, String string3) throws XMLStreamException {
        this.xmlWriter.writeAttribute(string, string1, string2, string3);
    }

    public void writeAttribute(String string, String string1, String string2) throws XMLStreamException {
        this.xmlWriter.writeAttribute(string, string1, string2);
    }

    public void writeNamespace(String string, String string1) throws XMLStreamException {
        this.xmlWriter.writeNamespace(string, string1);
    }

    public void writeDefaultNamespace(String string) throws XMLStreamException {
        this.xmlWriter.writeDefaultNamespace(string);
    }

    public void writeComment(String string) throws XMLStreamException {
        this.xmlWriter.writeComment(string);
    }

    public void writeProcessingInstruction(String string) throws XMLStreamException {
        this.xmlWriter.writeProcessingInstruction(string);
    }

    public void writeProcessingInstruction(String string, String string1) throws XMLStreamException {
        this.xmlWriter.writeProcessingInstruction(string, string1);
    }

    public void writeCData(String string) throws XMLStreamException {
        this.xmlWriter.writeCData(string);
    }

    public void writeDTD(String string) throws XMLStreamException {
        this.xmlWriter.writeDTD(string);
    }

    public void writeEntityRef(String string) throws XMLStreamException {
        this.xmlWriter.writeEntityRef(string);
    }

    public void writeStartDocument() throws XMLStreamException {
        this.xmlWriter.writeStartDocument();
    }

    public void writeStartDocument(String string) throws XMLStreamException {
        this.xmlWriter.writeStartDocument(string);
    }

    public void writeStartDocument(String string, String string1) throws XMLStreamException {
        this.xmlWriter.writeStartDocument(string, string1);
    }

    public void writeCharacters(String string) throws XMLStreamException {
        this.xmlWriter.writeCharacters(string);
    }

    public void writeCharacters(char[] chars, int i2, int i1) throws XMLStreamException {
        this.xmlWriter.writeCharacters(chars, i2, i1);
    }

    public String getPrefix(String string) throws XMLStreamException {
        return this.xmlWriter.getPrefix(string);
    }

    public void setPrefix(String string, String string1) throws XMLStreamException {
        this.xmlWriter.setPrefix(string, string1);
    }

    public void setDefaultNamespace(String string) throws XMLStreamException {
        this.xmlWriter.setDefaultNamespace(string);
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        this.xmlWriter.setNamespaceContext(namespaceContext);
    }

    public NamespaceContext getNamespaceContext() {
        return this.xmlWriter.getNamespaceContext();
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        return this.xmlWriter.getProperty(string);
    }

    public boolean isOptimized() {
        return this.format.isOptimized();
    }

    public String getContentType() {
        return this.format.getContentType();
    }

    public void writeOptimized(OMText node) {
        if (isDebugEnabled) {
            log.debug("Start MTOMXMLStreamWriter.writeOptimized()");
        }
        this.binaryNodeList.add(node);
        if (isDebugEnabled) {
            log.debug("Exit MTOMXMLStreamWriter.writeOptimized()");
        }
    }

    public boolean isOptimizedThreshold(OMText node) {
        if (isDebugEnabled) {
            log.debug("Start MTOMXMLStreamWriter.isOptimizedThreshold()");
        }
        DataHandler dh = (DataHandler)node.getDataHandler();
        int optimized = -1;
        if (dh != null) {
            if (isDebugEnabled) {
                log.debug("DataHandler fetched, starting optimized Threshold processing");
            }
            optimized = BufferUtils.doesDataHandlerExceedLimit(dh, this.format.getOptimizedThreshold());
        }
        if (optimized == -1 || optimized == 1) {
            if (log.isDebugEnabled()) {
                log.debug("node should be added to binart NodeList for optimization");
            }
            return true;
        }
        return false;
    }

    public void setXmlStreamWriter(XMLStreamWriter xmlWriter) {
        this.xmlWriter = xmlWriter;
    }

    public XMLStreamWriter getXmlStreamWriter() {
        return this.xmlWriter;
    }

    public String getMimeBoundary() {
        return this.format.getMimeBoundary();
    }

    public String getRootContentId() {
        return this.format.getRootContentId();
    }

    public String getNextContentId() {
        return this.format.getNextContentId();
    }

    public String getCharSetEncoding() {
        return this.format.getCharSetEncoding();
    }

    public void setCharSetEncoding(String charSetEncoding) {
        this.format.setCharSetEncoding(charSetEncoding);
    }

    public String getXmlVersion() {
        return this.format.getXmlVersion();
    }

    public void setXmlVersion(String xmlVersion) {
        this.format.setXmlVersion(xmlVersion);
    }

    public void setSoap11(boolean b2) {
        this.format.setSOAP11(b2);
    }

    public boolean isIgnoreXMLDeclaration() {
        return this.format.isIgnoreXMLDeclaration();
    }

    public void setIgnoreXMLDeclaration(boolean ignoreXMLDeclaration) {
        this.format.setIgnoreXMLDeclaration(ignoreXMLDeclaration);
    }

    public void setDoOptimize(boolean b2) {
        this.format.setDoOptimize(b2);
    }

    public OMOutputFormat getOutputFormat() {
        return this.format;
    }

    public void setOutputFormat(OMOutputFormat format) {
        this.format = format;
    }

    public OutputStream getOutputStream() throws XMLStreamException {
        OutputStream os = null;
        os = this.bufferedXML != null ? this.bufferedXML : this.outStream;
        if (isDebugEnabled) {
            if (os == null) {
                log.debug("Direct access to the output stream is not available.");
            } else if (this.bufferedXML != null) {
                log.debug("Returning access to the buffered xml stream: " + this.bufferedXML);
            } else {
                log.debug("Returning access to the original output stream: " + os);
            }
        }
        if (os != null) {
            this.writeCharacters("");
            this.flush();
        }
        return os;
    }

    private void writeOutput(OMText textNode) throws XMLStreamException {
        int type = textNode.getType();
        if (type == 4 || type == 6) {
            this.writeCharacters(textNode.getText());
        } else if (type == 12) {
            this.writeCData(textNode.getText());
        } else if (type == 9) {
            this.writeEntityRef(textNode.getText());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

