/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.messageservice.utils;

import com.mathworks.matlabserver.worker_config_management.MatlabServerConfigBean;
import com.mathworks.matlabserver.worker_config_management.MatlabServerConfigFactory;
import com.mathworks.messageservice.AbstractMessageService;
import com.mathworks.messageservice.MessageServiceOpaque;
import com.mathworks.messageservice.asynchronous.MessageServiceAsyncPushImpl;
import com.mathworks.messageservice.requestresponse.MessageServiceReqRespImpl;
import com.mathworks.messageservice.utils.EchoService;
import java.util.logging.Logger;

public class OpaqueServiceUtils {
    private static final Logger logger = Logger.getLogger(OpaqueServiceUtils.class.getName());

    public static MessageServiceOpaque getOpaqueMessageService() {
        AbstractMessageService messageServiceOpaque;
        boolean isAsyncEnabled;
        MatlabServerConfigBean bean = MatlabServerConfigFactory.getConfig();
        if (bean != null) {
            isAsyncEnabled = bean.isEnableAsyncPushForMGG();
            logger.info("Enabled Async Push for MGG: " + isAsyncEnabled);
        } else {
            isAsyncEnabled = false;
        }
        if (isAsyncEnabled) {
            messageServiceOpaque = new MessageServiceAsyncPushImpl();
            EchoService.start((MessageServiceOpaque)((Object)messageServiceOpaque));
        } else {
            messageServiceOpaque = new MessageServiceReqRespImpl();
        }
        logger.info("Opaque Message Service Type: " + messageServiceOpaque.getClass().getName() + " because Async Push Service Mode is " + isAsyncEnabled);
        return messageServiceOpaque;
    }
}

