/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.messageservice.requestresponse;

import com.mathworks.matlabserver.internalservices.opaqueMessageService.OpaqueMessageDO;
import com.mathworks.matlabserver.internalservices.opaqueMessageService.OpaqueRequestMessageDO;
import com.mathworks.matlabserver.internalservices.opaqueMessageService.OpaqueResponseMessageDO;
import com.mathworks.messageservice.AbstractMessageService;
import com.mathworks.messageservice.MessageRaw;
import com.mathworks.messageservice.MessageServiceFactory;
import com.mathworks.messageservice.MessageServiceOpaque;
import com.mathworks.messageservice.Subscriber;
import com.mathworks.messageservice.json.MessageJSON;
import com.mathworks.messageservice.json.MessageServiceJSONImpl;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class MessageServiceReqRespImpl
extends AbstractMessageService
implements MessageServiceOpaque {
    private static final Logger logger = Logger.getLogger(MessageServiceReqRespImpl.class.getName());
    private final Queue<MessageRaw> pendingMessages = new LinkedList<MessageRaw>();
    private int waitingThreads = 0;
    private final Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(String channel, byte[] message) {
        this.lock.lock();
        try {
            this.pendingMessages.add(new MessageRaw(channel, message));
        }
        finally {
            this.lock.unlock();
        }
    }

    public OpaqueResponseMessageDO handleMessage(OpaqueRequestMessageDO opaqueRequestMessageDO) {
        MessageServiceJSONImpl messageServiceJSON = (MessageServiceJSONImpl)MessageServiceFactory.getMessageService();
        OpaqueResponseMessageDO opaqueResponseMessageDO = new OpaqueResponseMessageDO();
        OpaqueMessageDO[] opaqueMessageDOs = opaqueRequestMessageDO.getOpaqueMessageDOs();
        if (opaqueMessageDOs != null) {
            for (OpaqueMessageDO opaqueMessageDO : opaqueMessageDOs) {
                MessageRaw message = new MessageRaw(opaqueMessageDO.getChannel(), opaqueMessageDO.getData());
                for (String channel : this.subscriptions.keySet()) {
                    if (!this.doesSubscriptionChannelMatchMessage(channel, message)) continue;
                    List subscribers = (List)this.subscriptions.get(channel);
                    for (Subscriber subscriber : subscribers) {
                        subscriber.handle(message);
                    }
                }
                try {
                    messageServiceJSON.handleMessage(new MessageJSON(opaqueMessageDO.getChannel(), new String(opaqueMessageDO.getData(), "UTF-8")));
                }
                catch (UnsupportedEncodingException e2) {
                    logger.log(Level.SEVERE, "Unable to handle message.", e2);
                }
            }
        }
        OpaqueMessageDO[] responses = this.getPendingMessages();
        opaqueResponseMessageDO.setOpaqueMessageDOs(responses);
        return opaqueResponseMessageDO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpaqueMessageDO[] getPendingMessages() {
        this.lock.lock();
        try {
            Date start = new Date();
            while (this.pendingMessages.size() == 0 && new Date().getTime() - start.getTime() < 2000L && this.waitingThreads == 0) {
                ++this.waitingThreads;
                this.lock.unlock();
                try {
                    Thread.sleep(1L);
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                        }
                    });
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                this.lock.lock();
                --this.waitingThreads;
            }
            OpaqueMessageDO[] opaqueMessageDOs = new OpaqueMessageDO[this.pendingMessages.size()];
            int i2 = 0;
            for (MessageRaw messageRaw : this.pendingMessages) {
                OpaqueMessageDO opaqueMessageDO = new OpaqueMessageDO();
                opaqueMessageDO.setChannel(messageRaw.getChannel());
                opaqueMessageDO.setData(messageRaw.getData());
                opaqueMessageDOs[i2] = opaqueMessageDO;
                ++i2;
            }
            this.pendingMessages.clear();
            OpaqueMessageDO[] opaqueMessageDOArray = opaqueMessageDOs;
            return opaqueMessageDOArray;
        }
        finally {
            this.lock.unlock();
        }
    }
}

