/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.messageservice.json;

import com.mathworks.messageservice.AbstractMessageService;
import com.mathworks.messageservice.Message;
import com.mathworks.messageservice.MessageNative;
import com.mathworks.messageservice.MessageRaw;
import com.mathworks.messageservice.MessageService;
import com.mathworks.messageservice.MessageServiceFactory;
import com.mathworks.messageservice.MessageServiceOpaque;
import com.mathworks.messageservice.Subscriber;
import com.mathworks.messageservice.json.JSONConverterImpl;
import com.mathworks.messageservice.json.JSONCustomConverters;
import com.mathworks.messageservice.json.MessageJSON;
import com.mathworks.messageservice.json.converters.JSONTypeConverter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageServiceJSONImpl
extends AbstractMessageService
implements MessageService,
JSONCustomConverters {
    private static final Logger logger = Logger.getLogger(MessageServiceJSONImpl.class.getName());
    private static final JSONConverterImpl jsonConverter = new JSONConverterImpl();

    @Override
    public void handleMessage(Message message) {
        MessageJSON messageJSON;
        if (message instanceof MessageJSON) {
            messageJSON = (MessageJSON)message;
        } else if (message instanceof MessageRaw) {
            try {
                messageJSON = new MessageJSON(message.getChannel(), new String((byte[])message.getData(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e2) {
                messageJSON = new MessageJSON(message.getChannel(), new String((byte[])message.getData()));
                logger.log(Level.SEVERE, "Unable to handle message.", e2);
            }
        } else {
            throw new IllegalArgumentException("Unknown message type: " + message);
        }
        MessageNative newMessage = null;
        for (String channel : this.subscriptions.keySet()) {
            if (!this.doesSubscriptionChannelMatchMessage(channel, messageJSON)) continue;
            List subscribers = (List)this.subscriptions.get(channel);
            for (Subscriber subscriber : subscribers) {
                try {
                    if (newMessage == null) {
                        newMessage = new MessageNative(messageJSON.getChannel(), this.convertFromJSON(messageJSON.getData()));
                    }
                    subscriber.handle(newMessage);
                }
                catch (Exception e3) {
                    logger.log(Level.WARNING, "Error in subscription handler", e3);
                }
            }
        }
    }

    @Override
    public void publish(String channel, Object message) {
        String jsonMessage = this.convertToJSON(message);
        MessageServiceOpaque messageServiceOpaque = MessageServiceFactory.getMessageServiceOpaque();
        try {
            messageServiceOpaque.publish(channel, jsonMessage.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e2) {
            logger.log(Level.SEVERE, "Unable to handle message.", e2);
        }
    }

    String convertToJSON(Object object) {
        return jsonConverter.convertToJson(object);
    }

    Object convertFromJSON(String json) {
        return jsonConverter.convertFromJson(json);
    }

    @Override
    public void registerConverter(Class clazz, String property, JSONTypeConverter converter) {
        jsonConverter.registerConverter(clazz, property, converter);
    }
}

