/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.worker.services.codeanalyzer.impl13a;

import com.mathworks.matlabserver.internalservices.codeanalyzer.CodeAnalyzerMessage;
import com.mathworks.matlabserver.internalservices.codeanalyzer.CodeAnalyzerRequestMessageDO;
import com.mathworks.matlabserver.internalservices.codeanalyzer.CodeAnalyzerResponseMessageDO;
import com.mathworks.matlabserver.worker.desktopservices.CodeAnalyzer;
import com.mathworks.widgets.text.mcode.CodeAnalyzerUtilities;
import com.mathworks.widgets.text.mcode.MLint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;

public class CodeAnalyzerImpl
implements CodeAnalyzer {
    @Override
    public CodeAnalyzerResponseMessageDO getCodeAnalysis(CodeAnalyzerRequestMessageDO request) {
        List<CodeAnalyzerMessage> resultMessages;
        CodeAnalyzerResponseMessageDO response = new CodeAnalyzerResponseMessageDO();
        if (request.getMatlabCode() == null || request.getMatlabCode().isEmpty()) {
            response.setMessages(Collections.emptyList());
            return response;
        }
        List messages = MLint.getMessages((String)request.getMatlabCode(), null);
        try {
            String matlabCode = request.getMatlabCode();
            CodeAnalyzerUtilities.modifyMessages((String)matlabCode, (List)messages);
            resultMessages = this.createCodeAnalyzerMessages(messages);
        }
        catch (BadLocationException x) {
            throw new RuntimeException(x);
        }
        response.setMessages(resultMessages);
        return response;
    }

    private List<CodeAnalyzerMessage> createCodeAnalyzerMessages(List<MLint.Message> messages) throws BadLocationException {
        ArrayList<CodeAnalyzerMessage> resultMessages = new ArrayList<CodeAnalyzerMessage>();
        for (MLint.Message message : messages) {
            resultMessages.add(new CodeAnalyzerMessage(message.getMessage(), message.getSeverity(), message.getLineNumber() - 1, message.getStartColumn() - 1, message.getEndColumn()));
        }
        return resultMessages;
    }
}

