/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.worker.service.eval.impl13b;

import java.io.StringWriter;
import java.util.concurrent.atomic.AtomicBoolean;

public class MvmBufferedWriter
extends StringWriter {
    private final AtomicBoolean isTruncated = new AtomicBoolean(false);
    private final int truncationSize;
    private final int maxBufferSize;

    public MvmBufferedWriter(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
        this.truncationSize = maxBufferSize / 2;
    }

    public MvmBufferedWriter() {
        this(44100);
    }

    public boolean isTruncated() {
        return this.isTruncated.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.isTruncated.set(false);
            StringBuffer buffer = this.getBuffer();
            super.getBuffer().delete(0, buffer.length());
        }
    }

    @Override
    public void write(int c2) {
        super.write(c2);
        this.truncateCheck();
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        super.write(cbuf, off, len);
        this.truncateCheck();
    }

    @Override
    public void write(String str) {
        super.write(str);
        this.truncateCheck();
    }

    @Override
    public void write(String str, int off, int len) {
        super.write(str, off, len);
        this.truncateCheck();
    }

    @Override
    public StringWriter append(CharSequence csq) {
        super.append(csq);
        this.truncateCheck();
        return this;
    }

    @Override
    public StringWriter append(CharSequence csq, int start, int end) {
        super.append(csq, start, end);
        this.truncateCheck();
        return this;
    }

    @Override
    public StringWriter append(char c2) {
        super.append(c2);
        this.truncateCheck();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void truncateCheck() {
        Object object = this.lock;
        synchronized (object) {
            StringBuffer buffer = this.getBuffer();
            if (buffer.length() > this.maxBufferSize) {
                this.isTruncated.set(true);
                buffer.delete(0, buffer.length() - this.truncationSize);
            }
        }
    }
}

