/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.worker.service.eval.impl13b;

import com.mathworks.matlabserver.internalservices.eval.EvalRequestMessageDO;
import com.mathworks.matlabserver.internalservices.eval.EvalResponseMessageDO;
import com.mathworks.matlabserver.internalservices.faults.FaultUtils;
import com.mathworks.matlabserver.workercommon.desktopservices.eval.AbstractEval;
import com.mathworks.matlabserver.workercommon.util.ConcurrencyCheck;
import com.mathworks.mvm.MVM;
import com.mathworks.mvm.MvmFactory;
import com.mathworks.mvm.exec.FutureEvalResult;
import com.mathworks.mvm.exec.FutureResult;
import com.mathworks.mvm.exec.MatlabEvalRequest;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractMvmEval
extends AbstractEval {
    private final Logger logger = Logger.getLogger(AbstractMvmEval.class.getName());
    private final ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "abstract mvm eval");
            thread.setDaemon(true);
            return thread;
        }
    });

    @Override
    public EvalResponseMessageDO executionEval(EvalRequestMessageDO evalRequest) {
        EvalResponseMessageDO evalResponse = new EvalResponseMessageDO();
        MVM mvm = MvmFactory.getCurrentMVM();
        ConcurrencyCheck.getInstance().checkIsNotMatlabThread();
        String mcode = evalRequest.getMcode();
        try {
            StringWriter evalOutput = new StringWriter();
            StringWriter evalError = new StringWriter();
            MatlabEvalRequest mvmRequest = new MatlabEvalRequest(mcode, (Writer)evalOutput, (Writer)evalError);
            mvmRequest.setExternal(false);
            mvm.getExecutor().submit(mvmRequest).get();
            evalResponse.setResponseStr((evalError.getBuffer().length() > 0 ? evalError : evalOutput).getBuffer().substring(0));
            evalResponse.setUpdate(true);
            evalResponse.setUuid(evalRequest.getUuid());
            evalResponse.setError(evalError.getBuffer().length() > 0);
        }
        catch (Exception e2) {
            this.logger.log(Level.SEVERE, "Error", e2);
            evalResponse.setFault(FaultUtils.create(e2));
            evalResponse.setError(true);
        }
        return evalResponse;
    }

    protected void executeAsyncEval(MatlabEvalRequest request, Semaphore binarySemaphore) {
        request.setSuppressDebugControlOutput(true);
        MVM mvm = MvmFactory.getCurrentMVM();
        FutureEvalResult evalFuture = mvm.getExecutor().submit(request);
        this.executorService.submit(new Runnable((FutureResult)evalFuture, binarySemaphore){
            final /* synthetic */ FutureResult val$evalFuture;
            final /* synthetic */ Semaphore val$binarySemaphore;
            {
                this.val$evalFuture = futureResult;
                this.val$binarySemaphore = semaphore;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    this.val$evalFuture.get();
                }
                catch (Exception exception) {
                }
                finally {
                    this.val$binarySemaphore.release();
                }
            }
        });
    }

    protected String createResponseStr(String evalWriterSink, String errWriterSink) {
        StringBuilder retval = new StringBuilder();
        if (evalWriterSink != null) {
            retval.append(evalWriterSink);
        }
        if (errWriterSink != null) {
            retval.append(errWriterSink);
        }
        return retval.toString();
    }

    protected EvalResponseMessageDO createResponseFromException(String uuid, Exception e2) {
        EvalResponseMessageDO evalMessage = new EvalResponseMessageDO();
        evalMessage.setResponseStr(FaultUtils.createResponse(e2));
        evalMessage.setFault(FaultUtils.create(e2));
        evalMessage.setUuid(uuid);
        evalMessage.setError(true);
        return evalMessage;
    }

    protected EvalResponseMessageDO createResponseFromWriters(String uuid, String evalWriterStr, String errWriterStr) {
        EvalResponseMessageDO evalMessage = new EvalResponseMessageDO();
        evalMessage.setResponseStr(this.createResponseStr(evalWriterStr, errWriterStr));
        evalMessage.setError(this.isError(errWriterStr));
        evalMessage.setUuid(uuid);
        return evalMessage;
    }

    protected boolean isError(String errWriterStr) {
        return StringUtils.isNotBlank(errWriterStr);
    }
}

