/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.worker.service.eval.impl13a;

import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.MatlabMCRFactory;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.matlabserver.internalservices.eval.EvalRequestMessageDO;
import com.mathworks.matlabserver.internalservices.eval.EvalResponseMessageDO;
import com.mathworks.matlabserver.worker.service.eval.impl13a.AbstractMvmEval;
import com.mathworks.matlabserver.worker.service.eval.impl13a.MvmBufferedWriter;
import com.mathworks.matlabserver.worker.service.eval.impl13a.MvmIqmInputListener;
import com.mathworks.matlabserver.worker.service.eval.impl13a.MvmSinkTextListener;
import com.mathworks.matlabserver.worker.service.eval.impl13a.MvmSuggestListener;
import com.mathworks.matlabserver.workercommon.util.ConcurrencyCheck;
import com.mathworks.mde.cmdwin.TypoSuggestionEvent;
import com.mathworks.mvm.MvmFactory;
import com.mathworks.mvm.eventmgr.EventMgr;
import com.mathworks.mvm.eventmgr.MvmListener;
import com.mathworks.mvm.eventmgr.SinkTextEvent;
import com.mathworks.mvm.eventmgr.prompt.IqmInputRequestEvent;
import com.mathworks.mvm.exec.MatlabEvalRequest;
import com.mathworks.services.SystemServices;
import java.io.Writer;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class MvmEvalListenerImpl
extends AbstractMvmEval {
    private static final Logger logger = Logger.getLogger(MvmEvalListenerImpl.class.getName());
    private static final String SUGGEST_PREFIX = "Did you mean: ";
    private static final String SUGGEST_POSTFIX = " ?";
    private final MatlabMCR matlab = MatlabMCRFactory.getForCurrentMCR();
    private final MvmBufferedWriter evalWriter = new MvmBufferedWriter();
    private final MvmBufferedWriter errWriter = new MvmBufferedWriter();
    private final MvmIqmInputListener iqmListener = new MvmIqmInputListener();
    private final MvmSuggestListener suggestListener = new MvmSuggestListener();
    private final MvmSinkTextListener textListener = new MvmSinkTextListener();
    private final boolean useNewTextEventAPI;
    private final Object lock = new Object();

    public MvmEvalListenerImpl() {
        this.useNewTextEventAPI = true;
        this.registerHooksWithMvm();
    }

    public MvmEvalListenerImpl(boolean useNewTextEventAPI) {
        this.useNewTextEventAPI = useNewTextEventAPI;
        this.registerHooksWithMvm();
    }

    private void registerHooksWithMvm() {
        MatlabMCR matlab = MatlabMCRFactory.getForCurrentMCR();
        matlab.whenMatlabReady(new Runnable(){

            @Override
            public void run() {
                if (MvmEvalListenerImpl.this.useNewTextEventAPI) {
                    SystemServices.enableSinkTextEventPublishing();
                } else {
                    NativeMatlab.nativeLabCmdWinSetup((Writer)MvmEvalListenerImpl.this.evalWriter, (Writer)MvmEvalListenerImpl.this.errWriter);
                }
                EventMgr eventMgr = MvmFactory.getCurrentMVM().getEventMgr();
                eventMgr.addMvmListener((MvmListener)MvmEvalListenerImpl.this.iqmListener, IqmInputRequestEvent.class);
                eventMgr.addMvmListener((MvmListener)MvmEvalListenerImpl.this.suggestListener, TypoSuggestionEvent.class);
                if (MvmEvalListenerImpl.this.useNewTextEventAPI) {
                    eventMgr.addMvmListener((MvmListener)MvmEvalListenerImpl.this.textListener, SinkTextEvent.class);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EvalResponseMessageDO authoringEval(EvalRequestMessageDO evalRequest) {
        EvalResponseMessageDO retval;
        Semaphore binarySemaphore = new Semaphore(1);
        String uuid = evalRequest.getUuid();
        String mcommand = evalRequest.getMcode();
        MatlabEvalRequest request = new MatlabEvalRequest(mcommand, (Writer)this.evalWriter, (Writer)this.errWriter);
        request.setExternal(true);
        ConcurrencyCheck.getInstance().checkIsNotMatlabThread();
        Object object = this.lock;
        synchronized (object) {
            try {
                if (evalRequest.getHeight() > 0 || evalRequest.getWidth() > 0) {
                    this.matlab.setWindowSize(evalRequest.getHeight(), evalRequest.getWidth());
                }
                this.iqmListener.setSemaphore(binarySemaphore);
                this.suggestListener.clearSuggestion();
                if (this.useNewTextEventAPI) {
                    this.textListener.clearBuffer();
                }
                binarySemaphore.acquire();
                this.executeAsyncEval(request, binarySemaphore);
                binarySemaphore.acquire();
                this.synchronousFlushPendingInterpreterEvents();
                String evalWriterStr = this.evalWriter.getBuffer();
                String errWriterStr = this.errWriter.getBuffer();
                String suggestion = this.suggestListener.getSuggestion();
                String textListenerStr = this.textListener.getBuffer();
                retval = this.createResponseFromWriters(uuid, this.iqmListener.getPromptType(), evalWriterStr, errWriterStr, textListenerStr, suggestion);
            }
            catch (Exception e2) {
                logger.log(Level.SEVERE, "Error", e2);
                retval = this.createResponseFromException(uuid, e2);
            }
            finally {
                this.iqmListener.setSemaphore(null);
                binarySemaphore.release();
                this.evalWriter.reset();
                this.errWriter.reset();
            }
        }
        return retval;
    }

    private void synchronousFlushPendingInterpreterEvents() {
        ConcurrencyCheck.getInstance().checkIsNotMatlabThread();
        try {
            final Semaphore semaphore = new Semaphore(1);
            semaphore.acquire();
            this.matlab.whenMatlabIdle(new Runnable(){

                @Override
                public void run() {
                    semaphore.release();
                }
            });
            semaphore.acquire();
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Issue with flushing queue", e2);
        }
    }

    protected EvalResponseMessageDO createResponseFromWriters(String uuid, int promptType, String evalWriterStr, String errWriterStr, String textListenerStr, String suggestion) {
        EvalResponseMessageDO evalMessage = new EvalResponseMessageDO();
        boolean isError = this.isError(errWriterStr);
        StringBuilder response = new StringBuilder();
        evalMessage.setError(isError);
        evalMessage.setUuid(uuid);
        evalMessage.setPromptType(promptType);
        if (!StringUtils.isEmpty(evalWriterStr)) {
            String result = this.truncateResult(evalMessage, evalWriterStr);
            response.append(result);
        }
        if (!StringUtils.isEmpty(errWriterStr)) {
            response.append(errWriterStr);
            if (!StringUtils.isEmpty(suggestion)) {
                response.append(SUGGEST_PREFIX);
                response.append(suggestion);
                response.append(SUGGEST_POSTFIX);
            }
        }
        evalMessage.setResponseStr(response.toString());
        if (this.useNewTextEventAPI && StringUtils.isNotEmpty(textListenerStr)) {
            evalMessage.setResponseStr(evalMessage.getResponseStr() + this.textListener.getBuffer());
        }
        return evalMessage;
    }
}

