/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.worker.service.breakpoint.impl13b;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.matlab.api.debug.DebugListener;
import com.mathworks.matlabserver.fileservices.util.FilenameConverter;
import com.mathworks.matlabserver.internalservices.serviceregistry.RegistryService;
import com.mathworks.matlabserver.internalservices.serviceregistry.ServiceRegistryFactory;
import com.mathworks.matlabserver.worker.desktopservices.BreakpointSyncManager;
import com.mathworks.matlabserver.worker.desktopservices.UserManager;
import com.mathworks.mde.editor.breakpoints.DebugAdapter;
import com.mathworks.mde.editor.breakpoints.MatlabBreakpoint;
import com.mathworks.mde.editor.breakpoints.MatlabBreakpointUtils;
import com.mathworks.mde.editor.breakpoints.MatlabDebugger;
import com.mathworks.messageservice.Message;
import com.mathworks.messageservice.MessageService;
import com.mathworks.messageservice.MessageServiceFactory;
import com.mathworks.messageservice.Subscriber;
import com.mathworks.peermodel.PeerModelManager;
import com.mathworks.peermodel.PeerModelManagers;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.widgets.glazedlists.DisposableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class MatlabBreakpointMessageService
implements BreakpointSyncManager<File> {
    private final MatlabDebugger fDebugger;
    private final MessageService fMessageService;
    private AtomicReference<FilenameConverter> fFilenameConverter = new AtomicReference();
    private final AtomicReference<UserManager> fUserManager = new AtomicReference();
    private final Subscriber fAddBreakpointRequestSubscriber = this.createAddBreakpointRequestSubscriber();
    private final Subscriber fRemoveBreakpointRequestSubscriber = this.createRemoveBreakpointRequestSubscriber();
    private final Subscriber fGetBreakpointsRequestSubscriber = this.createGetBreakpointsRequestSubscriber();
    private final DebugListener<MatlabBreakpoint> fMatlabBreakpointsListener = this.createMatlabBreakpointsListener();
    private final PeerModelManager fBreakpointsDataStore;

    public MatlabBreakpointMessageService(MatlabDebugger debugger, MessageService messageService) {
        this.fDebugger = debugger;
        this.fMessageService = messageService;
        this.fBreakpointsDataStore = PeerModelManagers.getInstance((String)"/matlabbreakpointsdatastore");
        this.initializeBreakpointDataStore();
        this.initializeListeners();
    }

    private void initializeBreakpointDataStore() {
        this.fBreakpointsDataStore.setRoot("matlab_editor_breakpoint_store");
        this.fBreakpointsDataStore.setSyncEnabled(true);
    }

    public MatlabBreakpointMessageService() {
        this(MatlabBreakpointUtils.getDebugger(), MessageServiceFactory.getMessageService());
    }

    private void initializeListeners() {
        this.fMessageService.subscribe("/editor/breakpoints/addBreakpointsRequest", this.fAddBreakpointRequestSubscriber);
        this.fMessageService.subscribe("/editor/breakpoints/removeBreakpointsRequest", this.fRemoveBreakpointRequestSubscriber);
        this.fMessageService.subscribe("/editor/breakpoints/getBreakpoints", this.fGetBreakpointsRequestSubscriber);
        this.fDebugger.addDebugListener(this.fMatlabBreakpointsListener);
        this.fMessageService.publish("/editor/breakpoint/breakpointsCleared", "");
    }

    public void dispose() {
        this.fMessageService.unsubscribe("/editor/breakpoints/addBreakpointsRequest", this.fAddBreakpointRequestSubscriber);
        this.fMessageService.unsubscribe("/editor/breakpoints/removeBreakpointsRequest", this.fRemoveBreakpointRequestSubscriber);
        this.fMessageService.unsubscribe("/editor/breakpoints/getBreakpoints", this.fGetBreakpointsRequestSubscriber);
        this.fDebugger.removeDebugListener(this.fMatlabBreakpointsListener);
    }

    public DebugListener<MatlabBreakpoint> getBreakpointListener() {
        return this.fMatlabBreakpointsListener;
    }

    private void clearAndSetBreakpoints(String fileForBreakpoints, Object[] breakpoints) {
        ArrayList<MatlabBreakpoint> breakpointsToSet = new ArrayList<MatlabBreakpoint>();
        for (Object breakpoint : breakpoints) {
            Map breakpointData = (Map)breakpoint;
            int lineNumber = ((Double)breakpointData.get("zeroBasedLineNumber")).intValue();
            breakpointsToSet.add(MatlabBreakpoint.create((int)lineNumber, (File)new File(fileForBreakpoints)));
        }
        if (!breakpointsToSet.isEmpty()) {
            this.fDebugger.clearAndSet(breakpointsToSet, new File(fileForBreakpoints), this.errorHandlerCompletionObserver());
        }
    }

    private String convertPathToServer(String clientPath) {
        String serverPath = clientPath;
        if (this.getFileNameConverter() != null && this.getUserManager() != null) {
            serverPath = this.getFileNameConverter().convertFilenameFromWorkerToServer(this.getUserManager().getUserToken(), clientPath);
        }
        return serverPath;
    }

    private String convertPathToClient(String serverPath) {
        String clientPath = serverPath;
        if (this.getFileNameConverter() != null && this.getUserManager() != null) {
            clientPath = this.getFileNameConverter().convertFilenameFromServerToWorker(this.getUserManager().getUserToken(), clientPath);
        }
        return clientPath;
    }

    private FilenameConverter getFileNameConverter() {
        if (this.fFilenameConverter.get() == null) {
            RegistryService registry = ServiceRegistryFactory.getServiceRegistry();
            this.fFilenameConverter.set((FilenameConverter)registry.getService(FilenameConverter.class));
        }
        return this.fFilenameConverter.get();
    }

    private UserManager getUserManager() {
        if (this.fUserManager.get() == null) {
            RegistryService registry = ServiceRegistryFactory.getServiceRegistry();
            this.fUserManager.set((UserManager)registry.getService(UserManager.class));
        }
        return this.fUserManager.get();
    }

    private DebugAdapter<MatlabBreakpoint> createMatlabBreakpointsListener() {
        return new DebugAdapter<MatlabBreakpoint>(){

            public void breakpointsAdded(Collection<MatlabBreakpoint> matlabBreakpoints) {
                List<Map<String, Object>> breakpointAddedData = this.convertBreakpointsToServerMessages(matlabBreakpoints);
                MatlabBreakpointMessageService.this.fMessageService.publish("/editor/breakpoint/breakpointsAdded", breakpointAddedData);
            }

            private List<Map<String, Object>> convertBreakpointsToServerMessages(Collection<MatlabBreakpoint> matlabBreakpoints) {
                ArrayList<Map<String, Object>> breakpointAddedData = new ArrayList<Map<String, Object>>();
                for (MatlabBreakpoint breakpoint : matlabBreakpoints) {
                    breakpointAddedData.add(MatlabBreakpointMessageService.this.createMatlabBreakpointDO(breakpoint));
                }
                return breakpointAddedData;
            }

            public void breakpointsRemoved(Collection<MatlabBreakpoint> matlabBreakpoints) {
                List<Map<String, Object>> matlabBreakpointDOs = this.convertBreakpointsToServerMessages(matlabBreakpoints);
                MatlabBreakpointMessageService.this.fMessageService.publish("/editor/breakpoint/breakpointsRemoved", matlabBreakpointDOs);
            }

            public void breakpointsCleared() {
                MatlabBreakpointMessageService.this.fMessageService.publish("/editor/breakpoint/breakpointsCleared", new HashMap());
            }
        };
    }

    private Subscriber createGetBreakpointsRequestSubscriber() {
        return new Subscriber(){

            @Override
            public void handle(Message message) {
                DisposableList breakpointsForFile = MatlabBreakpointMessageService.this.fDebugger.getBreakpoints(new File(MatlabBreakpointMessageService.this.convertPathToServer((String)message.getData())));
                ArrayList<Map<String, Object>> breakpoints = new ArrayList<Map<String, Object>>();
                for (MatlabBreakpoint breakpoint : breakpointsForFile) {
                    breakpoints.add(MatlabBreakpointMessageService.this.createMatlabBreakpointDO(breakpoint));
                }
                MatlabBreakpointMessageService.this.fMessageService.publish("/editor/breakpoint/breakpointsAdded", breakpoints);
            }
        };
    }

    public Map<String, Object> createMatlabBreakpointDO(MatlabBreakpoint breakpoint) {
        HashMap<String, Object> matlabBreakpointDO = new HashMap<String, Object>();
        matlabBreakpointDO.put("zeroBasedLineNumber", breakpoint.getZeroBasedLineNumber());
        matlabBreakpointDO.put("fileName", this.convertPathToClient(breakpoint.getFile().getAbsolutePath()));
        matlabBreakpointDO.put("expression", breakpoint.getExpression());
        matlabBreakpointDO.put("isEnabled", breakpoint.isEnabled());
        matlabBreakpointDO.put("anonymousIndex", breakpoint.getAnonymousIndex());
        return matlabBreakpointDO;
    }

    private Subscriber createRemoveBreakpointRequestSubscriber() {
        return new Subscriber(){

            @Override
            public void handle(Message message) {
                String fileName = MatlabBreakpointMessageService.this.getFileNameFromClientMessage(message);
                int lineNumber = MatlabBreakpointMessageService.getLineNumberFromClientMessage(message);
                MatlabBreakpoint breakpoint = MatlabBreakpoint.create((int)lineNumber, (File)new File(fileName));
                MatlabBreakpointMessageService.this.fDebugger.clearBreakpoint(breakpoint);
            }
        };
    }

    private static int getLineNumberFromClientMessage(Message message) {
        return ((Double)((Map)message.getData()).get("zeroBasedLineNumber")).intValue();
    }

    private String getFileNameFromClientMessage(Message message) {
        return this.convertPathToServer((String)((Map)message.getData()).get("fileName"));
    }

    private Subscriber createAddBreakpointRequestSubscriber() {
        return new Subscriber(){

            @Override
            public void handle(Message message) {
                String fileName = MatlabBreakpointMessageService.this.getFileNameFromClientMessage(message);
                int lineNumber = MatlabBreakpointMessageService.getLineNumberFromClientMessage(message);
                MatlabBreakpoint breakpoint = MatlabBreakpoint.create((int)lineNumber, (File)new File(fileName));
                MatlabBreakpointMessageService.this.fDebugger.setBreakpoint(breakpoint, MatlabBreakpointMessageService.this.errorHandlerCompletionObserver());
            }
        };
    }

    private CompletionObserver errorHandlerCompletionObserver() {
        return new CompletionObserver(){

            public void completed(int status, Object result) {
                if (!MatlabBreakpointMessageService.this.isExecutionStatusSuccess(status)) {
                    MatlabBreakpointMessageService.this.fMessageService.publish("/editor/breakpoint/breakpointsErrored", result);
                }
            }
        };
    }

    private boolean isExecutionStatusSuccess(int status) {
        return Matlab.getExecutionStatus((int)status) == 0;
    }

    @Override
    public void synchronizeBreakpoints(File file) {
        String filePath;
        PeerNode root = this.fBreakpointsDataStore.getRoot();
        Map breakpointData = (Map)root.getProperty(filePath = file.getAbsolutePath());
        if (breakpointData == null) {
            return;
        }
        Object[] breakpoints = (Object[])breakpointData.get("breakpoints");
        if (breakpoints.length == 0) {
            return;
        }
        this.refreshMatlabCacheForFile(file);
        HashMap<String, String> breakpointsRefreshed = new HashMap<String, String>();
        breakpointsRefreshed.put("fileName", filePath);
        this.fMessageService.publish("/editor/breakpoint/breakpointsFileRefreshed", breakpointsRefreshed);
        this.clearAndSetBreakpoints(filePath, breakpoints);
    }

    private void refreshMatlabCacheForFile(File file) {
        MatlabPath.callFSChange((File)file);
        MatlabPath.clearFunction((File)file);
    }
}

