/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jsonconverter.impl.serviceregistry;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import com.mathworks.matlabserver.internalservices.message.AbstractMessageDO;
import com.mathworks.matlabserver.internalservices.serviceendpoints.ServiceRegistryRequestMessageDO;
import com.mathworks.matlabserver.internalservices.serviceendpoints.ServiceRegistryResponseMessageDO;
import com.mathworks.matlabserver.jsonconverter.impl.ConvertUtils;
import com.mathworks.matlabserver.jsonconverter.impl.util.JsonConverterUtil;
import java.lang.reflect.Type;
import java.util.Map;

public class ServiceRegistryConverter
implements JsonDeserializer,
JsonSerializer {
    public static final String PROPERTIES = "properties";
    private static final String FAULT_FIELD = "fault";
    private static final String MESSAGE_FAULT = "messageFaults";

    public Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        AbstractMessageDO retval = null;
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (type == ServiceRegistryRequestMessageDO.class) {
            ServiceRegistryRequestMessageDO request = new ServiceRegistryRequestMessageDO(ConvertUtils.getProperties(jsonObject, PROPERTIES));
            request.setUuid(ConvertUtils.getUuid(jsonObject));
            retval = request;
        } else if (type == ServiceRegistryResponseMessageDO.class) {
            ServiceRegistryResponseMessageDO response = new ServiceRegistryResponseMessageDO(ConvertUtils.getProperties(jsonObject, PROPERTIES));
            response.setUuid(ConvertUtils.getUuid(jsonObject));
            response.setMessageFaults(JsonConverterUtil.getMessageFaults(jsonObject, jsonDeserializationContext));
            retval = response;
        }
        return retval;
    }

    public JsonElement serialize(Object src, Type type, JsonSerializationContext context) {
        JsonObject jsonMap = new JsonObject();
        if (type == ServiceRegistryResponseMessageDO.class) {
            ServiceRegistryResponseMessageDO serviceRegistryResponse = (ServiceRegistryResponseMessageDO)src;
            if (serviceRegistryResponse.getUuid() != null) {
                jsonMap.add("uuid", new JsonPrimitive(serviceRegistryResponse.getUuid()));
            }
            jsonMap.add(FAULT_FIELD, context.serialize(serviceRegistryResponse.getFault()));
            jsonMap.add(MESSAGE_FAULT, context.serialize(serviceRegistryResponse.getMessageFaults()));
            jsonMap.add(PROPERTIES, context.serialize(serviceRegistryResponse.getProperties(), new TypeToken<Map<String, String>>(){}.getType()));
        } else if (type == ServiceRegistryRequestMessageDO.class) {
            ServiceRegistryRequestMessageDO serviceRegistryRequest = (ServiceRegistryRequestMessageDO)src;
            if (serviceRegistryRequest.getUuid() != null) {
                jsonMap.add("uuid", new JsonPrimitive(serviceRegistryRequest.getUuid()));
            }
            jsonMap.add(PROPERTIES, context.serialize(serviceRegistryRequest.getProperties(), new TypeToken<Map<String, String>>(){}.getType()));
        }
        return jsonMap;
    }
}

