/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jsonconverter.impl.opaqueMessageService;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mathworks.matlabserver.internalservices.opaqueMessageService.OpaqueMessageDO;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OpaqueMessageConverter
implements JsonSerializer,
JsonDeserializer {
    private static final Logger logger = Logger.getLogger(OpaqueMessageConverter.class.getName());

    public OpaqueMessageDO deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject jsonMessage = jsonElement.getAsJsonObject();
        OpaqueMessageDO opaqueMessageDO = new OpaqueMessageDO();
        if (type == OpaqueMessageDO.class) {
            opaqueMessageDO.setChannel(jsonMessage.get("channel").getAsString());
            try {
                opaqueMessageDO.setData(jsonMessage.get("data").toString().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e2) {
                logger.log(Level.ALL, "Unable to handle message.", e2);
            }
        }
        return opaqueMessageDO;
    }

    public JsonElement serialize(Object o2, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject jsonMap = new JsonObject();
        if (o2 instanceof OpaqueMessageDO) {
            JsonElement response;
            OpaqueMessageDO opaqueMessageDO = (OpaqueMessageDO)o2;
            if (opaqueMessageDO.getData() != null) {
                JsonParser parser = new JsonParser();
                try {
                    response = parser.parse(new String(opaqueMessageDO.getData(), "UTF-8"));
                }
                catch (Exception e2) {
                    response = new JsonArray();
                }
            } else {
                response = new JsonArray();
            }
            jsonMap.add("data", response);
            jsonMap.add("channel", new JsonPrimitive(opaqueMessageDO.getChannel()));
        }
        return jsonMap;
    }
}

