/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jsonconverter.impl.file;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mathworks.matlabserver.internalservices.file.FileInfoDO;
import com.mathworks.matlabserver.internalservices.file.RenameFileRequestMessageDO;
import com.mathworks.matlabserver.jsonconverter.impl.util.JsonConverterUtil;
import java.lang.reflect.Type;

public class RenameFileRequestConverter
implements JsonSerializer<RenameFileRequestMessageDO>,
JsonDeserializer<RenameFileRequestMessageDO> {
    private static final String SEPERATOR = "/";
    private static final String EMPTY = "";

    @Override
    public JsonElement serialize(RenameFileRequestMessageDO renameFileRequestMessageDO, Type type, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        FileInfoDO originalFileInfo = renameFileRequestMessageDO.getOriginalFileInfo();
        FileInfoDO newFileInfo = renameFileRequestMessageDO.getNewFileInfo();
        String originalFileInfoString = originalFileInfo != null ? originalFileInfo.getLocation() + SEPERATOR + originalFileInfo.getName() : EMPTY;
        String newFileInfoString = newFileInfo != null ? newFileInfo.getLocation() + SEPERATOR + newFileInfo.getName() : EMPTY;
        jsonObject.add("originalFileInfo", JsonConverterUtil.getField(context, originalFileInfoString));
        jsonObject.add("newFileInfo", JsonConverterUtil.getField(context, newFileInfoString));
        jsonObject.add("uuid", JsonConverterUtil.getUuid(context, renameFileRequestMessageDO));
        return jsonObject;
    }

    @Override
    public RenameFileRequestMessageDO deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
        RenameFileRequestMessageDO request = new RenameFileRequestMessageDO();
        JsonObject jsonObject = element.getAsJsonObject();
        request.setUuid(JsonConverterUtil.getUuid(context, jsonObject));
        request.setOriginalFileInfo(JsonConverterUtil.getFileInfo(jsonObject, "originalFileInfo"));
        request.setNewFileInfo(JsonConverterUtil.getFileInfo(jsonObject, "newFileInfo"));
        return request;
    }
}

