/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jsonconverter.impl.file;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mathworks.matlabserver.internalservices.file.DisplayVersionRequestMessageDO;
import com.mathworks.matlabserver.internalservices.file.FileInfoDO;
import com.mathworks.matlabserver.internalservices.file.FileVersionAttributesDO;
import com.mathworks.matlabserver.internalservices.file.ListVersionRequestMessageDO;
import com.mathworks.matlabserver.internalservices.file.SetActiveVersionRequestMessageDO;
import com.mathworks.matlabserver.internalservices.filesharing.GetShareInfoRequestMessageDO;
import com.mathworks.matlabserver.internalservices.message.AbstractMessageDO;
import com.mathworks.matlabserver.jsonconverter.impl.util.JsonConverterUtil;
import java.lang.reflect.Type;
import org.apache.commons.lang.StringUtils;

public class CommonFileMessageConverter
implements JsonSerializer,
JsonDeserializer {
    public Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        AbstractMessageDO retval = null;
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (type == ListVersionRequestMessageDO.class) {
            ListVersionRequestMessageDO request = new ListVersionRequestMessageDO();
            request.setUuid(this.getUuid(jsonObject));
            request.setFileInfo(this.getFileInfo(jsonObject));
            request.setFileInfo(this.addVersionInfo(jsonObject, request.getFileInfo()));
            retval = request;
        } else if (type == DisplayVersionRequestMessageDO.class) {
            DisplayVersionRequestMessageDO request = new DisplayVersionRequestMessageDO();
            request.setUuid(this.getUuid(jsonObject));
            request.setFileInfo(this.getFileInfo(jsonObject));
            request.setFileInfo(this.addVersionInfo(jsonObject, request.getFileInfo()));
            retval = request;
        } else if (type == SetActiveVersionRequestMessageDO.class) {
            SetActiveVersionRequestMessageDO request = new SetActiveVersionRequestMessageDO();
            request.setUuid(this.getUuid(jsonObject));
            request.setFileInfo(this.getFileInfo(jsonObject));
            request.setFileInfo(this.addVersionInfo(jsonObject, request.getFileInfo()));
            retval = request;
        } else if (type == GetShareInfoRequestMessageDO.class) {
            GetShareInfoRequestMessageDO request = new GetShareInfoRequestMessageDO();
            request.setUuid(this.getUuid(jsonObject));
            request.setFiles(this.getFileInfoArray(jsonObject));
            retval = request;
        }
        return retval;
    }

    String getUuid(JsonObject jsonObject) {
        String uuid = null;
        JsonElement element = jsonObject.get("uuid");
        if (element != null) {
            uuid = element.getAsString();
        }
        return uuid;
    }

    FileInfoDO getFileInfo(JsonObject jsonObject) {
        FileInfoDO fileInfo = null;
        JsonElement element = jsonObject.get("path");
        if (element != null) {
            String path = element.getAsString();
            fileInfo = new FileInfoDO(path);
        }
        return fileInfo;
    }

    FileInfoDO addVersionInfo(JsonObject jsonObject, FileInfoDO fileInfo) {
        FileVersionAttributesDO fileVersion = null;
        JsonElement element = jsonObject.get("version");
        if (element != null) {
            String version = element.getAsString();
            fileVersion = new FileVersionAttributesDO();
            fileVersion.setVersionNumber(version);
        }
        fileInfo.setVersion(fileVersion);
        return fileInfo;
    }

    FileInfoDO[] getFileInfoArray(JsonObject jsonObject) {
        FileInfoDO[] fileInfoArray = null;
        JsonElement element = jsonObject.get("paths");
        if (element != null) {
            int size = element.getAsJsonArray().size();
            int index = 0;
            for (FileInfoDO fileInfoElement : fileInfoArray = new FileInfoDO[size]) {
                String path = element.getAsJsonArray().get(index).getAsString();
                fileInfoArray[index] = fileInfoElement = new FileInfoDO(path);
                ++index;
            }
        }
        return fileInfoArray;
    }

    public JsonElement serialize(Object src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject;
        if (src instanceof GetShareInfoRequestMessageDO) {
            jsonObject = new JsonObject();
            JsonArray pathsElement = new JsonArray();
            GetShareInfoRequestMessageDO message = (GetShareInfoRequestMessageDO)src;
            FileInfoDO[] files = message.getFiles();
            if (files != null) {
                for (FileInfoDO file : files) {
                    pathsElement.add(new JsonPrimitive(CommonFileMessageConverter.getFilePath(file)));
                }
            }
            jsonObject.add("paths", pathsElement);
            String uuid = StringUtils.isNotEmpty(message.getUuid()) ? message.getUuid() : "";
            jsonObject.add("uuid", new JsonPrimitive(uuid));
        } else if (src instanceof DisplayVersionRequestMessageDO) {
            jsonObject = new JsonObject();
            DisplayVersionRequestMessageDO message = (DisplayVersionRequestMessageDO)src;
            JsonConverterUtil.populateFromFileInfo(message.getFileInfo(), jsonObject, context, message);
        } else if (src instanceof ListVersionRequestMessageDO) {
            jsonObject = new JsonObject();
            ListVersionRequestMessageDO message = (ListVersionRequestMessageDO)src;
            JsonConverterUtil.populateFromFileInfo(message.getFileInfo(), jsonObject, context, message);
        } else if (src instanceof SetActiveVersionRequestMessageDO) {
            jsonObject = new JsonObject();
            SetActiveVersionRequestMessageDO message = (SetActiveVersionRequestMessageDO)src;
            JsonConverterUtil.populateFromFileInfo(message.getFileInfo(), jsonObject, context, message);
        } else {
            jsonObject = null;
        }
        return jsonObject;
    }

    private static String getFilePath(FileInfoDO file) {
        return file.getLocation() + file.getName();
    }
}

