/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jsonconverter.impl.eval;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mathworks.matlabserver.internalservices.eval.FEvalOpaqueResponseMessageDO;
import com.mathworks.matlabserver.internalservices.faults.MessageFaultDO;
import com.mathworks.matlabserver.jsonconverter.impl.util.JsonConverterUtil;
import java.lang.reflect.Type;
import java.util.List;

public class FEvalResponseConverter
implements JsonSerializer,
JsonDeserializer {
    public JsonElement serialize(Object message, Type type, JsonSerializationContext context) {
        JsonObject jsonMap = new JsonObject();
        if (message instanceof FEvalOpaqueResponseMessageDO) {
            JsonElement response;
            FEvalOpaqueResponseMessageDO fevalResponse = (FEvalOpaqueResponseMessageDO)message;
            if (fevalResponse.getResults() != null) {
                JsonParser parser = new JsonParser();
                try {
                    response = parser.parse(fevalResponse.getResults());
                }
                catch (Exception e2) {
                    response = new JsonArray();
                }
            } else {
                response = new JsonArray();
            }
            jsonMap.add("results", response);
            jsonMap.add("isError", new JsonPrimitive(fevalResponse.isError()));
            if (fevalResponse.getUuid() != null) {
                jsonMap.add("uuid", new JsonPrimitive(fevalResponse.getUuid()));
            }
            JsonElement elementFaults = context.serialize(fevalResponse.getMessageFaults(), fevalResponse.getMessageFaults().getClass());
            jsonMap.add("messageFaults", elementFaults);
        }
        return jsonMap;
    }

    public FEvalOpaqueResponseMessageDO deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonMessage = jsonElement.getAsJsonObject();
        FEvalOpaqueResponseMessageDO message = new FEvalOpaqueResponseMessageDO();
        if (type == FEvalOpaqueResponseMessageDO.class) {
            if (jsonMessage.has("results")) {
                JsonElement intermediateElement = jsonMessage.get("results");
                message.setResults(intermediateElement.isJsonNull() ? null : intermediateElement.getAsJsonArray().toString());
            }
            if (jsonMessage.has("isError")) {
                message.setError(jsonMessage.get("isError").getAsBoolean());
            }
            if (jsonMessage.has("uuid")) {
                message.setUuid(jsonMessage.get("uuid").getAsString());
            }
            if (jsonMessage.has("messageFaults") && !jsonMessage.get("messageFaults").isJsonNull()) {
                List<MessageFaultDO> faults = JsonConverterUtil.getMessageFaults(jsonMessage, context);
                message.setMessageFaults(faults);
                if (!message.isError() && !faults.isEmpty()) {
                    message.setError(true);
                }
            }
        }
        return message;
    }
}

