/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jsonconverter.impl.eval;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mathworks.matlabserver.internalservices.eval.FEvalOpaqueRequestMessageDO;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class FEvalRequestConverter
implements JsonDeserializer,
JsonSerializer {
    private static final String EMPTY = "";

    public FEvalOpaqueRequestMessageDO deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonMessage = jsonElement.getAsJsonObject();
        FEvalOpaqueRequestMessageDO message = new FEvalOpaqueRequestMessageDO();
        if (type == FEvalOpaqueRequestMessageDO.class) {
            try {
                message.setFunction(jsonMessage.get("function").getAsString());
                JsonArray arguments = jsonMessage.get("arguments").getAsJsonArray();
                ArrayList<String> args = new ArrayList<String>();
                for (JsonElement arg : arguments) {
                    args.add(arg.toString());
                }
                message.setArguments(args.toArray(new String[args.size()]));
                message.setNargout(jsonMessage.get("nargout").getAsInt());
                if (jsonMessage.has("priority")) {
                    message.setPriority(jsonMessage.get("priority").getAsInt());
                }
                if (jsonMessage.has("uuid")) {
                    message.setUuid(jsonMessage.get("uuid").getAsString());
                }
            }
            catch (NullPointerException npe) {
                throw new JsonParseException(npe);
            }
        }
        return message;
    }

    public JsonElement serialize(Object message, Type type, JsonSerializationContext context) {
        JsonObject jsonMap = new JsonObject();
        if (message instanceof FEvalOpaqueRequestMessageDO) {
            FEvalOpaqueRequestMessageDO fevalRqst = (FEvalOpaqueRequestMessageDO)message;
            jsonMap.add("function", new JsonPrimitive(fevalRqst.getFunction()));
            JsonArray args = new JsonArray();
            JsonParser parser = new JsonParser();
            for (String fevalArg : fevalRqst.getArguments()) {
                if (EMPTY.equals(fevalArg)) {
                    args.add(new JsonArray());
                    continue;
                }
                args.add(parser.parse(fevalArg));
            }
            jsonMap.add("arguments", args);
            jsonMap.add("nargout", new JsonPrimitive(fevalRqst.getNargout()));
            jsonMap.add("priority", new JsonPrimitive(fevalRqst.getPriority()));
            if (fevalRqst.getUuid() != null) {
                jsonMap.add("uuid", new JsonPrimitive(fevalRqst.getUuid()));
            }
        }
        return jsonMap;
    }
}

