/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jsonconverter.impl.entitledproducts;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import com.mathworks.matlabserver.internalservices.entitledproducts.AuthorizationDetailsResponseMessageDO;
import com.mathworks.matlabserver.internalservices.entitledproducts.EntitledProductsDO;
import com.mathworks.matlabserver.jsonconverter.impl.ConvertUtils;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class AuthorizationDetailsConverter
implements JsonDeserializer,
JsonSerializer {
    private static final Logger logger = Logger.getLogger(AuthorizationDetailsConverter.class.getName());
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final String AUTHORIZED_PRODUCT_PROPERTIES = "authorizationProperties";

    public JsonElement serialize(Object object, Type type, JsonSerializationContext context) {
        AuthorizationDetailsResponseMessageDO authorizationDetailsResponse;
        JsonObject mapObject = new JsonObject();
        if (type == AuthorizationDetailsResponseMessageDO.class && (authorizationDetailsResponse = (AuthorizationDetailsResponseMessageDO)object) != null) {
            JsonObject authorizationProperties = gson.toJsonTree(authorizationDetailsResponse.getAuthorizationProperties()).getAsJsonObject();
            logger.info(authorizationProperties.toString());
            mapObject.add(AUTHORIZED_PRODUCT_PROPERTIES, authorizationProperties);
            mapObject.addProperty("uuid", authorizationDetailsResponse.getUuid());
            JsonElement elementFaults = context.serialize(authorizationDetailsResponse.getMessageFaults(), authorizationDetailsResponse.getMessageFaults().getClass());
            mapObject.add("messageFaults", elementFaults);
        }
        return mapObject;
    }

    public Object deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        AuthorizationDetailsResponseMessageDO retval = null;
        JsonObject jsonObject = json.getAsJsonObject();
        if (type == AuthorizationDetailsResponseMessageDO.class) {
            JsonObject propertiesObject = jsonObject.get(AUTHORIZED_PRODUCT_PROPERTIES).getAsJsonObject();
            AuthorizationDetailsResponseMessageDO response = new AuthorizationDetailsResponseMessageDO();
            response.setUuid(ConvertUtils.getUuid(jsonObject));
            if (propertiesObject != null && propertiesObject.get("authorizedProductIds") != null) {
                JsonArray items = propertiesObject.get("authorizedProductIds").getAsJsonArray();
                Type collectionType = new TypeToken<List<String>>(){}.getType();
                List itemList = (List)gson.fromJson((JsonElement)items, collectionType);
                EntitledProductsDO entitledProducts = new EntitledProductsDO();
                entitledProducts.setEntitledProducts(itemList.toArray(new String[itemList.size()]));
                response.getAuthorizationProperties().put("authorizedProductIds", itemList);
            } else {
                response.getAuthorizationProperties().put("", Arrays.asList(""));
            }
            retval = response;
        }
        return retval;
    }
}

