/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.internalconnector.servlet;

import com.mathworks.jmi.NativeMatlab;
import com.mathworks.matlabserver.connectorcommon.fileservices.decorator.RehashDecorator;
import com.mathworks.matlabserver.connectorcommon.fileservices.impl.FileServiceConnectorDirect;
import com.mathworks.matlabserver.connectorcommon.fileservices.impl.FilenameConverterConnectorDirect;
import com.mathworks.matlabserver.connectorcommon.fileservices.versioning.MockVersionServiceConnectorImpl;
import com.mathworks.matlabserver.connectorcommon.mlsedu.serviceproviders.ConnectorCommonInitializer;
import com.mathworks.matlabserver.connectorcommon.mlsedu.serviceproviders.desktopservices.MockPathManagerImpl;
import com.mathworks.matlabserver.connectorcommon.servlet.NullContextListener;
import com.mathworks.matlabserver.editordataservice.EditorDataServiceInitialize;
import com.mathworks.matlabserver.fileservices.decorator.Base64Decorator;
import com.mathworks.matlabserver.fileservices.decorator.FileServiceUniquenessDecorator;
import com.mathworks.matlabserver.fileservices.impl.FileMessageServiceImpl;
import com.mathworks.matlabserver.fileservices.util.FilenameConverter;
import com.mathworks.matlabserver.internalconnector.worker.EvalConnectorImpl;
import com.mathworks.matlabserver.internalservices.file.FileMessageService;
import com.mathworks.matlabserver.internalservices.file.FileService;
import com.mathworks.matlabserver.internalservices.file.VersionService;
import com.mathworks.matlabserver.internalservices.security.UserTokenDO;
import com.mathworks.matlabserver.internalservices.serviceregistry.RegistryService;
import com.mathworks.matlabserver.internalservices.serviceregistry.ServiceRegistryFactory;
import com.mathworks.matlabserver.worker.desktopservices.BreakpointSyncManager;
import com.mathworks.matlabserver.worker.desktopservices.CodeAnalyzer;
import com.mathworks.matlabserver.worker.desktopservices.DesktopServicesFacade;
import com.mathworks.matlabserver.worker.desktopservices.Eval;
import com.mathworks.matlabserver.worker.desktopservices.UserManager;
import com.mathworks.matlabserver.worker.service.breakpoint.impl13b.MatlabBreakpointMessageService;
import com.mathworks.matlabserver.worker.service.variableeditor.impl13b.VariableEditorImpl13b;
import com.mathworks.matlabserver.worker.services.codeanalyzer.impl13a.CodeAnalyzerImpl;
import com.mathworks.matlabserver.worker.services.syntaxhighlighting.impl11b.SyntaxHighlightingImpl;
import com.mathworks.matlabserver.workercommon.client.ClientServiceRegistry;
import com.mathworks.matlabserver.workercommon.client.ClientServiceRegistryFactory;
import com.mathworks.matlabserver.workercommon.client.services.ClientBrowserServiceImpl;
import com.mathworks.matlabserver.workercommon.client.services.ClientCommandWindowServiceImpl;
import com.mathworks.matlabserver.workercommon.client.services.ClientEditorServiceImpl;
import com.mathworks.matlabserver.workercommon.desktopservices.DesktopServicesFacadeImpl;
import com.mathworks.matlabserver.workercommon.desktopservices.WorkerConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletContextEvent;

public class ContextListenerImpl
extends NullContextListener {
    private static final Logger logger = Logger.getLogger(ContextListenerImpl.class.getName());
    private static final ConnectorCommonInitializer initializer = new ConnectorCommonInitializer(new DesktopServicesFacadeImpl());

    @Override
    public void contextInitialized(ServletContextEvent sce) {
        logger.info("contextInitializer");
        initializer.initialize();
        EditorDataServiceInitialize.initialized();
        FilenameConverterConnectorDirect filenameConverter = new FilenameConverterConnectorDirect();
        String rootDir = filenameConverter.getWorkerMountPoint();
        DesktopServicesFacadeImpl desktopFacade = this.initDesktopServicesFacade(initializer, rootDir);
        FileService fileService = new FileServiceConnectorDirect(filenameConverter);
        RehashDecorator rehashDecorator = new RehashDecorator();
        rehashDecorator.setDecoratedFileService(fileService);
        ClientEditorServiceImpl editorService = new ClientEditorServiceImpl(desktopFacade.getUserManager(), fileService);
        logger.info("Initializing the client services.");
        ClientServiceRegistry clientServiceRegistry = ClientServiceRegistryFactory.getClientServiceRegistry();
        clientServiceRegistry.registerService("UserManager", desktopFacade.getUserManager());
        clientServiceRegistry.registerService("ClientBrowserService", new ClientBrowserServiceImpl());
        clientServiceRegistry.registerService("ClientEditorService", editorService);
        clientServiceRegistry.registerService("ClientCommandWindowService", new ClientCommandWindowServiceImpl());
        fileService = new FileServiceUniquenessDecorator(desktopFacade.getPathManager(), fileService);
        Base64Decorator base64FileService = new Base64Decorator();
        base64FileService.setDecoratedFileService(fileService);
        rehashDecorator = new RehashDecorator();
        rehashDecorator.setDecoratedFileService(base64FileService);
        RegistryService serviceRegistry = ServiceRegistryFactory.getServiceRegistry();
        serviceRegistry.registerService(DesktopServicesFacade.class, (Object)desktopFacade);
        serviceRegistry.registerService(FileService.class, (Object)rehashDecorator);
        serviceRegistry.registerService(FileMessageService.class, (Object)new FileMessageServiceImpl());
        serviceRegistry.registerService(VersionService.class, (Object)new MockVersionServiceConnectorImpl(filenameConverter, fileService));
        serviceRegistry.registerService(BreakpointSyncManager.class, (Object)new MatlabBreakpointMessageService());
        serviceRegistry.registerService(FilenameConverter.class, (Object)filenameConverter);
        serviceRegistry.registerService(UserManager.class, (Object)desktopFacade.getUserManager());
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        initializer.destroy();
    }

    private DesktopServicesFacadeImpl initDesktopServicesFacade(ConnectorCommonInitializer initializer, String rootDir) {
        DesktopServicesFacadeImpl desktopFacade = initializer.getFacade();
        desktopFacade.setEvalImpl(this.getEvalImpl());
        desktopFacade.setSyntaxHighlightingService(new SyntaxHighlightingImpl());
        desktopFacade.getUserManager().setUserHomeDir(rootDir);
        desktopFacade.getUserManager().setUserToken(new UserTokenDO("admin"));
        desktopFacade.getUserManager().getUserToken().setSessionCorrelationId("");
        desktopFacade.setCodeAnalyzerImpl(this.getCodeAnalyzerImpl());
        desktopFacade.setVariableEditorImpl(new VariableEditorImpl13b(new WorkerConfig()));
        desktopFacade.setPathManager(new MockPathManagerImpl());
        return desktopFacade;
    }

    private Eval getEvalImpl() {
        HashMap<String, String> versionClassMapping = new HashMap<String, String>();
        versionClassMapping.put("13b", "com.mathworks.matlabserver.worker.service.eval.impl13b.MvmEval13bImpl");
        versionClassMapping.put("13a", "com.mathworks.matlabserver.worker.service.eval.impl13a.MvmEvalListenerImpl");
        Eval evalImpl = (Eval)this.tryGetEvalInstanceByMatlabVersion(versionClassMapping);
        if (evalImpl == null) {
            evalImpl = new EvalConnectorImpl();
        }
        logger.info("Eval Impl Created: " + evalImpl.getClass().getName());
        return evalImpl;
    }

    private CodeAnalyzer getCodeAnalyzerImpl() {
        HashMap<String, String> versionClassMapping = new HashMap<String, String>();
        versionClassMapping.put("13a", "com.mathworks.matlabserver.worker.services.codeanalyzer.impl13a.CodeAnalyzerImpl");
        CodeAnalyzer codeAnalyzerImpl = (CodeAnalyzer)this.tryGetInstanceByMatlabVersion(versionClassMapping);
        if (codeAnalyzerImpl == null) {
            codeAnalyzerImpl = new CodeAnalyzerImpl();
        }
        logger.info("CodeAnalyzer Impl Created: " + codeAnalyzerImpl.getClass().getName());
        return codeAnalyzerImpl;
    }

    private Object tryGetInstanceByMatlabVersion(Map<String, String> versionClassMapping) {
        try {
            Class<?> clazz = this.tryGetClassByMatlabVersion(versionClassMapping);
            return clazz.newInstance();
        }
        catch (Exception e2) {
            logger.warning("Cannot instantiate class:" + e2.getMessage());
            return null;
        }
    }

    private Object tryGetEvalInstanceByMatlabVersion(Map<String, String> versionClassMapping) {
        try {
            Class<?> clazz = this.tryGetClassByMatlabVersion(versionClassMapping);
            if (clazz.getName().equals(versionClassMapping.get("13b"))) {
                return clazz.getConstructor(Boolean.TYPE).newInstance(false);
            }
            return clazz.newInstance();
        }
        catch (Exception e2) {
            logger.warning("Cannot instantiate class:" + e2.getMessage());
            return null;
        }
    }

    private Class<?> tryGetClassByMatlabVersion(Map<String, String> versionClassMapping) throws ClassNotFoundException {
        String sVersion = NativeMatlab.GetMatlabVersion();
        int firstParen = sVersion.indexOf(40);
        int lastParen = sVersion.indexOf(41);
        int year = Integer.parseInt(sVersion.substring(firstParen + 4, lastParen - 1));
        String sub = sVersion.substring(lastParen - 1, lastParen);
        for (int i2 = year; i2 > 10; --i2) {
            String version = String.valueOf(i2) + sub;
            if (versionClassMapping.containsKey(version)) {
                return Class.forName(versionClassMapping.get(version));
            }
            if (sub.equals("b")) {
                sub = "a";
                ++i2;
                continue;
            }
            sub = "b";
        }
        return null;
    }
}

