/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.fileservices.locking.impl;

import com.mathworks.matlabserver.fileservices.locking.FileLockDAO;
import com.mathworks.matlabserver.internalservices.file.FileInfoDO;
import com.mathworks.matlabserver.internalservices.file.FileLockDO;
import com.mathworks.matlabserver.internalservices.security.UserTokenDO;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class FileLockDAOInMemoryImpl
implements FileLockDAO {
    private static final Logger logger = Logger.getLogger(FileLockDAOInMemoryImpl.class.getName());
    private final Map<String, FileLockDO> fileLocks = new HashMap<String, FileLockDO>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean addLock(FileInfoDO fileInfo, FileLockDO fileLock) {
        if (!this.fileLocks.containsKey(this.getUniqueID(fileInfo))) {
            Map<String, FileLockDO> map = this.fileLocks;
            synchronized (map) {
                this.fileLocks.put(this.getUniqueID(fileInfo), fileLock);
            }
            return true;
        }
        return false;
    }

    @Override
    public FileLockDO getLock(FileInfoDO fileInfo) {
        return this.cloneLock(this.fileLocks.get(this.getUniqueID(fileInfo)));
    }

    @Override
    public synchronized FileLockDO removeLock(FileInfoDO fileInfo) {
        return this.cloneLock(this.fileLocks.remove(this.getUniqueID(fileInfo)));
    }

    @Override
    public synchronized Boolean removeLocksByOwner(UserTokenDO owner) {
        Boolean modified = false;
        Set<String> keys = this.fileLocks.keySet();
        Iterator<String> keyIterator = keys.iterator();
        while (keyIterator.hasNext()) {
            String key = keyIterator.next();
            FileLockDO lock = this.fileLocks.get(key);
            if (lock == null || !this.compareUsers(lock.getLockOwner(), owner).booleanValue()) continue;
            keyIterator.remove();
            modified = true;
        }
        return modified;
    }

    private String getUniqueID(FileInfoDO fileInfo) {
        return fileInfo.getLocation() + fileInfo.getName();
    }

    private Boolean compareUsers(String user1, UserTokenDO user2) {
        return user1.equals(user2.getName());
    }

    private FileLockDO cloneLock(FileLockDO fileLock) {
        try {
            FileLockDO newLock = new FileLockDO();
            newLock.setEditable(fileLock.isEditable());
            newLock.setLockOwner(fileLock.getLockOwner());
            return newLock;
        }
        catch (Exception e2) {
            logger.warning("Unable to clone FileLockDO: " + fileLock + ", exception=" + e2.getMessage());
            return fileLock;
        }
    }
}

