/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.fileservices.impl;

import com.mathworks.matlabserver.common.xml.DocumentBuilderFactoryWrapper;
import com.mathworks.matlabserver.fileservices.impl.FileServiceWebdavImpl;
import com.mathworks.matlabserver.fileservices.impl.WebdavClient;
import com.mathworks.matlabserver.internalservices.faults.MLSException;
import com.mathworks.matlabserver.internalservices.security.UserTokenDO;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.CheckinMethod;
import org.apache.jackrabbit.webdav.client.methods.CheckoutMethod;
import org.apache.jackrabbit.webdav.client.methods.DeleteMethod;
import org.apache.jackrabbit.webdav.client.methods.MkColMethod;
import org.apache.jackrabbit.webdav.client.methods.MoveMethod;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.client.methods.PutMethod;
import org.apache.jackrabbit.webdav.client.methods.ReportMethod;
import org.apache.jackrabbit.webdav.client.methods.VersionControlMethod;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.xml.DomUtil;

public class WebdavClientImpl
implements WebdavClient {
    private static final Logger logger = Logger.getLogger(FileServiceWebdavImpl.class.getName());
    private final HttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
    private HostConfiguration hostConfig = new HostConfiguration();

    public WebdavClientImpl(String host) {
        this.hostConfig.setHost(host);
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        params.setMaxConnectionsPerHost(this.hostConfig, 20);
        params.setTcpNoDelay(true);
        params.setConnectionTimeout(30000);
        params.setSoTimeout(180000);
        this.connectionManager.setParams(params);
        DomUtil.setBuilderFactory((DocumentBuilderFactory)DocumentBuilderFactoryWrapper.newDocumentBuilderFactoryWrapper());
    }

    @Override
    public HttpClient getHttpClient(UserTokenDO userToken) {
        HttpClient client = new HttpClient(this.connectionManager);
        client.setHostConfiguration(this.hostConfig);
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(userToken.getName(), userToken.getFileSessionId());
        client.getState().setCredentials(AuthScope.ANY, (Credentials)creds);
        HttpClientParams clientParams = new HttpClientParams();
        clientParams.setVersion(HttpVersion.HTTP_1_1);
        clientParams.setAuthenticationPreemptive(true);
        client.setParams(clientParams);
        return client;
    }

    @Override
    public MultiStatusResponse[] getProperty(HttpClient client, String fileUrl, DavPropertyName name, int depth) {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add(name);
        return this.getProperties(client, fileUrl, nameSet, depth);
    }

    @Override
    public MultiStatusResponse[] getProperties(HttpClient client, String fileUrl, DavPropertyNameSet nameSet, int depth) {
        return this.propFind(client, fileUrl, 0, nameSet, depth);
    }

    @Override
    public MultiStatusResponse[] getAllProperties(HttpClient client, String fileUrl, int depth) {
        return this.propFind(client, fileUrl, 1, new DavPropertyNameSet(), depth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiStatusResponse[] propFind(HttpClient client, String fileUrl, int type, DavPropertyNameSet nameSet, int depth) {
        MultiStatusResponse[] responses;
        PropFindMethod method = null;
        try {
            method = new PropFindMethod(fileUrl, type, nameSet, depth);
            this.setupMethod((HttpMethod)method);
            client.executeMethod((HttpMethod)method);
            MultiStatus multiStatus = method.getResponseBodyAsMultiStatus();
            multiStatus.getResponses();
            responses = multiStatus.getResponses();
        }
        catch (Exception e2) {
            String message = "Did not get the properties of the file: " + fileUrl;
            logger.log(Level.FINEST, message, e2);
            responses = null;
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return responses;
    }

    @Override
    public MultiStatusResponse[] report(HttpClient client, String fileUrl, ReportInfo reportInfo) {
        MultiStatusResponse[] responses = null;
        ReportMethod method = null;
        try {
            method = new ReportMethod(fileUrl, reportInfo);
            this.setupMethod((HttpMethod)method);
            client.executeMethod((HttpMethod)method);
            MultiStatus status = method.getResponseBodyAsMultiStatus();
            responses = status.getResponses();
            method.checkSuccess();
        }
        catch (Exception e2) {
            String message = "Unable to get report for: " + fileUrl + " error: " + e2.getMessage();
            logger.log(Level.SEVERE, message, e2);
            throw this.createMLSException(e2, message);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return responses;
    }

    @Override
    public byte[] getFile(HttpClient client, String fileUrl) {
        byte[] response;
        GetMethod method = null;
        try {
            method = new GetMethod(fileUrl);
            this.setupMethod((HttpMethod)method);
            client.executeMethod((HttpMethod)method);
            response = method.getResponseBody();
            if (method.getStatusCode() != 200) {
                throw this.createMLSException("Unable to get file, status code of: " + method.getStatusCode());
            }
        }
        catch (IOException e2) {
            String message = "Unable to get file: " + e2.getMessage();
            logger.log(Level.SEVERE, message, e2);
            throw this.createMLSException(e2, message);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return response;
    }

    @Override
    public void putFile(HttpClient client, String fileUrl, byte[] bytes) {
        PutMethod method = null;
        try {
            method = new PutMethod(fileUrl);
            ByteArrayRequestEntity requestEntity = new ByteArrayRequestEntity(bytes);
            method.setRequestEntity((RequestEntity)requestEntity);
            this.setupMethod((HttpMethod)method);
            client.executeMethod((HttpMethod)method);
            method.checkSuccess();
        }
        catch (Exception e2) {
            String message = "Unable to put file: " + fileUrl + " error: " + e2.getMessage();
            logger.log(Level.SEVERE, message, e2);
            throw this.createMLSException(e2, message);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    @Override
    public void putFolder(HttpClient client, String fileUrl) {
        MkColMethod method = null;
        try {
            method = new MkColMethod(fileUrl);
            this.setupMethod((HttpMethod)method);
            client.executeMethod((HttpMethod)method);
            method.checkSuccess();
        }
        catch (Exception e2) {
            String message = "Unable to make folder: " + e2.getMessage();
            logger.log(Level.SEVERE, message, e2);
            throw this.createMLSException(e2, message);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    @Override
    public void moveFile(HttpClient client, String sourceFileUrl, String destinationFileUrl) {
        MoveMethod method = null;
        try {
            method = new MoveMethod(sourceFileUrl, destinationFileUrl, false);
            this.setupMethod((HttpMethod)method);
            client.executeMethod((HttpMethod)method);
            method.checkSuccess();
        }
        catch (Exception e2) {
            String message = "Unable to move file: " + e2.getMessage();
            logger.log(Level.SEVERE, message, e2);
            throw this.createMLSException(e2, message);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    @Override
    public void deleteFile(HttpClient client, String fileUrl) {
        DeleteMethod method = null;
        try {
            method = new DeleteMethod(fileUrl);
            this.setupMethod((HttpMethod)method);
            client.executeMethod((HttpMethod)method);
            method.checkSuccess();
        }
        catch (Exception e2) {
            String message = "Unable to delete file: " + e2.getMessage();
            logger.log(Level.SEVERE, message, e2);
            throw this.createMLSException(e2, message);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    @Override
    public void checkout(HttpClient client, String fileUrl) {
        CheckoutMethod method = null;
        try {
            method = new CheckoutMethod(fileUrl);
            this.setupMethod((HttpMethod)method);
            client.executeMethod((HttpMethod)method);
            method.checkSuccess();
        }
        catch (Exception e2) {
            String message = "Unable to checkout file: " + fileUrl + " error: " + e2.getMessage();
            logger.log(Level.SEVERE, message, e2);
            throw this.createMLSException(e2, message);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    @Override
    public void checkin(HttpClient client, String fileUrl) {
        CheckinMethod method = null;
        try {
            method = new CheckinMethod(fileUrl);
            this.setupMethod((HttpMethod)method);
            client.executeMethod((HttpMethod)method);
            method.checkSuccess();
        }
        catch (Exception e2) {
            String message = "Unable to checkin file: " + fileUrl + " error: " + e2.getMessage();
            logger.log(Level.SEVERE, message, e2);
            throw this.createMLSException(e2, message);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    @Override
    public void versionControl(HttpClient client, String fileUrl) {
        VersionControlMethod method = null;
        try {
            method = new VersionControlMethod(fileUrl);
            this.setupMethod((HttpMethod)method);
            client.executeMethod((HttpMethod)method);
            method.checkSuccess();
        }
        catch (Exception e2) {
            String message = "Unable to version control file: " + fileUrl + " error: " + e2.getMessage();
            logger.log(Level.SEVERE, message, e2);
            throw this.createMLSException(e2, message);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private void setupMethod(HttpMethod method) {
        method.setFollowRedirects(false);
        method.setRequestHeader("User-Agent", "MLS");
        method.addRequestHeader("Cache-control", "no-cache");
        method.addRequestHeader("Cache-store", "no-store");
        method.addRequestHeader("Pragma", "no-cache");
        method.addRequestHeader("Expires", "0");
    }

    private MLSException createMLSException(String message) {
        return new MLSException("FileService.IOError", message);
    }

    private MLSException createMLSException(Exception e2, String message) {
        MLSException mlsException = new MLSException("FileService.IOError", message);
        mlsException.initCause(e2);
        return mlsException;
    }
}

