/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.fileservices.impl;

import com.mathworks.matlabserver.fileservices.policy.MetadataProviderManager;
import com.mathworks.matlabserver.fileservices.util.FilenameConverter;
import com.mathworks.matlabserver.internalservices.faults.MLSException;
import com.mathworks.matlabserver.internalservices.file.FileDO;
import com.mathworks.matlabserver.internalservices.file.FileInfoDO;
import com.mathworks.matlabserver.internalservices.file.FileService;
import com.mathworks.matlabserver.internalservices.file.IncrementalFileService;
import com.mathworks.matlabserver.internalservices.filesharing.ShareAttributesDO;
import com.mathworks.matlabserver.internalservices.security.UserTokenDO;
import com.mathworks.matlabserver.worker_config_management.MatlabServerConfigBean;
import com.mathworks.matlabserver.worker_config_management.MatlabServerConfigFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class FileServiceCaching
implements IncrementalFileService {
    private static final Logger logger = Logger.getLogger(FileServiceCaching.class.getName());
    public static final String DIRTY = "dirty";
    public static final String CLEAN = "clean";
    private static final String DEBUG_FILE_NAME = ".fusedebug";
    private static final String CLEAR_CACHE_FILE_NAME = ".fuseclearcache";
    private FileService remoteFileService;
    private final String localCacheDir;
    private final FilenameConverter filenameConverter;
    private final ConcurrentHashMap<String, DirEntry> dirInfoCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, FileInfoDO> fileInfoCache = new ConcurrentHashMap();
    private final MetadataProviderManager metadataProvider;
    private boolean disableCacheForSharedFolders;

    public FileServiceCaching(FileService remoteFileService, String localCacheDir, FilenameConverter filenameConverter) {
        this.remoteFileService = remoteFileService;
        try {
            localCacheDir = FilenameUtils.normalize(new File(localCacheDir).getCanonicalPath() + File.separator);
        }
        catch (IOException ignored) {
            logger.severe("Unable to convert: " + localCacheDir + " to a canonical path");
        }
        this.localCacheDir = localCacheDir;
        this.metadataProvider = new MetadataProviderManager();
        this.filenameConverter = filenameConverter;
        MatlabServerConfigBean bean = MatlabServerConfigFactory.getConfig();
        this.disableCacheForSharedFolders = bean.isDisableFileSystemCacheForSharedFolders();
        this.initializeCache();
    }

    public synchronized void clearCache() {
        logger.info("Clearing the in-memory and file based caches.");
        this.dirInfoCache.clear();
        this.fileInfoCache.clear();
        this.initializeCache();
    }

    @Override
    public synchronized InputStream readContent(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        FileInputStream retVal;
        String metaDataKey = this.mapFileInfoToPath(userToken, fileInfo);
        String cachePath = this.localCacheDir + File.separator + metaDataKey;
        File cacheFile = new File(cachePath);
        FileInfoDO localFileInfo = this.fileInfoCache.get(metaDataKey);
        if (localFileInfo == null || !cacheFile.exists()) {
            FileDO remoteFile = this.remoteFileService.read(userToken, fileInfo);
            try {
                if (!cacheFile.exists()) {
                    FileUtils.forceMkdir(cacheFile.getParentFile());
                    FileUtils.touch(cacheFile);
                }
                FileUtils.writeByteArrayToFile(cacheFile, remoteFile.getData());
            }
            catch (IOException e2) {
                throw this.createMLSException("readContent(" + metaDataKey + ") failed while writing to the local cache. ", e2);
            }
            this.fileInfoCache.put(metaDataKey, remoteFile.getFileInfo());
        }
        try {
            retVal = FileUtils.openInputStream(cacheFile);
        }
        catch (IOException e3) {
            throw this.createMLSException("readContent(" + metaDataKey + ") failed wile opening the input stream. ", e3);
        }
        return retVal;
    }

    @Override
    public synchronized FileInfoDO readInfo(UserTokenDO userToken, FileInfoDO fileInfo) {
        String metaDataKey = this.mapFileInfoToPath(userToken, fileInfo);
        FileInfoDO retVal = this.fileInfoCache.get(metaDataKey);
        if (retVal == null && (retVal = this.remoteFileService.readInfo(userToken, fileInfo)) != null && !this.isConsumedShareData(retVal)) {
            this.fileInfoCache.put(metaDataKey, retVal);
        }
        return retVal;
    }

    @Override
    public synchronized FileInfoDO updateInfo(UserTokenDO userToken, FileInfoDO fileInfo) {
        FileInfoDO updatedFileInfo = this.remoteFileService.updateInfo(userToken, fileInfo);
        String metaDataKey = this.mapFileInfoToPath(userToken, updatedFileInfo);
        this.fileInfoCache.put(metaDataKey, updatedFileInfo);
        this.setDirty(updatedFileInfo);
        return updatedFileInfo;
    }

    @Override
    public synchronized FileInfoDO[] list(UserTokenDO userToken, FileInfoDO directory) throws MLSException {
        FileInfoDO[] files;
        String metaDataKey = this.mapFileInfoToPath(userToken, directory);
        DirEntry dirMetaData = this.dirInfoCache.get(metaDataKey);
        if (this.isConsumedShareData(directory)) {
            files = this.remoteFileService.list(userToken, directory);
        } else if (dirMetaData == null) {
            dirMetaData = new DirEntry();
            files = this.remoteFileService.list(userToken, directory);
            String[] filePaths = new String[files.length];
            for (int i2 = 0; i2 < filePaths.length; ++i2) {
                filePaths[i2] = this.mapFileInfoToPath(userToken, files[i2]);
                String fileInfoKey = this.mapFileInfoToPath(userToken, files[i2]);
                FileInfoDO oldFile = this.fileInfoCache.get(fileInfoKey);
                if (oldFile != null) {
                    files[i2].setType(oldFile.getType());
                }
                this.fileInfoCache.put(fileInfoKey, files[i2]);
            }
            dirMetaData.filePaths = filePaths;
            dirMetaData.dirFileInfo = this.readInfo(userToken, directory);
            this.dirInfoCache.put(metaDataKey, dirMetaData);
        } else {
            files = new FileInfoDO[dirMetaData.filePaths.length];
            for (int i3 = 0; i3 < files.length; ++i3) {
                files[i3] = this.fileInfoCache.get(dirMetaData.filePaths[i3]);
                if (files[i3] != null) continue;
                String path = dirMetaData.filePaths[i3];
                path = path.substring(userToken.getName().length() + 1);
                path = this.getWorkerMountPoint() + path;
                FileInfoDO fileInfo = new FileInfoDO(path, "/", -1);
                files[i3] = this.readInfo(userToken, fileInfo);
            }
        }
        return files;
    }

    @Override
    public synchronized FileInfoDO close(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        FileInfoDO updatedFileInfo;
        String metaDataKey = this.mapFileInfoToPath(userToken, fileInfo);
        String cachePath = this.sandbox(metaDataKey);
        File cacheFile = new File(cachePath);
        try {
            updatedFileInfo = this.fileInfoCache.get(metaDataKey);
            if (updatedFileInfo != null && this.isDirty(updatedFileInfo)) {
                if (cacheFile.exists()) {
                    FileDO file = new FileDO(fileInfo);
                    byte[] data = FileUtils.readFileToByteArray(cacheFile);
                    file.setData(data);
                    if (this.remoteFileService.exists(userToken, fileInfo)) {
                        updatedFileInfo = this.remoteFileService.update(userToken, file);
                    } else {
                        updatedFileInfo = this.remoteFileService.create(userToken, file);
                        updatedFileInfo.setSize(data.length);
                    }
                    this.clearDirty(updatedFileInfo);
                    this.fileInfoCache.put(metaDataKey, updatedFileInfo);
                    this.dirInfoCache.remove(this.mapFileInfoToParentPath(userToken, updatedFileInfo));
                } else {
                    logger.severe("Attempting to close " + cacheFile.getAbsolutePath() + " but the file does not exist");
                }
            }
            if (this.isConsumedShareData(this.metadataProvider.addMetadata(fileInfo, true))) {
                this.fileInfoCache.remove(metaDataKey);
            }
        }
        catch (MLSException mlse) {
            this.fileInfoCache.remove(metaDataKey);
            FileUtils.deleteQuietly(cacheFile);
            throw this.createMLSException("remoteFileService.close(" + userToken.getName() + ", " + metaDataKey + ") had an error", mlse);
        }
        catch (IOException e2) {
            this.fileInfoCache.remove(metaDataKey);
            FileUtils.deleteQuietly(cacheFile);
            throw this.createMLSException("remoteFileService.close(" + userToken.getName() + ", " + metaDataKey + ") had an error", e2);
        }
        return updatedFileInfo;
    }

    @Override
    public synchronized FileInfoDO create(UserTokenDO userToken, FileDO file) throws MLSException {
        String metaDataKey = this.mapFileInfoToPath(userToken, file.getFileInfo());
        String cachePath = this.sandbox(metaDataKey);
        FileInfoDO retVal = this.convertToFileInfoDO(cachePath);
        try {
            if (retVal.getName().equals(DEBUG_FILE_NAME)) {
                this.dumpCaches(cachePath + " for user: " + userToken.toString());
                return retVal;
            }
            if (retVal.getName().equals(CLEAR_CACHE_FILE_NAME)) {
                this.clearCache();
                return retVal;
            }
            if (file.getFileInfo().isDirectory()) {
                retVal.setDirectory(true);
                retVal = this.remoteFileService.create(userToken, file);
            } else {
                this.setDirty(retVal);
                boolean forceRefresh = false;
                retVal = this.metadataProvider.addMetadata(retVal, forceRefresh);
            }
            Date now = new Date();
            retVal.setCreated(now);
            retVal.setModified(now);
            this.dirInfoCacheAddFile(userToken, retVal);
            this.writeFileOrDirToLocalContentCache(cachePath, file);
            this.fileInfoCache.put(metaDataKey, retVal);
        }
        catch (MLSException mlse) {
            throw this.createMLSException("create(" + userToken.toString() + ", " + file.getFileInfo().getLocation() + File.separator + file.getFileInfo().getName() + ") failed.", mlse);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized FileInfoDO delete(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        FileInfoDO retVal = null;
        String metaDataKey = this.mapFileInfoToPath(userToken, fileInfo);
        String cachePath = this.sandbox(metaDataKey);
        File cacheFile = new File(cachePath);
        boolean isDirectory = fileInfo.isDirectory() || cacheFile.isDirectory();
        try {
            retVal = this.remoteFileService.delete(userToken, fileInfo);
        }
        finally {
            try {
                if (isDirectory && cacheFile.exists()) {
                    FileUtils.deleteDirectory(cacheFile);
                } else if (!isDirectory) {
                    FileUtils.deleteQuietly(cacheFile);
                }
            }
            catch (IOException ioe) {
                throw this.createMLSException("remoteFileService.delete(" + userToken.getName() + ", " + metaDataKey + ") had an error", ioe);
            }
            finally {
                this.fileInfoCache.remove(metaDataKey);
                if (retVal != null) {
                    retVal.setDirectory(isDirectory);
                    this.dirInfoCacheRemoveFile(userToken, retVal);
                }
                if (isDirectory) {
                    this.dirInfoCache.remove(metaDataKey);
                }
            }
        }
        return retVal;
    }

    @Override
    public synchronized FileInfoDO[] delete(UserTokenDO userToken, FileInfoDO[] fileInfoArray) throws MLSException {
        FileInfoDO[] retVal = new FileInfoDO[fileInfoArray.length];
        for (int i2 = 0; i2 < fileInfoArray.length; ++i2) {
            retVal[i2] = this.delete(userToken, fileInfoArray[i2]);
        }
        return retVal;
    }

    @Override
    public synchronized FileInfoDO[] move(UserTokenDO userToken, FileInfoDO[] sourceFileInfoArray, FileInfoDO destinationFileInfo) throws MLSException {
        FileInfoDO[] newFileInfoArray = this.remoteFileService.move(userToken, sourceFileInfoArray, destinationFileInfo);
        for (FileInfoDO fileInfo : sourceFileInfoArray) {
            String metaDataKey = this.mapFileInfoToPath(userToken, fileInfo);
            this.fileInfoCache.remove(metaDataKey);
            String cachePath = this.sandbox(metaDataKey);
            File cacheFile = new File(cachePath);
            if (cacheFile.exists()) {
                FileUtils.deleteQuietly(cacheFile);
            }
            this.dirInfoCacheRemoveFile(userToken, fileInfo);
        }
        for (FileInfoDO fileInfo : newFileInfoArray) {
            this.dirInfoCacheAddFile(userToken, fileInfo);
        }
        return newFileInfoArray;
    }

    @Override
    public synchronized FileDO open(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        return this.read(userToken, fileInfo);
    }

    @Override
    public synchronized FileDO read(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        FileDO retVal;
        String metaDataKey = this.mapFileInfoToPath(userToken, fileInfo);
        InputStream contentStream = this.readContent(userToken, fileInfo);
        try {
            byte[] content = IOUtils.toByteArray(contentStream);
            boolean forceRefresh = false;
            FileInfoDO updatedFileInfo = this.metadataProvider.addMetadata(fileInfo, forceRefresh);
            retVal = new FileDO(updatedFileInfo);
            retVal.setData(content);
        }
        catch (IOException e2) {
            this.fileInfoCache.remove(metaDataKey);
            throw this.createMLSException("FileServiceCaching.read(" + userToken.getName() + ", " + metaDataKey + ") had an error", e2);
        }
        finally {
            IOUtils.closeQuietly(contentStream);
        }
        return retVal;
    }

    @Override
    public synchronized FileInfoDO rename(UserTokenDO userToken, FileInfoDO srcFileInfo, FileInfoDO destFileInfo) throws MLSException {
        FileInfoDO updatedDestFileInfo = null;
        try {
            String srcMetaDataKey = this.mapFileInfoToPath(userToken, srcFileInfo);
            String srcCachePath = this.sandbox(srcMetaDataKey);
            File srcFile = new File(srcCachePath);
            updatedDestFileInfo = this.remoteFileService.rename(userToken, srcFileInfo, destFileInfo);
            String destMetaDataKey = this.mapFileInfoToPath(userToken, destFileInfo);
            String destCachePath = this.sandbox(destMetaDataKey);
            File destFile = new File(destCachePath);
            try {
                if (srcFile.exists()) {
                    File destFileParent = new File(destFile.getParent());
                    if (!destFileParent.exists()) {
                        FileUtils.forceMkdir(destFileParent);
                    }
                    if (srcFile.isFile()) {
                        FileUtils.moveFile(srcFile, destFile);
                    } else if (!srcFile.renameTo(destFile)) {
                        throw this.createMLSException("Unable to move file: " + srcFile.getPath() + " to " + destFile.getPath());
                    }
                }
                updatedDestFileInfo.setSize(destFile.length());
            }
            catch (IOException e2) {
                throw this.createMLSException("FileServiceCaching.rename(" + userToken.getName() + ", " + srcMetaDataKey + ", " + destMetaDataKey + ") had an error" + this.stackTraceToString(e2), e2);
            }
            this.fileInfoCache.remove(srcMetaDataKey);
            this.fileInfoCache.put(destMetaDataKey, updatedDestFileInfo);
            srcFileInfo.setDirectory(updatedDestFileInfo.isDirectory());
            this.dirInfoCacheRemoveFile(userToken, srcFileInfo);
            this.dirInfoCacheAddFile(userToken, updatedDestFileInfo);
        }
        catch (MLSException mlse) {
            this.fileInfoCache.remove(this.mapFileInfoToPath(userToken, srcFileInfo));
            this.dirInfoCache.remove(this.mapFileInfoToParentPath(userToken, srcFileInfo));
            throw this.createMLSException("rename(" + userToken.getName() + "," + srcFileInfo.getLocation() + File.separator + srcFileInfo.getName() + ")" + " cause: " + mlse.getCause() + this.stackTraceToString(mlse), mlse);
        }
        catch (Throwable t) {
            logger.severe("Unexpected error occurred, " + t.getMessage() + this.stackTraceToString(t));
        }
        return updatedDestFileInfo;
    }

    @Override
    public synchronized FileInfoDO update(UserTokenDO userToken, FileDO file) throws MLSException {
        FileInfoDO fileInfo = this.remoteFileService.update(userToken, file);
        String metaDataKey = this.mapFileInfoToPath(userToken, fileInfo);
        String cachePath = this.sandbox(metaDataKey);
        this.writeFileOrDirToLocalContentCache(cachePath, file);
        this.fileInfoCache.put(metaDataKey, fileInfo);
        this.dirInfoCacheAddFile(userToken, fileInfo);
        return fileInfo;
    }

    @Override
    public synchronized FileInfoDO updateContent(UserTokenDO userToken, FileInfoDO fileInfo, InputStream contents) throws MLSException {
        String metaDataKey = this.mapFileInfoToPath(userToken, fileInfo);
        String cachePath = this.sandbox(metaDataKey);
        File cacheFile = new File(cachePath);
        FileInfoDO localFileInfo = this.fileInfoCache.get(metaDataKey);
        if (localFileInfo == null || !cacheFile.exists()) {
            throw this.createMLSException("updateContent(" + userToken.getName() + "," + fileInfo.getLocation() + File.separator + fileInfo.getName() + ") called in illegal state, file isn't in the local cache");
        }
        try {
            byte[] data = IOUtils.toByteArray(contents);
            FileUtils.writeByteArrayToFile(cacheFile, data);
            localFileInfo.setModified(new Date());
            localFileInfo.setSize(data.length);
            this.setDirty(localFileInfo);
        }
        catch (IOException e2) {
            this.fileInfoCache.remove(metaDataKey);
            throw this.createMLSException("FileServiceCahcing.updateContent(" + userToken.getName() + ", " + metaDataKey + ") had an error", e2);
        }
        finally {
            IOUtils.closeQuietly(contents);
        }
        return localFileInfo;
    }

    @Override
    public synchronized boolean exists(UserTokenDO userToken, FileInfoDO fileInfo) throws MLSException {
        String metaDataKey = this.mapFileInfoToPath(userToken, fileInfo);
        return this.fileInfoCache.containsKey(metaDataKey) || this.remoteFileService.exists(userToken, fileInfo);
    }

    @Override
    public synchronized void readIncremental(UserTokenDO userToken, FileInfoDO fileInfo, ByteBuffer data, int size, int offset) {
        String metaDataKey = this.mapFileInfoToPath(userToken, fileInfo);
        String cachePath = this.localCacheDir + File.separator + metaDataKey;
        File cacheFile = new File(cachePath);
        FileInfoDO localFileInfo = this.fileInfoCache.get(metaDataKey);
        if (localFileInfo == null || !cacheFile.exists()) {
            FileDO file = this.remoteFileService.read(userToken, fileInfo);
            try {
                if (!cacheFile.exists()) {
                    FileUtils.forceMkdir(cacheFile.getParentFile());
                    FileUtils.touch(cacheFile);
                }
                FileUtils.writeByteArrayToFile(cacheFile, file.getData());
            }
            catch (IOException e2) {
                throw this.createMLSException("readIncremental(" + metaDataKey + ") failed while writing to the local cache. ", e2);
            }
            this.fileInfoCache.put(metaDataKey, file.getFileInfo());
        }
        FileInputStream inStream = null;
        FileChannel fileChannel = null;
        try {
            inStream = FileUtils.openInputStream(cacheFile);
            fileChannel = inStream.getChannel();
            fileChannel.position(offset);
            fileChannel.read(data);
        }
        catch (IOException e3) {
            throw this.createMLSException("readIncremental(" + metaDataKey + ") failed wile opening the input stream. ", e3);
        }
        finally {
            IOUtils.closeQuietly(inStream);
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (IOException e4) {
                    logger.log(Level.WARNING, "Unable to close fileChannel", e4);
                }
            }
        }
    }

    @Override
    public synchronized void updateIncremental(UserTokenDO userToken, FileInfoDO fileInfo, ByteBuffer data, int size, int offset) {
        String metaDataKey = this.mapFileInfoToPath(userToken, fileInfo);
        String cachePath = this.sandbox(metaDataKey);
        File cacheFile = new File(cachePath);
        FileInfoDO localFileInfo = this.fileInfoCache.get(metaDataKey);
        if (localFileInfo == null || !cacheFile.exists()) {
            throw this.createMLSException("updateIncremental(" + userToken.getName() + "," + fileInfo.getLocation() + fileInfo.getName() + ") called in illegal state, file isn't in the local cache");
        }
        RandomAccessFile outFile = null;
        AbstractInterruptibleChannel fileChannel = null;
        try {
            outFile = new RandomAccessFile(cacheFile, "rw");
            outFile.seek(offset);
            fileChannel = outFile.getChannel();
            ((FileChannel)fileChannel).write(data);
            localFileInfo.setModified(new Date());
            localFileInfo.setSize(cacheFile.length());
            this.setDirty(localFileInfo);
        }
        catch (IOException e2) {
            this.fileInfoCache.remove(metaDataKey);
            throw this.createMLSException("FileServiceCaching.updateIncremental(" + userToken.getName() + ", " + metaDataKey + ") had an error", e2);
        }
        finally {
            if (outFile != null) {
                try {
                    outFile.close();
                }
                catch (IOException e3) {
                    logger.log(Level.WARNING, "Unable to close outFile", e3);
                }
            }
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (IOException e4) {
                    logger.log(Level.WARNING, "Unable to close fileChannel", e4);
                }
            }
        }
    }

    private void writeFileOrDirToLocalContentCache(String cachePath, FileDO file) {
        try {
            File cacheFile = new File(cachePath);
            File parent = new File(cacheFile.getParent());
            if (!parent.exists()) {
                FileUtils.forceMkdir(parent);
            }
            if (file.getFileInfo().isDirectory()) {
                if (!cacheFile.mkdir()) {
                    throw this.createMLSException("Mkdir failed for: " + cacheFile.getPath());
                }
            } else {
                FileUtils.writeStringToFile(cacheFile, file.getContent());
            }
        }
        catch (IOException e2) {
            logger.log(Level.SEVERE, "Error in create() for " + cachePath);
            throw this.createMLSException("Error in create() for " + cachePath);
        }
    }

    protected void dirInfoCacheAddFile(UserTokenDO userToken, FileInfoDO fileInfo) {
        String dirEntryMetaDataKey = this.mapFileInfoToParentPath(userToken, fileInfo);
        DirEntry dirEntry = this.dirInfoCache.get(dirEntryMetaDataKey);
        String fileInfoPath = this.mapFileInfoToPath(userToken, fileInfo);
        if (dirEntry == null) {
            FileInfoDO fido = new FileInfoDO(fileInfo.getLocation());
            fido.setDirectory(true);
            try {
                this.list(userToken, fido);
                dirEntry = this.dirInfoCache.get(dirEntryMetaDataKey);
            }
            catch (MLSException e2) {
                // empty catch block
            }
        }
        if (dirEntry != null) {
            ArrayList<String> files = new ArrayList<String>(Arrays.asList(dirEntry.filePaths));
            if (!files.contains(fileInfoPath)) {
                files.add(fileInfoPath);
            }
            dirEntry.filePaths = new String[files.size()];
            dirEntry.filePaths = files.toArray(dirEntry.filePaths);
        } else {
            dirEntry = new DirEntry();
            dirEntry.filePaths = new String[1];
            dirEntry.filePaths[0] = fileInfoPath;
            this.dirInfoCache.put(dirEntryMetaDataKey, dirEntry);
        }
        FileInfoDO dirFileInfo = this.fileInfoCache.get(dirEntryMetaDataKey);
        if (dirFileInfo != null) {
            dirFileInfo.setModified(new Date());
        } else {
            logger.log(Level.WARNING, "dirInfoCacheAddFile found no FileInfo for: " + dirEntryMetaDataKey);
        }
    }

    protected void dirInfoCacheRemoveFile(UserTokenDO userToken, FileInfoDO fileInfo) {
        FileInfoDO dirFileInfo;
        String parentDirEntryMetaDataKey = this.mapFileInfoToParentPath(userToken, fileInfo);
        String dirEntryMetaDataKey = this.mapFileInfoToPath(userToken, fileInfo);
        DirEntry dirEntry = this.dirInfoCache.get(parentDirEntryMetaDataKey);
        if (dirEntry != null) {
            ArrayList<String> files = new ArrayList<String>(Arrays.asList(dirEntry.filePaths));
            if (files.contains(dirEntryMetaDataKey)) {
                files.remove(dirEntryMetaDataKey);
            }
            dirEntry.filePaths = new String[files.size()];
            dirEntry.filePaths = files.toArray(dirEntry.filePaths);
        }
        if ((dirFileInfo = this.fileInfoCache.get(parentDirEntryMetaDataKey)) != null) {
            dirFileInfo.setModified(new Date());
        } else {
            logger.log(Level.WARNING, "dirInfoCacheRemoveFile found no FileInfo for: " + parentDirEntryMetaDataKey);
        }
        if (fileInfo.isDirectory()) {
            for (FileInfoDO file : this.fileInfoCache.values()) {
                if (!file.getLocation().startsWith(this.filenameConverter.getWorkerFilename(userToken, fileInfo))) continue;
                this.fileInfoCache.remove(this.mapFileInfoToPath(userToken, file));
            }
            for (String key : this.dirInfoCache.keySet()) {
                if (!key.contains(dirEntryMetaDataKey)) continue;
                this.dirInfoCache.remove(key);
            }
            String fileCachePath = this.sandbox(dirEntryMetaDataKey);
            File fileCacheFile = new File(fileCachePath);
            if (fileCacheFile.exists()) {
                try {
                    FileUtils.deleteDirectory(fileCacheFile);
                }
                catch (IOException e2) {
                    logger.log(Level.SEVERE, "Error trying to delete cache directory", e2);
                }
            }
        }
    }

    protected boolean isDirty(FileInfoDO fileInfo) {
        boolean isDirty = true;
        String dirtyFlag = fileInfo.getType();
        if (dirtyFlag == null || dirtyFlag.equals(CLEAN)) {
            isDirty = false;
        }
        return isDirty;
    }

    protected void setDirty(FileInfoDO fileInfo) {
        fileInfo.setType(DIRTY);
    }

    protected void clearDirty(FileInfoDO fileInfo) {
        fileInfo.setType(CLEAN);
    }

    protected boolean isConsumedShareData(FileInfoDO fileInfo) {
        boolean retval = false;
        if (this.disableCacheForSharedFolders) {
            ShareAttributesDO shareAttributes = (fileInfo = this.metadataProvider.addMetadata(fileInfo, false)).getShareAttributes();
            if (shareAttributes != null) {
                retval = shareAttributes.isConsumed();
            } else {
                logger.warning("No sharing attributes for " + fileInfo);
            }
        }
        return retval;
    }

    protected String mapFileInfoToPath(UserTokenDO userToken, FileInfoDO fileInfo) {
        return this.filenameConverter.getWorkerFilename(userToken, fileInfo);
    }

    protected String mapFileInfoToParentPath(UserTokenDO userToken, FileInfoDO fileInfo) {
        String filename = this.filenameConverter.getWorkerFilename(userToken, fileInfo);
        return StringUtils.substringBeforeLast(filename, this.filenameConverter.getWorkerFileSeparator());
    }

    private String sandbox(String filePath) {
        String pathToCheck = this.localCacheDir + filePath;
        try {
            String canonicalFilePath = new File(pathToCheck).getCanonicalPath();
            if (!canonicalFilePath.startsWith(this.localCacheDir)) {
                throw this.createMLSException("file operation tried to escape sandbox, sandbox(" + filePath + ")");
            }
        }
        catch (IOException e2) {
            throw this.createMLSException("Error when trying to inforce cache sandbox. sandbox(" + filePath + ")");
        }
        return pathToCheck;
    }

    private FileInfoDO resetFileInfoPath(String path, FileInfoDO fileInfo) {
        String newPath = StringUtils.removeStart(path, this.localCacheDir);
        fileInfo.setName(FilenameUtils.getName(newPath));
        String location = FilenameUtils.getFullPath(newPath);
        location = location.startsWith(this.filenameConverter.getWorkerFileSeparator()) ? location : this.filenameConverter.getWorkerFileSeparator() + location;
        fileInfo.setLocation(location);
        return fileInfo;
    }

    private FileInfoDO convertToFileInfoDO(String path) {
        FileInfoDO retVal = new FileInfoDO();
        this.resetFileInfoPath(path, retVal);
        return retVal;
    }

    private MLSException createMLSException(String message) {
        logger.log(Level.SEVERE, message);
        return new MLSException("FileService.IOError", message);
    }

    private MLSException createMLSException(String message, Throwable t) {
        logger.log(Level.SEVERE, message);
        return new MLSException("FileService.IOError", message, t);
    }

    private void initializeCache() {
        File localCacheFile = new File(this.localCacheDir);
        try {
            FileUtils.deleteDirectory(localCacheFile);
            FileUtils.forceMkdir(localCacheFile);
        }
        catch (Throwable t) {
            throw this.createMLSException("Error initializing local cache: " + this.localCacheDir, t);
        }
    }

    private void dumpCaches(String message) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n\n=================================\n");
        buffer.append(message).append("\n");
        this.dumpDirCache(buffer);
        this.dumpFileInfoCache(buffer);
        this.dumpFileContentCache(buffer);
        logger.info(buffer.toString());
    }

    private void dumpDirCache(StringBuffer buffer) {
        buffer.append("---------------------------------\n");
        buffer.append("dumpDirCache()\n");
        for (String key : this.dirInfoCache.keySet()) {
            buffer.append("  Dir Key: ").append(key).append("\n");
            for (String fileKey : this.dirInfoCache.get((Object)key).filePaths) {
                buffer.append("    fileKey: ").append(fileKey).append("\n");
                FileInfoDO fi = this.fileInfoCache.get(fileKey);
                buffer.append("      fileInfo: ").append(fi).append(fi == null ? " <---- ERROR, this shouldn't be null!\n" : "\n");
            }
        }
        buffer.append("---------------------------------\n");
    }

    private void dumpFileInfoCache(StringBuffer buffer) {
        buffer.append("---------------------------------\n");
        buffer.append("dumpFileInfoCache()\n");
        for (String key : this.fileInfoCache.keySet()) {
            buffer.append("  FileInfo Key: ").append(key).append("\n");
            FileInfoDO fi = this.fileInfoCache.get(key);
            buffer.append("    fileInfo: ").append(fi).append("\n");
        }
        buffer.append("---------------------------------\n");
    }

    private void dumpFileContentCache(StringBuffer buffer) {
        buffer.append("---------------------------------\n");
        buffer.append("dumpFileContentCache()\n");
        Collection<File> files = FileUtils.listFiles(new File(this.localCacheDir), null, true);
        Iterator<File> i$ = files.iterator();
        while (i$.hasNext()) {
            File fileObject;
            File file = fileObject = i$.next();
            buffer.append("  File Path: ").append(file.getAbsolutePath()).append("\n");
            buffer.append("    lastModified: ").append(file.lastModified()).append(", length: ").append(file.length()).append("\n");
        }
        buffer.append("---------------------------------\n");
    }

    private String stackTraceToString(Throwable thrown) {
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            thrown.printStackTrace(printWriter);
            return stringWriter.toString();
        }
        catch (Exception failException) {
            return "stackTraceToStringFailed " + failException.toString();
        }
    }

    @Override
    public String getWorkerMountPoint() {
        return this.remoteFileService.getWorkerMountPoint();
    }

    @Override
    public String getWorkerMountPoint(UserTokenDO userToken) {
        return this.remoteFileService.getWorkerMountPoint(userToken);
    }

    @Override
    public String getServerMountPoint() {
        return this.remoteFileService.getServerMountPoint();
    }

    @Override
    public String getServerMountPoint(UserTokenDO userToken) {
        return this.remoteFileService.getServerMountPoint(userToken);
    }

    protected ConcurrentHashMap<String, DirEntry> getDirInfoCache() {
        return this.dirInfoCache;
    }

    protected ConcurrentHashMap<String, FileInfoDO> getFileInfoCache() {
        return this.fileInfoCache;
    }

    protected static class DirEntry {
        FileInfoDO dirFileInfo;
        String[] filePaths;

        protected DirEntry() {
        }
    }
}

