/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.common.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class InactivityTimer {
    private int maxInactiveSeconds;
    private Runnable inactivityAction;
    private final ScheduledExecutorService scheduler;
    private ScheduledFuture<?> inactivityHandler;

    public InactivityTimer(int maxInactiveSeconds, Runnable inactivityAction) throws IllegalArgumentException {
        if (maxInactiveSeconds <= 0) {
            throw new IllegalArgumentException("maxInactiveSeconds must be greater than 0");
        }
        if (inactivityAction == null) {
            throw new IllegalArgumentException("inactivityAction must not be null");
        }
        this.maxInactiveSeconds = maxInactiveSeconds;
        this.inactivityAction = inactivityAction;
        this.scheduler = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName("inactivity timer");
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    public synchronized void start() throws IllegalStateException {
        this.stop();
        if (this.inactivityAction == null || this.maxInactiveSeconds == 0) {
            throw new IllegalStateException("inactivityAction must be set and maxInactiveSeconds must be > 0");
        }
        this.inactivityHandler = this.scheduler.schedule(this.inactivityAction, (long)this.maxInactiveSeconds, TimeUnit.SECONDS);
    }

    public synchronized void stop() {
        if (this.inactivityHandler != null) {
            this.inactivityHandler.cancel(true);
        }
    }

    public synchronized int getMaxInactiveSeconds() {
        return this.maxInactiveSeconds;
    }

    public synchronized void setMaxInactiveSeconds(int maxInactiveSeconds) {
        this.maxInactiveSeconds = maxInactiveSeconds;
        this.stop();
    }

    public synchronized Runnable getInactivityAction() {
        return this.inactivityAction;
    }

    public synchronized void setInactivityAction(Runnable inactivityAction) {
        this.inactivityAction = inactivityAction;
        this.stop();
    }
}

