/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.common.task;

import com.mathworks.matlabserver.common.task.TaskOutput;
import com.mathworks.matlabserver.common.util.SerializeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

final class TaskUtil {
    private static final Logger sLogger = Logger.getLogger(TaskUtil.class.getName());

    TaskUtil() {
    }

    private static TaskOutput encodedStrToTaskResult(String taskid, String encodedResponse) {
        TaskOutput taskResult = TaskOutput.createNewTaskResult(taskid);
        Object obj = null;
        try {
            obj = SerializeUtil.fromBase64(encodedResponse);
        }
        catch (Exception e2) {
            sLogger.log(Level.SEVERE, "Uncaught exception", e2);
        }
        if (obj instanceof HashMap) {
            Object listobj;
            HashMap map = (HashMap)obj;
            Object evalcobj = map.get("evalcresponse");
            if (evalcobj instanceof String) {
                taskResult.setEvalcOutput(evalcobj.toString());
            }
            if ((listobj = map.get("workspacedata")) instanceof ArrayList) {
                ArrayList list = (ArrayList)listobj;
                taskResult.setWorkspaceList(list);
            }
            Object imageobj = map.get("pngimage");
            taskResult.setImages(TaskUtil.convert(imageobj));
            Object dataobj = map.get("data");
            sLogger.info("data: " + dataobj);
            taskResult.setData(TaskUtil.convert(dataobj));
            Object erroroccurred = map.get("erroroccurred");
            if (erroroccurred instanceof String && erroroccurred.equals("true")) {
                taskResult.setErrorOccurred(true);
            }
        }
        return taskResult;
    }

    static ArrayList<byte[]> convert(Object objlist) {
        ArrayList<byte[]> retlist = new ArrayList<byte[]>();
        if (objlist instanceof ArrayList) {
            ArrayList list = (ArrayList)objlist;
            for (int n2 = 0; n2 < list.size(); ++n2) {
                Object obj = list.get(n2);
                if (!(obj instanceof byte[])) continue;
                retlist.add((byte[])obj);
            }
        }
        return retlist;
    }
}

