/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.common.fileservice;

import com.mathworks.matlabserver.internalservices.file.FileInfoDO;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.io.FilenameUtils;

public class FileUtils {
    private static final Logger logger = Logger.getLogger(FileUtils.class.getName());
    private static final Pattern mFileMatcher = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_]*\\.m$");
    public static final Pattern illegalCharPattern = Pattern.compile("[\\t\\n\\x0B\\f\\r*?:;\"\\<>|&]+");

    public static boolean isValidMFile(String fileName) {
        boolean isValid = !illegalCharPattern.matcher(fileName.substring(FilenameUtils.getPrefixLength(fileName))).find();
        fileName = FilenameUtils.getName(fileName);
        return isValid &= mFileMatcher.matcher(fileName).matches();
    }

    public static boolean isValidFileName(String fileName) {
        if (FilenameUtils.isExtension(fileName, "m")) {
            return FileUtils.isValidMFile(fileName);
        }
        return !illegalCharPattern.matcher(fileName.substring(FilenameUtils.getPrefixLength(fileName))).find();
    }

    public static boolean isTextFile(FileInfoDO fileInfo) {
        boolean returnValue = false;
        String fileName = fileInfo == null || fileInfo.getName() == null ? "badNameNoExtension" : fileInfo.getName();
        String ext = FilenameUtils.getExtension(fileName);
        if (ext != null && (ext.compareToIgnoreCase("txt") == 0 || ext.compareToIgnoreCase("m") == 0 || ext.compareToIgnoreCase("html") == 0 || ext.compareToIgnoreCase("log") == 0 || ext.compareToIgnoreCase("dia") == 0 || ext.compareToIgnoreCase("dlm") == 0 || ext.compareToIgnoreCase("csv") == 0)) {
            returnValue = true;
        }
        return returnValue;
    }

    public static String ufsUriDecode(String input) {
        String retVal = input;
        input = input.replace("+", "%2b");
        try {
            retVal = URIUtil.decode((String)input);
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error in ufsUriDecode: " + input, e2);
        }
        return retVal;
    }
}

