/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.common.config;

import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class ConfigLoader {
    private static final Logger logger = Logger.getLogger(ConfigLoader.class.getName());

    public Properties loadProperties(String defaultFileName, String overrideFileName) {
        String key;
        Enumeration<String> keys;
        Properties properties = new Properties();
        ResourceBundle overrideBundle = null;
        try {
            overrideBundle = PropertyResourceBundle.getBundle(overrideFileName);
            logger.finer("Loaded configuration from " + overrideFileName + ", " + overrideBundle);
        }
        catch (MissingResourceException e2) {
            // empty catch block
        }
        ResourceBundle defaultBundle = PropertyResourceBundle.getBundle(defaultFileName);
        if (defaultBundle != null) {
            keys = defaultBundle.getKeys();
            while (keys.hasMoreElements()) {
                key = keys.nextElement();
                properties.put(key, defaultBundle.getString(key));
            }
        }
        if (overrideBundle != null) {
            keys = overrideBundle.getKeys();
            while (keys.hasMoreElements()) {
                key = keys.nextElement();
                properties.put(key, overrideBundle.getString(key));
            }
        }
        return properties;
    }
}

