/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.common.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class BootstrapConfigUtil {
    private static final Logger logger = Logger.getLogger(BootstrapConfigUtil.class.getName());
    private static final String ADMIN_ID_KEY = "ufr.admin.id";
    private static final String ADMIN_PASSWORD_KEY = "ufr.admin.password";
    private Properties bootstrapProps;
    private static final String SHARING_DOMAIN_CHECK = "ufr.sharing.domainCheck";
    private static final String AUTHORIZATION_ENABLED = "ufr.authorizationEnabled";

    public BootstrapConfigUtil(String bootstrapUrl) throws IOException {
        this.loadBootstrapProperties(bootstrapUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadBootstrapProperties(String bootstrapUrl) throws IOException {
        InputStream bootstrapStream;
        block5: {
            bootstrapStream = null;
            this.bootstrapProps = new Properties();
            try {
                bootstrapStream = this.getClass().getResourceAsStream(bootstrapUrl);
                if (bootstrapStream == null) {
                    logger.info("Unable to find: " + bootstrapUrl + " on the class path, trying as a file.");
                    File bootstrapFile = new File(bootstrapUrl);
                    if (bootstrapFile.exists()) {
                        bootstrapStream = FileUtils.openInputStream(bootstrapFile);
                    }
                }
                if (bootstrapStream != null) {
                    this.bootstrapProps.load(bootstrapStream);
                    break block5;
                }
                logger.severe("unable to find the bootstrap file and load it: " + bootstrapUrl);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bootstrapStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(bootstrapStream);
        return this.bootstrapProps;
    }

    public String loadAdminId(String defaultId) {
        return this.loadValue(ADMIN_ID_KEY, defaultId);
    }

    public String loadAdminPassword(String defaultPassword) {
        return this.loadValue(ADMIN_PASSWORD_KEY, defaultPassword);
    }

    public String loadValue(String key, String defaultValue) {
        if (this.bootstrapProps.containsKey(key)) {
            return this.bootstrapProps.getProperty(key);
        }
        logger.warning("Unable to find the '" + key + "' property in the bootstrap file.");
        return defaultValue;
    }

    public boolean loadDomainCheck(boolean defaultValue) {
        return Boolean.parseBoolean(this.loadValue(SHARING_DOMAIN_CHECK, String.valueOf(defaultValue)));
    }

    public boolean loadAuthorizationEnabled(boolean authorizationEnabled) {
        return Boolean.parseBoolean(this.loadValue(AUTHORIZATION_ENABLED, String.valueOf(authorizationEnabled)));
    }
}

