/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.storage.provider;

import com.mathworks.storage.provider.AbstractComparableFolderListEntry;
import com.mathworks.storage.provider.FileAttributes;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class FileMetadata
extends AbstractComparableFolderListEntry
implements FileAttributes {
    private final String fName;
    private final long fSize;
    private final long fLastModified;
    private final boolean fWritable;
    private final Map<String, Object> fExtras = new HashMap<String, Object>();

    public FileMetadata(String string, long l, Date date, boolean bl) {
        this.fName = string;
        this.fSize = l;
        this.fLastModified = date.getTime();
        this.fWritable = bl;
    }

    public FileMetadata(String string, long l, long l2, boolean bl) {
        this.fName = string;
        this.fSize = l;
        this.fLastModified = l2;
        this.fWritable = bl;
    }

    public FileMetadata withSize(long l) {
        return new FileMetadata(this.fName, l, this.fLastModified, this.fWritable);
    }

    public FileMetadata withSizeAndLastModified(long l, Date date) {
        return new FileMetadata(this.fName, l, date, this.fWritable);
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    @Override
    public long getSize() {
        return this.fSize;
    }

    @Override
    public long getLastModified() {
        return this.fLastModified;
    }

    @Override
    public boolean isWritable() {
        return this.fWritable;
    }

    public void putExtra(String string, Object object) {
        this.fExtras.put(string, object);
    }

    public Object getExtra(String string) {
        return this.fExtras.get(string);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FileMetadata fileMetadata = (FileMetadata)object;
        if (this.fLastModified != fileMetadata.fLastModified) {
            return false;
        }
        if (this.fSize != fileMetadata.fSize) {
            return false;
        }
        if (this.fWritable != fileMetadata.fWritable) {
            return false;
        }
        return this.fName.equals(fileMetadata.fName);
    }

    public int hashCode() {
        int n = this.fName.hashCode();
        n = 31 * n + (int)(this.fSize ^ this.fSize >>> 32);
        n = 31 * n + (int)(this.fLastModified ^ this.fLastModified >>> 32);
        n = 31 * n + (this.fWritable ? 1 : 0);
        return n;
    }

    public String toString() {
        return "FileMetadata{fName='" + this.fName + '\'' + ", fSize=" + this.fSize + ", fLastModified=" + this.fLastModified + ", fWritable=" + this.fWritable + '}';
    }
}

