/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls.attribute.stackmap;

import com.vladium.jcd.cls.attribute.stackmap.StackMapFrame_info;
import com.vladium.jcd.cls.attribute.stackmap.VerificationTypeFactory;
import com.vladium.jcd.lib.UDataInputStream;
import com.vladium.jcd.lib.UDataOutputStream;
import com.vladium.util.CollectionUtils;
import java.io.IOException;
import java.util.List;

public class AppendFrame
extends StackMapFrame_info {
    public AppendFrame(int frame_type, UDataInputStream bytes) throws IOException {
        this.setFrameType(frame_type);
        this.setOffsetDelta(bytes.readU2());
        for (int i = 0; i < this.getFrameType() - 251; ++i) {
            this.getLocal().add(VerificationTypeFactory.getVerificationType(bytes));
        }
    }

    public AppendFrame(int frame_type, int offset_delta, List v_locals) {
        this.setFrameType(frame_type);
        this.setOffsetDelta(offset_delta);
        if (!CollectionUtils.isEmpty(v_locals)) {
            this.getLocal().addAll(v_locals);
        }
    }

    public void writeInClassFormat(UDataOutputStream out) throws IOException {
        super.writeInClassFormat(out);
        out.writeU2(this.getOffsetDelta());
        this.verificationTypeWriting(this.getLocal(), out);
    }

    public int getLength() {
        return 3 + AppendFrame.computeVerificationTypeLength(this.getLocal());
    }

    public String toString() {
        return "frame_type = " + this.getFrameType() + "/* append_frame */";
    }
}

