/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls.attribute;

import com.vladium.jcd.cls.attribute.Attribute_info;
import com.vladium.jcd.cls.attribute.IAttributeVisitor;
import com.vladium.jcd.cls.attribute.stackmap.StackMapFrameFactory;
import com.vladium.jcd.cls.attribute.stackmap.StackMapFrame_info;
import com.vladium.jcd.lib.UDataInputStream;
import com.vladium.jcd.lib.UDataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

public class StackMapTableAttribute_info
extends Attribute_info {
    private LinkedList m_frames = new LinkedList();

    public LinkedList getFrames() {
        return this.m_frames;
    }

    public void setFrames(LinkedList m_frames) {
        this.m_frames = m_frames;
    }

    public StackMapTableAttribute_info(int attribute_name_index, long attribute_length, UDataInputStream bytes) throws IOException {
        super(attribute_name_index, attribute_length);
        int entries_count = bytes.readU2();
        for (int i = 0; i < entries_count; ++i) {
            int frameType = bytes.readU1();
            this.getFrames().add(StackMapFrameFactory.getStackMapFrame(frameType, bytes));
        }
    }

    public StackMapTableAttribute_info(int attribute_name_index) {
        super(attribute_name_index, 0L);
    }

    public StackMapFrame_info get(int offset) {
        return (StackMapFrame_info)this.getFrames().get(offset);
    }

    public int size() {
        return this.getFrames().size();
    }

    public long length() {
        return 8 + this.computeAttributeLength();
    }

    public void accept(IAttributeVisitor visitor, Object ctx) {
        visitor.visit(this, ctx);
    }

    public String toString() {
        StringBuffer s = new StringBuffer("StackMapTableAttribute_info: [attribute_name_index = " + this.m_name_index + ", attribute_length = " + this.length() + "]\n");
        for (int l = 0; l < this.size(); ++l) {
            s.append("            " + StackMapFrameFactory.downcastStackMapFrame(this.get(l)));
            s.append("\n");
        }
        return s.toString();
    }

    public void writeInClassFormat(UDataOutputStream out) throws IOException {
        super.writeInClassFormat(out);
        int frames_count = this.getFrames().size();
        out.writeU2(frames_count);
        Iterator iterator = this.getFrames().iterator();
        while (iterator.hasNext()) {
            StackMapFrame_info stackMapFrame_info = StackMapFrameFactory.downcastStackMapFrame((StackMapFrame_info)iterator.next());
            stackMapFrame_info.writeInClassFormat(out);
        }
    }

    private int computeAttributeLength() {
        int length = 0;
        Iterator iterator = this.getFrames().iterator();
        while (iterator.hasNext()) {
            StackMapFrame_info stackMapFrame_info = StackMapFrameFactory.downcastStackMapFrame((StackMapFrame_info)iterator.next());
            length += stackMapFrame_info.getLength();
        }
        return length;
    }
}

