/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.ctl;

import com.vladium.emma.Command;
import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.ctl.ControlRequest;
import com.vladium.emma.ctl.CtlProcessor;
import com.vladium.util.ClassLoaderResolver;
import com.vladium.util.IConstants;
import com.vladium.util.args.IOptsParser;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class ctlCommand
extends Command {
    private String m_connectionString;
    private ControlRequest[] m_commands;

    public ctlCommand(String usageToolName, String[] args) {
        super(usageToolName, args);
    }

    public synchronized void run() {
        ClassLoader loader;
        try {
            loader = ClassLoaderResolver.getClassLoader();
        }
        catch (Throwable t) {
            loader = this.getClass().getClassLoader();
        }
        try {
            IOptsParser parser = this.getOptParser(loader);
            IOptsParser.IOpts parsedopts = parser.parse(this.m_args);
            int usageRequestLevel = parsedopts.usageRequestLevel();
            if (usageRequestLevel > 0) {
                this.usageexit(null, parser, usageRequestLevel);
                return;
            }
            IOptsParser.IOpt[] opts = parsedopts.getOpts();
            if (opts == null) {
                parsedopts.error(this.m_out, 80);
                this.usageexit(null, parser, 1);
                return;
            }
            if (parsedopts.hasArg("v")) {
                this.usageexit(null, null, usageRequestLevel);
                return;
            }
            for (int o = 0; o < opts.length; ++o) {
                IOptsParser.IOpt opt = opts[o];
                String on = opt.getCanonicalName();
                if (this.processOpt(opt)) continue;
                if ("c".equals(on)) {
                    String[] commands = opt.getValues();
                    this.m_commands = new ControlRequest[commands.length];
                    for (int c = 0; c < commands.length; ++c) {
                        String[] args;
                        String[] _command = ctlCommand.tokenize(commands[c], ",", true);
                        if (_command.length > 1) {
                            args = new String[_command.length - 1];
                            System.arraycopy(_command, 1, args, 0, args.length);
                        } else {
                            args = IConstants.EMPTY_STRING_ARRAY;
                        }
                        this.m_commands[c] = ControlRequest.create(_command[0], args);
                    }
                    continue;
                }
                if (!"a".equals(on)) continue;
                this.m_connectionString = opt.getFirstValue();
            }
            this.processCmdPropertyOverrides(parsedopts);
            if (!this.processFilePropertyOverrides()) {
                return;
            }
            CtlProcessor processor = CtlProcessor.create();
            processor.setAppName("EMMA");
            processor.setConnectionString(this.m_connectionString);
            processor.setCommandSequence(this.m_commands);
            processor.setPropertyOverrides(this.m_propertyOverrides);
            processor.run();
        }
        catch (EMMARuntimeException yre) {
            this.exit(true, yre.getMessage(), yre, 2);
            return;
        }
        catch (Throwable t) {
            this.exit(true, "unexpected failure: ", t, 2);
            return;
        }
        this.exit(false, null, null, 0);
    }

    public static String[] tokenize(String s, String delimiters, boolean trim) {
        StringTokenizer tokenizer = new StringTokenizer(s, delimiters, true);
        ArrayList<String> _result = new ArrayList<String>(tokenizer.countTokens());
        boolean delimiter = true;
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String t = tokenizer.nextToken();
            if (t.length() == 1 && delimiters.indexOf(t.charAt(0)) >= 0) {
                if (delimiter) {
                    _result.add(null);
                } else {
                    delimiter = true;
                }
            } else {
                delimiter = false;
                _result.add(trim ? t.trim() : t);
            }
            ++i;
        }
        String[] result = new String[_result.size()];
        _result.toArray(result);
        return result;
    }

    protected String usageArgsMsg() {
        return "[options]";
    }
}

