/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;

public class FormatSupport {
    private FormatWriter formatWriter;

    public FormatSupport(FormatWriter formatWriter) {
        this.formatWriter = formatWriter;
    }

    public FormatWriter getFormatWriter() {
        return this.formatWriter;
    }

    public int getTabSize() {
        Document document = this.formatWriter.getDocument();
        return document instanceof BaseDocument ? ((BaseDocument)document).getTabSize() : this.formatWriter.getFormatter().getTabSize();
    }

    public int getShiftWidth() {
        Document document = this.formatWriter.getDocument();
        return document instanceof BaseDocument ? ((BaseDocument)document).getShiftWidth() : this.formatWriter.getFormatter().getShiftWidth();
    }

    public boolean expandTabs() {
        return this.formatWriter.getFormatter().expandTabs();
    }

    public int getSpacesPerTab() {
        return this.formatWriter.getFormatter().getSpacesPerTab();
    }

    public Object getSettingValue(String string) {
        return this.formatWriter.getFormatter().getSettingValue(string);
    }

    public Object getSettingValue(String string, Object object) {
        Object object2 = this.getSettingValue(string);
        return object2 != null ? object2 : object;
    }

    public boolean getSettingBoolean(String string, Boolean bl) {
        return (Boolean)this.getSettingValue(string, bl);
    }

    public boolean getSettingBoolean(String string, boolean bl) {
        return (Boolean)this.getSettingValue(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public int getSettingInteger(String string, Integer n) {
        return (Integer)this.getSettingValue(string, n);
    }

    public int getSettingInteger(String string, int n) {
        Object object = this.getSettingValue(string);
        return object instanceof Integer ? (Integer)object : n;
    }

    public final boolean isIndentOnly() {
        return this.formatWriter.isIndentOnly();
    }

    public FormatTokenPosition getFormatStartPosition() {
        return this.formatWriter.getFormatStartPosition();
    }

    public FormatTokenPosition getTextStartPosition() {
        return this.formatWriter.getTextStartPosition();
    }

    public TokenItem findFirstToken(TokenItem tokenItem) {
        return this.formatWriter.findFirstToken(tokenItem);
    }

    public TokenItem getLastToken() {
        return this.formatWriter.getLastToken();
    }

    public FormatTokenPosition getLastPosition() {
        TokenItem tokenItem = this.findNonEmptyToken(this.getLastToken(), true);
        return tokenItem == null ? null : this.getPosition(tokenItem, tokenItem.getImage().length() - 1);
    }

    public boolean canInsertToken(TokenItem tokenItem) {
        return this.formatWriter.canInsertToken(tokenItem);
    }

    public TokenItem insertToken(TokenItem tokenItem, TokenID tokenID, TokenContextPath tokenContextPath, String string) {
        return this.formatWriter.insertToken(tokenItem, tokenID, tokenContextPath, string);
    }

    public void insertSpaces(TokenItem tokenItem, int n) {
        TokenID tokenID = this.getWhitespaceTokenID();
        if (tokenID == null) {
            throw new IllegalStateException("Valid whitespace token-id required.");
        }
        this.insertToken(tokenItem, tokenID, null, new String(Analyzer.getSpacesBuffer(n), 0, n));
    }

    public boolean canRemoveToken(TokenItem tokenItem) {
        return this.formatWriter.canRemoveToken(tokenItem);
    }

    public void removeToken(TokenItem tokenItem) {
        this.formatWriter.removeToken(tokenItem);
    }

    public void removeTokenChain(TokenItem tokenItem, TokenItem tokenItem2) {
        while (tokenItem != null && tokenItem != tokenItem2) {
            TokenItem tokenItem3 = tokenItem.getNext();
            this.removeToken(tokenItem);
            tokenItem = tokenItem3;
        }
    }

    public TokenItem splitStart(TokenItem tokenItem, int n, TokenID tokenID, TokenContextPath tokenContextPath) {
        return this.formatWriter.splitStart(tokenItem, n, tokenID, tokenContextPath);
    }

    public TokenItem splitEnd(TokenItem tokenItem, int n, TokenID tokenID, TokenContextPath tokenContextPath) {
        return this.formatWriter.splitEnd(tokenItem, n, tokenID, tokenContextPath);
    }

    public void insertString(TokenItem tokenItem, int n, String string) {
        this.formatWriter.insertString(tokenItem, n, string);
    }

    public void insertString(FormatTokenPosition formatTokenPosition, String string) {
        TokenItem tokenItem = formatTokenPosition.getToken();
        int n = formatTokenPosition.getOffset();
        if (tokenItem == null) {
            tokenItem = this.getLastToken();
            if (tokenItem == null) {
                throw new IllegalStateException("Cannot insert string. No tokens.");
            }
            n = tokenItem.getImage().length();
        }
        this.insertString(tokenItem, n, string);
    }

    public void remove(TokenItem tokenItem, int n, int n2) {
        this.formatWriter.remove(tokenItem, n, n2);
    }

    public void remove(FormatTokenPosition formatTokenPosition, int n) {
        this.remove(formatTokenPosition.getToken(), formatTokenPosition.getOffset(), n);
    }

    public TokenItem findNonEmptyToken(TokenItem tokenItem, boolean bl) {
        return this.formatWriter.findNonEmptyToken(tokenItem, bl);
    }

    public FormatTokenPosition getPosition(TokenItem tokenItem, int n) {
        return this.getPosition(tokenItem, n, Position.Bias.Forward);
    }

    public FormatTokenPosition getPosition(TokenItem tokenItem, int n, Position.Bias bias) {
        return this.formatWriter.getPosition(tokenItem, n, bias);
    }

    public FormatTokenPosition getNextPosition(TokenItem tokenItem, int n, Position.Bias bias) {
        if (tokenItem == null) {
            return null;
        }
        if (++n >= tokenItem.getImage().length()) {
            tokenItem = tokenItem.getNext();
            n = 0;
        }
        return this.getPosition(tokenItem, n, bias);
    }

    public FormatTokenPosition getPreviousPosition(TokenItem tokenItem, int n, Position.Bias bias) {
        FormatTokenPosition formatTokenPosition = null;
        if (tokenItem == null) {
            TokenItem tokenItem2 = this.findNonEmptyToken(this.getLastToken(), true);
            if (tokenItem2 != null) {
                formatTokenPosition = this.getPosition(tokenItem2, tokenItem2.getImage().length() - 1, Position.Bias.Forward);
            }
        } else if (--n < 0) {
            if ((tokenItem = tokenItem.getPrevious()) != null) {
                formatTokenPosition = this.getPosition(tokenItem, tokenItem.getImage().length() - 1, Position.Bias.Forward);
            }
        } else {
            formatTokenPosition = this.getPosition(tokenItem, n, Position.Bias.Forward);
        }
        return formatTokenPosition;
    }

    public FormatTokenPosition getPreviousPosition(FormatTokenPosition formatTokenPosition) {
        return this.getPreviousPosition(formatTokenPosition.getToken(), formatTokenPosition.getOffset(), formatTokenPosition.getBias());
    }

    public FormatTokenPosition getPreviousPosition(FormatTokenPosition formatTokenPosition, Position.Bias bias) {
        return this.getPreviousPosition(formatTokenPosition.getToken(), formatTokenPosition.getOffset(), bias);
    }

    public FormatTokenPosition getPreviousPosition(TokenItem tokenItem, int n) {
        return this.getPreviousPosition(tokenItem, n, Position.Bias.Forward);
    }

    public FormatTokenPosition getNextPosition(FormatTokenPosition formatTokenPosition) {
        return this.getNextPosition(formatTokenPosition.getToken(), formatTokenPosition.getOffset(), formatTokenPosition.getBias());
    }

    public FormatTokenPosition getNextPosition(FormatTokenPosition formatTokenPosition, Position.Bias bias) {
        return this.getNextPosition(formatTokenPosition.getToken(), formatTokenPosition.getOffset(), bias);
    }

    public FormatTokenPosition getNextPosition(TokenItem tokenItem, int n) {
        return this.getNextPosition(tokenItem, n, Position.Bias.Forward);
    }

    public boolean isAfter(TokenItem tokenItem, TokenItem tokenItem2) {
        return this.formatWriter.isAfter(tokenItem, tokenItem2);
    }

    public boolean isAfter(FormatTokenPosition formatTokenPosition, FormatTokenPosition formatTokenPosition2) {
        return this.formatWriter.isAfter(formatTokenPosition, formatTokenPosition2);
    }

    public boolean isChainStartPosition(FormatTokenPosition formatTokenPosition) {
        return this.formatWriter.isChainStartPosition(formatTokenPosition);
    }

    public boolean canReplaceToken(TokenItem tokenItem) {
        return this.canRemoveToken(tokenItem);
    }

    public void replaceToken(TokenItem tokenItem, TokenID tokenID, TokenContextPath tokenContextPath, String string) {
        if (!this.canReplaceToken(tokenItem)) {
            throw new IllegalStateException("Cannot insert token into chain");
        }
        TokenItem tokenItem2 = tokenItem.getNext();
        this.removeToken(tokenItem);
        this.insertToken(tokenItem2, tokenID, tokenContextPath, string);
    }

    public boolean isRestartFormat() {
        return this.formatWriter.isRestartFormat();
    }

    public void setRestartFormat(boolean bl) {
        this.formatWriter.setRestartFormat(bl);
    }

    public int getIndentShift() {
        return this.formatWriter.getIndentShift();
    }

    public void setIndentShift(int n) {
        this.formatWriter.setIndentShift(n);
    }

    public boolean tokenEquals(TokenItem tokenItem, TokenID tokenID) {
        return FormatSupport.tokenEquals(tokenItem, tokenID, null, null);
    }

    public static boolean tokenEquals(TokenItem tokenItem, TokenID tokenID, TokenContextPath tokenContextPath) {
        return FormatSupport.tokenEquals(tokenItem, tokenID, tokenContextPath, null);
    }

    public static boolean tokenEquals(TokenItem tokenItem, TokenID tokenID, TokenContextPath tokenContextPath, String string) {
        return !(tokenID != null && tokenItem.getTokenID() != tokenID || tokenContextPath != null && tokenItem.getTokenContextPath() != tokenContextPath || string != null && !tokenItem.getImage().equals(string));
    }

    public boolean isWhitespace(TokenItem tokenItem, int n) {
        return Character.isWhitespace(tokenItem.getImage().charAt(n));
    }

    public boolean isWhitespace(FormatTokenPosition formatTokenPosition) {
        return this.isWhitespace(formatTokenPosition.getToken(), formatTokenPosition.getOffset());
    }

    public FormatTokenPosition findLineStart(FormatTokenPosition formatTokenPosition) {
        if (this.isChainStartPosition(formatTokenPosition)) {
            return formatTokenPosition;
        }
        formatTokenPosition = this.getPreviousPosition(formatTokenPosition);
        TokenItem tokenItem = formatTokenPosition.getToken();
        int n = formatTokenPosition.getOffset();
        while (true) {
            String string = tokenItem.getImage();
            while (n >= 0) {
                if (string.charAt(n) == '\n') {
                    return this.getNextPosition(tokenItem, n);
                }
                --n;
            }
            if (tokenItem.getPrevious() == null) {
                return this.getPosition(tokenItem, 0);
            }
            tokenItem = tokenItem.getPrevious();
            n = tokenItem.getImage().length() - 1;
        }
    }

    public FormatTokenPosition findLineEnd(FormatTokenPosition formatTokenPosition) {
        TokenItem tokenItem = formatTokenPosition.getToken();
        int n = formatTokenPosition.getOffset();
        if (tokenItem == null) {
            return formatTokenPosition;
        }
        while (true) {
            String string = tokenItem.getImage();
            int n2 = string.length();
            while (n < n2) {
                if (string.charAt(n) == '\n') {
                    return this.getPosition(tokenItem, n);
                }
                ++n;
            }
            if (tokenItem.getNext() == null) {
                return this.getPosition(null, 0);
            }
            tokenItem = tokenItem.getNext();
            n = 0;
        }
    }

    public FormatTokenPosition findLineFirstNonWhitespace(FormatTokenPosition formatTokenPosition) {
        formatTokenPosition = this.findLineStart(formatTokenPosition);
        TokenItem tokenItem = formatTokenPosition.getToken();
        int n = formatTokenPosition.getOffset();
        if (tokenItem == null) {
            return null;
        }
        while (true) {
            String string = tokenItem.getImage();
            int n2 = string.length();
            while (n < n2) {
                if (string.charAt(n) == '\n') {
                    return null;
                }
                if (!this.isWhitespace(tokenItem, n)) {
                    return this.getPosition(tokenItem, n);
                }
                ++n;
            }
            if (tokenItem.getNext() == null) {
                return null;
            }
            tokenItem = tokenItem.getNext();
            n = 0;
        }
    }

    public FormatTokenPosition findLineEndWhitespace(FormatTokenPosition formatTokenPosition) {
        if (this.isChainStartPosition(formatTokenPosition = this.findLineEnd(formatTokenPosition))) {
            return formatTokenPosition;
        }
        formatTokenPosition = this.getPreviousPosition(formatTokenPosition);
        TokenItem tokenItem = formatTokenPosition.getToken();
        int n = formatTokenPosition.getOffset();
        while (true) {
            String string = tokenItem.getImage();
            int n2 = string.length();
            while (n >= 0) {
                if (!(n >= n2 || string.charAt(n) != '\n' && this.isWhitespace(tokenItem, n))) {
                    return this.getNextPosition(tokenItem, n);
                }
                --n;
            }
            if (tokenItem.getPrevious() == null) {
                return this.getPosition(tokenItem, 0);
            }
            tokenItem = tokenItem.getPrevious();
            n = tokenItem.getImage().length() - 1;
        }
    }

    public FormatTokenPosition findPreviousEOL(FormatTokenPosition formatTokenPosition) {
        if ((formatTokenPosition = this.getPreviousPosition(formatTokenPosition)) == null) {
            return null;
        }
        TokenItem tokenItem = formatTokenPosition.getToken();
        int n = formatTokenPosition.getOffset();
        while (true) {
            String string = tokenItem.getImage();
            while (n >= 0) {
                if (string.charAt(n) == '\n') {
                    return this.getPosition(tokenItem, n);
                }
                --n;
            }
            if (tokenItem.getPrevious() == null) {
                return null;
            }
            tokenItem = tokenItem.getPrevious();
            n = tokenItem.getImage().length() - 1;
        }
    }

    public FormatTokenPosition findNextEOL(FormatTokenPosition formatTokenPosition) {
        if ((formatTokenPosition = this.getNextPosition(formatTokenPosition)) == null) {
            return null;
        }
        TokenItem tokenItem = formatTokenPosition.getToken();
        int n = formatTokenPosition.getOffset();
        if (tokenItem == null) {
            return null;
        }
        while (true) {
            String string = tokenItem.getImage();
            int n2 = string.length();
            while (n < n2) {
                if (string.charAt(n) == '\n') {
                    return this.getPosition(tokenItem, n);
                }
                ++n;
            }
            if (tokenItem.getNext() == null) {
                return null;
            }
            tokenItem = tokenItem.getNext();
            n = 0;
        }
    }

    public boolean isLineEmpty(FormatTokenPosition formatTokenPosition) {
        return this.findLineStart(formatTokenPosition).equals(this.findLineEnd(formatTokenPosition));
    }

    public boolean isLineWhite(FormatTokenPosition formatTokenPosition) {
        FormatTokenPosition formatTokenPosition2 = this.findLineStart(formatTokenPosition);
        return this.findLineEndWhitespace(formatTokenPosition).equals(formatTokenPosition2);
    }

    public int getVisualColumnOffset(FormatTokenPosition formatTokenPosition) {
        TokenItem tokenItem = formatTokenPosition.getToken();
        int n = formatTokenPosition.getOffset();
        FormatTokenPosition formatTokenPosition2 = this.findLineStart(formatTokenPosition);
        int n2 = formatTokenPosition2.getOffset();
        int n3 = 0;
        int n4 = this.formatWriter.getFormatter().getTabSize();
        for (TokenItem tokenItem2 = formatTokenPosition2.getToken(); tokenItem2 != null; tokenItem2 = tokenItem2.getNext()) {
            String string = tokenItem2.getImage();
            int n5 = string.length();
            while (n2 < n5) {
                if (tokenItem2 == tokenItem && n2 == n) {
                    return n3;
                }
                switch (string.charAt(n2)) {
                    case '\t': {
                        n3 = (n3 + n4) / n4 * n4;
                        break;
                    }
                    default: {
                        ++n3;
                    }
                }
                ++n2;
            }
            n2 = 0;
        }
        return n3;
    }

    public FormatTokenPosition findNonWhitespace(FormatTokenPosition formatTokenPosition, FormatTokenPosition formatTokenPosition2, boolean bl, boolean bl2) {
        int n;
        TokenItem tokenItem;
        if (formatTokenPosition.equals(formatTokenPosition2)) {
            return null;
        }
        if (bl2) {
            int n2;
            TokenItem tokenItem2;
            if (formatTokenPosition2 == null) {
                tokenItem2 = null;
                n2 = 0;
            } else if ((formatTokenPosition2 = this.getPreviousPosition(formatTokenPosition2)) == null) {
                tokenItem2 = null;
                n2 = 0;
            } else {
                tokenItem2 = formatTokenPosition2.getToken();
                n2 = formatTokenPosition2.getOffset();
            }
            formatTokenPosition = this.getPreviousPosition(formatTokenPosition);
            if (formatTokenPosition == null) {
                return null;
            }
            TokenItem tokenItem3 = formatTokenPosition.getToken();
            int n3 = formatTokenPosition.getOffset();
            while (true) {
                String string = tokenItem3.getImage();
                while (n3 >= 0) {
                    if (bl && string.charAt(n3) == '\n') {
                        return null;
                    }
                    if (!this.isWhitespace(tokenItem3, n3)) {
                        return this.getPosition(tokenItem3, n3);
                    }
                    if (tokenItem3 == tokenItem2 && n3 == n2) {
                        return null;
                    }
                    --n3;
                }
                if ((tokenItem3 = tokenItem3.getPrevious()) == null) {
                    return null;
                }
                n3 = tokenItem3.getImage().length() - 1;
            }
        }
        if (formatTokenPosition2 == null) {
            tokenItem = null;
            n = 0;
        } else {
            tokenItem = formatTokenPosition2.getToken();
            n = formatTokenPosition2.getOffset();
        }
        TokenItem tokenItem4 = formatTokenPosition.getToken();
        int n4 = formatTokenPosition.getOffset();
        while (true) {
            String string = tokenItem4.getImage();
            int n5 = string.length();
            while (n4 < n5) {
                if (tokenItem4 == tokenItem && n4 == n) {
                    return null;
                }
                if (bl && string.charAt(n4) == '\n') {
                    return null;
                }
                if (!this.isWhitespace(tokenItem4, n4)) {
                    return this.getPosition(tokenItem4, n4);
                }
                ++n4;
            }
            if ((tokenItem4 = tokenItem4.getNext()) == null) {
                return null;
            }
            n4 = 0;
        }
    }

    public TokenItem getPreviousToken(TokenItem tokenItem) {
        return tokenItem == null ? this.getLastToken() : tokenItem.getPrevious();
    }

    public TokenID getWhitespaceTokenID() {
        return null;
    }

    public TokenID getValidWhitespaceTokenID() {
        TokenID tokenID = this.getWhitespaceTokenID();
        if (tokenID == null) {
            throw new IllegalStateException("Null whitespace token-id");
        }
        return tokenID;
    }

    public TokenContextPath getWhitespaceTokenContextPath() {
        return null;
    }

    public TokenContextPath getValidWhitespaceTokenContextPath() {
        TokenContextPath tokenContextPath = this.getWhitespaceTokenContextPath();
        if (tokenContextPath == null) {
            throw new IllegalStateException("Null whitespace token-context-path");
        }
        return tokenContextPath;
    }

    public boolean canModifyWhitespace(TokenItem tokenItem) {
        return false;
    }

    public String getIndentString(int n) {
        return this.formatWriter.getFormatter().getIndentString(n);
    }

    public int getLineIndent(FormatTokenPosition formatTokenPosition, boolean bl) {
        FormatTokenPosition formatTokenPosition2 = this.findLineFirstNonWhitespace(formatTokenPosition);
        if (formatTokenPosition2 == null) {
            if (bl) {
                return 0;
            }
            formatTokenPosition2 = this.findLineEnd(formatTokenPosition);
        }
        return this.getVisualColumnOffset(formatTokenPosition2);
    }

    public FormatTokenPosition changeLineIndent(FormatTokenPosition formatTokenPosition, int n) {
        int n2;
        String string;
        formatTokenPosition = this.findLineStart(formatTokenPosition);
        String string2 = this.getIndentString(n);
        int n3 = string2.length();
        int n4 = 0;
        TokenItem tokenItem = formatTokenPosition.getToken();
        int n5 = formatTokenPosition.getOffset();
        if (tokenItem == null) {
            if (string2.length() > 0) {
                tokenItem = this.insertToken(null, this.getValidWhitespaceTokenID(), this.getValidWhitespaceTokenContextPath(), string2);
            }
            return formatTokenPosition;
        }
        while (true) {
            string = tokenItem.getImage();
            n2 = string.length();
            while (n4 < n3 && n5 < n2) {
                if (string2.charAt(n4) != string.charAt(n5)) {
                    if (this.canModifyWhitespace(tokenItem)) {
                        this.insertString(tokenItem, n5, string2.substring(n4));
                        n5 += n3 - n4;
                        n4 = n3;
                        continue;
                    }
                    if (this.isWhitespace(tokenItem, n5) || n5 > 0) {
                        throw new IllegalStateException("Cannot modify token=" + tokenItem);
                    }
                    this.insertToken(tokenItem, this.getValidWhitespaceTokenID(), this.getValidWhitespaceTokenContextPath(), string2.substring(n4));
                    return this.getPosition(tokenItem, 0);
                }
                ++n4;
                ++n5;
            }
            if (n4 >= n3) break;
            if ((tokenItem = tokenItem.getNext()) == null) {
                tokenItem = this.insertToken(null, this.getValidWhitespaceTokenID(), this.getValidWhitespaceTokenContextPath(), string2.substring(n4));
                return this.getPosition(tokenItem, 0);
            }
            n5 = 0;
        }
        do {
            string = tokenItem.getImage();
            n2 = string.length();
            int n6 = -1;
            while (n5 < n2) {
                if (!this.isWhitespace(tokenItem, n5) || string.charAt(n5) == '\n') {
                    if (n6 >= 0) {
                        this.remove(tokenItem, n6, n5 - n6);
                        n5 = n6;
                    }
                    return this.getPosition(tokenItem, n5);
                }
                if (n6 < 0) {
                    n6 = n5;
                }
                ++n5;
            }
            if (n6 == -1) {
                tokenItem = tokenItem.getNext();
            } else if (n6 == 0) {
                TokenItem tokenItem2 = tokenItem.getNext();
                this.removeToken(tokenItem);
                tokenItem = tokenItem2;
            } else {
                this.remove(tokenItem, n6, n2 - n6);
                tokenItem = tokenItem.getNext();
            }
            n5 = 0;
        } while (tokenItem != null);
        return this.getPosition(null, 0);
    }

    public String chainToString(TokenItem tokenItem) {
        return this.formatWriter.chainToString(tokenItem);
    }

    public String chainToString(TokenItem tokenItem, int n) {
        return this.formatWriter.chainToString(tokenItem, n);
    }
}

