/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.beans.PropertyChangeListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakPropertyChangeSupport;

public class JumpList {
    private static final String SUPPORTS_JUMP_CLIENT_PROPERTY = "supportsJumpList";
    private static final int MAX_SIZE = 50;
    private static final int CHECK_COUNT = 10;
    private static Entry currentEntry;
    private static int checkCnt;
    private static final WeakPropertyChangeSupport support;
    private static boolean dotAtCurrentEntry;
    private static ChangeListener registryListener;

    static void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        support.addPropertyChangeListener(propertyChangeListener);
    }

    static void dotMoved(JTextComponent jTextComponent, int n) {
        if (dotAtCurrentEntry && currentEntry != null && (currentEntry.getComponent() != jTextComponent || currentEntry.getPosition() != n)) {
            support.firePropertyChange(JumpList.class, null, null, null);
            dotAtCurrentEntry = false;
        } else {
            boolean bl = dotAtCurrentEntry = currentEntry != null && currentEntry.getComponent() == jTextComponent && currentEntry.getPosition() == n;
            if (dotAtCurrentEntry) {
                support.firePropertyChange(JumpList.class, null, null, null);
            }
        }
    }

    public static void checkAddEntry() {
        JTextComponent jTextComponent = Utilities.getLastActiveComponent();
        if (jTextComponent != null) {
            JumpList.checkAddEntry(jTextComponent, jTextComponent.getCaret().getDot());
        }
    }

    public static void removeEntries(JTextComponent jTextComponent) {
        if (currentEntry != null) {
            Entry entry = currentEntry;
            if (entry != null) {
                while (entry.prev != null) {
                    entry = entry.prev;
                }
                while (entry != null) {
                    if (jTextComponent == entry.getComponent()) {
                        if (entry.prev != null) {
                            entry.prev.next = entry.next;
                            if (entry == currentEntry) {
                                currentEntry = entry.prev;
                            }
                        }
                        if (entry.next != null) {
                            entry.next.prev = entry.prev;
                        }
                        if (entry == currentEntry) {
                            currentEntry = entry.next;
                        }
                    }
                    entry = entry.next;
                }
            }
            support.firePropertyChange(JumpList.class, null, null, null);
        }
    }

    private static Entry getCurrentEntry() {
        return currentEntry;
    }

    private static void clearAllEntries() {
        currentEntry = null;
    }

    public static void checkAddEntry(JTextComponent jTextComponent) {
        JumpList.checkAddEntry(jTextComponent, jTextComponent.getCaret().getDot());
    }

    public static void checkAddEntry(JTextComponent jTextComponent, int n) {
        if ((currentEntry == null || currentEntry.getComponent() != jTextComponent || currentEntry.getPosition() != n) && JumpList.isJumpNavigationSupported(jTextComponent)) {
            JumpList.addEntry(jTextComponent, n);
        }
    }

    public static void addJumpNavigationSupport(JTextComponent jTextComponent) {
        jTextComponent.putClientProperty(SUPPORTS_JUMP_CLIENT_PROPERTY, Boolean.TRUE);
    }

    public static boolean isJumpNavigationSupported(JTextComponent jTextComponent) {
        Boolean bl = (Boolean)jTextComponent.getClientProperty(SUPPORTS_JUMP_CLIENT_PROPERTY);
        return bl != null && bl != false;
    }

    public static void addEntry(JTextComponent jTextComponent, int n) {
        try {
            Entry entry;
            currentEntry = entry = new Entry(jTextComponent, n, currentEntry);
            if (++checkCnt >= 10) {
                JumpList.sizeCheck();
            }
            dotAtCurrentEntry = true;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public static void jumpPrev(JTextComponent jTextComponent) {
        int n = jTextComponent.getCaret().getDot();
        if (currentEntry != null) {
            while (true) {
                int n2 = currentEntry.getPosition();
                JTextComponent jTextComponent2 = currentEntry.getComponent();
                if (jTextComponent2 != null && (jTextComponent2 != jTextComponent || n2 >= 0 && n2 != n) && currentEntry.setDot()) {
                    support.firePropertyChange(JumpList.class, null, null, null);
                    break;
                }
                if (JumpList.currentEntry.prev == null) break;
                currentEntry = JumpList.currentEntry.prev;
            }
        }
    }

    public static boolean hasPrev() {
        JTextComponent jTextComponent = Utilities.getLastActiveComponent();
        if (jTextComponent != null) {
            int n = jTextComponent.getCaret().getDot();
            Entry entry = currentEntry;
            if (entry != null) {
                while (true) {
                    int n2 = entry.getPosition();
                    JTextComponent jTextComponent2 = entry.getComponent();
                    if (jTextComponent2 != null && (jTextComponent2 != jTextComponent || n2 >= 0 && n2 != n) && n2 >= 0 && n2 <= jTextComponent2.getDocument().getLength()) {
                        return true;
                    }
                    if (entry.prev == null) break;
                    entry = entry.prev;
                }
            }
        }
        return false;
    }

    public static void jumpNext(JTextComponent jTextComponent) {
        int n = jTextComponent.getCaret().getDot();
        if (currentEntry != null) {
            currentEntry = JumpList.currentEntry.next;
        }
        if (currentEntry != null) {
            while (true) {
                int n2 = currentEntry.getPosition();
                JTextComponent jTextComponent2 = currentEntry.getComponent();
                if (jTextComponent2 != null && (jTextComponent2 != jTextComponent || n2 >= 0 && n2 != n) && currentEntry.setDot()) {
                    support.firePropertyChange(JumpList.class, null, null, null);
                    break;
                }
                if (JumpList.currentEntry.next == null) break;
                currentEntry = JumpList.currentEntry.next;
            }
        }
    }

    public static boolean hasNext() {
        JTextComponent jTextComponent = Utilities.getLastActiveComponent();
        if (jTextComponent != null) {
            Entry entry;
            int n = jTextComponent.getCaret().getDot();
            Entry entry2 = entry = currentEntry != null ? JumpList.currentEntry.next : currentEntry;
            if (entry != null) {
                while (true) {
                    int n2 = entry.getPosition();
                    JTextComponent jTextComponent2 = entry.getComponent();
                    if (jTextComponent2 != null && (jTextComponent2 != jTextComponent || n2 >= 0 && n2 != n) && n2 >= 0 && n2 <= jTextComponent2.getDocument().getLength()) {
                        return true;
                    }
                    if (entry.next == null) break;
                    entry = entry.next;
                }
            }
        }
        return false;
    }

    public static void jumpPrevComponent(JTextComponent jTextComponent) {
        if (currentEntry != null) {
            JTextComponent jTextComponent2;
            while (!((jTextComponent2 = currentEntry.getComponent()) != null && jTextComponent2 != jTextComponent && currentEntry.setDot() || JumpList.currentEntry.prev == null)) {
                currentEntry = JumpList.currentEntry.prev;
            }
        }
    }

    public static void jumpNextComponent(JTextComponent jTextComponent) {
        if (currentEntry != null) {
            JTextComponent jTextComponent2;
            while (!((jTextComponent2 = currentEntry.getComponent()) != null && jTextComponent2 != jTextComponent && currentEntry.setDot() || JumpList.currentEntry.next == null)) {
                currentEntry = JumpList.currentEntry.next;
            }
        }
    }

    public static String dump() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Entry entry = currentEntry;
        if (entry != null) {
            while (entry.prev != null) {
                entry = entry.prev;
                --n;
            }
            while (entry != null) {
                String string;
                JTextComponent jTextComponent = entry.getComponent();
                String string2 = string = jTextComponent != null ? (String)jTextComponent.getDocument().getProperty("title") : "<Invalid document>";
                if (string == null) {
                    string = "Untitled";
                }
                stringBuffer.append("[" + n++ + "]=" + string + ", " + entry.getPosition() + "\n");
                entry = entry.next;
            }
        } else {
            stringBuffer.append("Empty list");
        }
        return stringBuffer.toString();
    }

    private static void sizeCheck() {
        Entry entry = currentEntry;
        for (int i = 50; entry != null && i > 0; --i) {
            entry = entry.prev;
        }
        if (entry != null) {
            entry.makeFirst();
        }
    }

    static {
        support = new WeakPropertyChangeSupport();
        dotAtCurrentEntry = false;
        registryListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                support.firePropertyChange(JumpList.class, null, null, null);
            }
        };
        Registry.addChangeListener(registryListener);
    }

    public static class Entry {
        private int componentID;
        private int posID;
        Entry prev;
        Entry next;

        Entry(JTextComponent jTextComponent, int n, Entry entry) throws BadLocationException {
            this.componentID = Registry.getID(jTextComponent);
            this.posID = ((BaseDocument)jTextComponent.getDocument()).storePosition(n);
            if (entry != null) {
                entry.next = this;
                this.prev = entry;
            }
        }

        public int getPosition() {
            JTextComponent jTextComponent = Registry.getComponent(this.componentID);
            int n = -1;
            if (jTextComponent != null) {
                n = ((BaseDocument)jTextComponent.getDocument()).getStoredPosition(this.posID);
            }
            return n;
        }

        public JTextComponent getComponent() {
            return Registry.getComponent(this.componentID);
        }

        public boolean setDot() {
            JTextComponent jTextComponent = this.getComponent();
            if (jTextComponent != null) {
                int n;
                if (Utilities.getLastActiveComponent() != jTextComponent) {
                    Utilities.requestFocus(jTextComponent);
                    Registry.activate(jTextComponent);
                }
                if ((n = this.getPosition()) >= 0 && n <= jTextComponent.getDocument().getLength()) {
                    jTextComponent.getCaret().setDot(n);
                    return true;
                }
            }
            return false;
        }

        void makeLast() {
            if (this.next != null) {
                this.next.prev = null;
                this.next = null;
            }
        }

        void makeFirst() {
            if (this.prev != null) {
                this.prev.next = null;
                this.prev = null;
            }
        }

        protected void finalize() throws Throwable {
            JTextComponent jTextComponent = Registry.getComponent(this.componentID);
            if (jTextComponent != null) {
                ((BaseDocument)jTextComponent.getDocument()).removeStoredPosition(this.posID);
            }
            super.finalize();
        }
    }
}

