/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.openide.ErrorManager;

public class DocumentFinder {
    private static FalseBlocksFinder falseBlocksFinder;
    private static FalseFinder falseFinder;
    private static WholeWordsBlocksFinder wholeWordsBlocksFinder;
    private static RegExpBlocksFinder regExpBlocksFinder;
    private static StringBlocksFinder stringBlocksFinder;
    private static WholeWordsBwdFinder wholeWordsBwdFinder;
    private static WholeWordsFwdFinder wholeWordsFwdFinder;
    private static RegExpBwdFinder regExpBwdFinder;
    private static RegExpFwdFinder regExpFwdFinder;
    private static StringBwdFinder stringBwdFinder;
    private static StringFwdFinder stringFwdFinder;

    private DocumentFinder() {
    }

    /*
     * Unable to fully structure code
     */
    private static DocFinder getFinder(BaseDocument var0, Map var1_1, boolean var2_2, boolean var3_3) {
        var4_4 = (String)var1_1.get("find-what");
        if (var4_4 == null || var4_4.length() == 0) {
            if (var3_3) {
                if (DocumentFinder.falseBlocksFinder == null) {
                    DocumentFinder.falseBlocksFinder = new FalseBlocksFinder();
                }
                return DocumentFinder.falseBlocksFinder;
            }
            if (DocumentFinder.falseFinder == null) {
                DocumentFinder.falseFinder = new FalseFinder();
            }
            return DocumentFinder.falseFinder;
        }
        var5_5 = (Boolean)var1_1.get("find-backward-search");
        v0 = var6_6 = var5_5 != null && var5_5 != false;
        if (var2_2) {
            var6_6 = var6_6 == false;
        }
        var7_7 = (var5_5 = (Boolean)var1_1.get("find-match-case")) != null && var5_5 != false;
        var5_5 = (Boolean)var1_1.get("find-smart-case");
        var8_8 = var5_5 != null && var5_5 != false;
        var5_5 = (Boolean)var1_1.get("find-whole-words");
        v1 = var9_9 = var5_5 != null && var5_5 != false;
        if (var8_8 && !var7_7) {
            var10_10 = var4_4.length();
            for (var11_11 = 0; var11_11 < var10_10; ++var11_11) {
                if (!Character.isUpperCase(var4_4.charAt(var11_11))) continue;
                var7_7 = true;
            }
        }
        var10_10 = (var5_5 = (Boolean)var1_1.get("find-reg-exp")) != null && var5_5 != false ? 1 : 0;
        var11_12 = null;
        if (var10_10 != 0) {
            try {
                var11_12 = PatternCache.getPattern(var4_4, var7_7);
                if (var11_12 != null) ** GOTO lbl40
                var11_12 = var7_7 != false ? Pattern.compile(var4_4, 8) : Pattern.compile(var4_4, 10);
                PatternCache.putPattern(var4_4, var7_7, var11_12);
            }
            catch (PatternSyntaxException var12_13) {
                if (!var3_3) {
                    ErrorManager.getDefault().notify((Throwable)var12_13);
                }
                PatternCache.putPattern(var4_4, var7_7, null);
                return null;
            }
        } else {
            PatternCache.clear();
        }
lbl40:
        // 3 sources

        if (var3_3) {
            if (var9_9 && var10_10 == 0) {
                if (DocumentFinder.wholeWordsBlocksFinder == null) {
                    DocumentFinder.wholeWordsBlocksFinder = new WholeWordsBlocksFinder();
                }
                DocumentFinder.wholeWordsBlocksFinder.setParams(var0, var4_4, var7_7);
                return DocumentFinder.wholeWordsBlocksFinder;
            }
            if (var10_10 != 0) {
                if (DocumentFinder.regExpBlocksFinder == null) {
                    DocumentFinder.regExpBlocksFinder = new RegExpBlocksFinder();
                }
                DocumentFinder.regExpBlocksFinder.setParams(var11_12, var7_7);
                return DocumentFinder.regExpBlocksFinder;
            }
            if (DocumentFinder.stringBlocksFinder == null) {
                DocumentFinder.stringBlocksFinder = new StringBlocksFinder();
            }
            DocumentFinder.stringBlocksFinder.setParams(var4_4, var7_7);
            return DocumentFinder.stringBlocksFinder;
        }
        if (var9_9 && var10_10 == 0) {
            if (var6_6) {
                if (DocumentFinder.wholeWordsBwdFinder == null) {
                    DocumentFinder.wholeWordsBwdFinder = new WholeWordsBwdFinder();
                }
                DocumentFinder.wholeWordsBwdFinder.setParams(var0, var4_4, var7_7);
                return DocumentFinder.wholeWordsBwdFinder;
            }
            if (DocumentFinder.wholeWordsFwdFinder == null) {
                DocumentFinder.wholeWordsFwdFinder = new WholeWordsFwdFinder();
            }
            DocumentFinder.wholeWordsFwdFinder.setParams(var0, var4_4, var7_7);
            return DocumentFinder.wholeWordsFwdFinder;
        }
        if (var10_10 != 0) {
            if (var6_6) {
                if (DocumentFinder.regExpBwdFinder == null) {
                    DocumentFinder.regExpBwdFinder = new RegExpBwdFinder();
                }
                DocumentFinder.regExpBwdFinder.setParams(var11_12, var7_7);
                return DocumentFinder.regExpBwdFinder;
            }
            if (DocumentFinder.regExpFwdFinder == null) {
                DocumentFinder.regExpFwdFinder = new RegExpFwdFinder();
            }
            DocumentFinder.regExpFwdFinder.setParams(var11_12, var7_7);
            return DocumentFinder.regExpFwdFinder;
        }
        if (var6_6) {
            if (DocumentFinder.stringBwdFinder == null) {
                DocumentFinder.stringBwdFinder = new StringBwdFinder();
            }
            DocumentFinder.stringBwdFinder.setParams(var4_4, var7_7);
            return DocumentFinder.stringBwdFinder;
        }
        if (DocumentFinder.stringFwdFinder == null) {
            DocumentFinder.stringFwdFinder = new StringFwdFinder();
        }
        DocumentFinder.stringFwdFinder.setParams(var4_4, var7_7);
        return DocumentFinder.stringFwdFinder;
    }

    private static FindReplaceResult findReplaceImpl(String string, BaseDocument baseDocument, int n, int n2, Map map, boolean bl) throws BadLocationException {
        Matcher matcher;
        DocFinder docFinder;
        int[] nArray = new int[2];
        if (n2 == -1) {
            n2 = baseDocument.getLength();
        }
        if (n > n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        if ((docFinder = DocumentFinder.getFinder(baseDocument, map, bl, false)) == null) {
            return null;
        }
        docFinder.reset();
        String string2 = baseDocument.getText(n, n2 - n);
        if (string2 == null) {
            return null;
        }
        int n4 = docFinder.find(n, string2);
        if (!docFinder.isFound()) {
            nArray[0] = -1;
            return new FindReplaceResult(nArray, string);
        }
        nArray[0] = n + n4;
        if (docFinder instanceof StringFinder) {
            int n5 = ((StringFinder)docFinder).getFoundLength();
            nArray[1] = nArray[0] + n5;
        }
        if (docFinder instanceof RegExpFinder && (matcher = ((RegExpFinder)docFinder).getMatcher()) != null && string != null) {
            CharSequence charSequence = string2.subSequence(nArray[0] - n, nArray[1] - n);
            matcher.reset(charSequence);
            if (matcher.find()) {
                try {
                    string = matcher.replaceFirst(string);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    ErrorManager.getDefault().notify((Throwable)indexOutOfBoundsException);
                    return null;
                }
            }
        }
        return new FindReplaceResult(nArray, string);
    }

    public static int[] find(BaseDocument baseDocument, int n, int n2, Map map, boolean bl) throws BadLocationException {
        FindReplaceResult findReplaceResult = DocumentFinder.findReplaceImpl(null, baseDocument, n, n2, map, bl);
        if (findReplaceResult == null) {
            return null;
        }
        return findReplaceResult.getFoundPositions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] findBlocks(BaseDocument baseDocument, int n, int n2, Map map, int[] nArray) throws BadLocationException {
        BlocksFinder blocksFinder = (BlocksFinder)DocumentFinder.getFinder(baseDocument, map, false, true);
        if (blocksFinder == null) {
            return nArray;
        }
        String string = baseDocument.getText(n, n2 - n);
        if (string == null) {
            return null;
        }
        BlocksFinder blocksFinder2 = blocksFinder;
        synchronized (blocksFinder2) {
            blocksFinder.reset();
            blocksFinder.setBlocks(nArray);
            blocksFinder.find(n, string);
            int[] nArray2 = blocksFinder.getBlocks();
            return nArray2;
        }
    }

    public static FindReplaceResult findReplaceResult(String string, BaseDocument baseDocument, int n, int n2, Map map, boolean bl) throws BadLocationException {
        return DocumentFinder.findReplaceImpl(string, baseDocument, n, n2, map, bl);
    }

    public static class FindReplaceResult {
        private int[] positions;
        private String replacedString;

        public FindReplaceResult(int[] nArray, String string) {
            this.positions = nArray;
            this.replacedString = string;
        }

        public String getReplacedString() {
            return this.replacedString;
        }

        public int[] getFoundPositions() {
            return this.positions;
        }
    }

    private static class PatternCache {
        private static String cache_str;
        private static boolean cache_matchCase;
        private static Pattern cache_pattern;

        private PatternCache() {
        }

        public static void putPattern(String string, boolean bl, Pattern pattern) {
            cache_str = string;
            cache_matchCase = bl;
            cache_pattern = pattern;
        }

        public static Pattern getPattern(String string, boolean bl) {
            if (string == null) {
                return null;
            }
            if (string.equals(cache_str) && bl == cache_matchCase) {
                return cache_pattern;
            }
            return null;
        }

        public static void clear() {
            cache_str = null;
            cache_matchCase = false;
            cache_pattern = null;
        }
    }

    private static final class RegExpBlocksFinder
    extends AbstractBlocksFinder {
        Pattern pattern;
        int stringInd;
        boolean matchCase;

        public void setParams(Pattern pattern, boolean bl) {
            this.pattern = pattern;
            this.matchCase = bl;
        }

        @Override
        public void reset() {
            super.reset();
            this.stringInd = 0;
        }

        @Override
        public int find(int n, CharSequence charSequence) {
            Matcher matcher = this.pattern.matcher(charSequence);
            int n2 = 0;
            while (matcher.find()) {
                int n3 = n + matcher.start();
                int n4 = n + matcher.end();
                this.addBlock(n3, n4);
                n2 = n3;
            }
            return n2;
        }
    }

    private static final class RegExpFwdFinder
    extends RegExpFinder {
        Pattern pattern;
        boolean matchCase;
        int length = 0;
        Matcher matcher;

        @Override
        public Matcher getMatcher() {
            return this.matcher;
        }

        public void setParams(Pattern pattern, boolean bl) {
            this.matchCase = bl;
            this.pattern = pattern;
        }

        @Override
        public int getFoundLength() {
            return this.length;
        }

        @Override
        public void reset() {
            super.reset();
            this.length = 0;
        }

        @Override
        public int find(int n, CharSequence charSequence) {
            this.matcher = this.pattern.matcher(charSequence);
            if (this.matcher.find()) {
                this.found = true;
                int n2 = this.matcher.start();
                int n3 = this.matcher.end();
                this.length = n3 - n2;
                if (this.length <= 0) {
                    this.found = false;
                    return -1;
                }
                return n2;
            }
            return -1;
        }
    }

    private static class RegExpBwdFinder
    extends RegExpFinder {
        boolean matchCase;
        Pattern pattern;
        int length = 0;
        Matcher matcher;

        @Override
        public Matcher getMatcher() {
            return this.matcher;
        }

        public void setParams(Pattern pattern, boolean bl) {
            this.matchCase = bl;
            this.pattern = pattern;
        }

        @Override
        public int getFoundLength() {
            return this.length;
        }

        @Override
        public void reset() {
            super.reset();
            this.length = 0;
        }

        private int lineFind(int n, int n2, CharSequence charSequence) {
            this.matcher = this.pattern.matcher(charSequence.subSequence(n, n2));
            int n3 = -1;
            while (this.matcher.find()) {
                int n4 = this.matcher.start();
                int n5 = this.matcher.end();
                this.length = n5 - n4;
                if (this.length <= 0) {
                    this.found = false;
                    return -1;
                }
                n3 = n4;
            }
            return n3;
        }

        @Override
        public int find(int n, CharSequence charSequence) {
            int n2;
            int n3 = n2 = charSequence.length() - 1;
            int n4 = n2;
            for (int i = n2; i >= 0; --i) {
                char c = charSequence.charAt(i);
                if (c == '\n' || i == 0) {
                    int n5 = this.lineFind(n4 + (i == 0 ? 0 : 1), n3 + 1, charSequence);
                    if (n5 != -1) {
                        this.found = true;
                        return i + n5 + (i == 0 ? 0 : 1);
                    }
                    n3 = --n4;
                    continue;
                }
                --n4;
            }
            return -1;
        }
    }

    private static abstract class RegExpFinder
    extends AbstractFinder
    implements StringFinder {
        private RegExpFinder() {
        }

        public abstract Matcher getMatcher();
    }

    private static final class StringFwdFinder
    extends GenericFwdFinder
    implements StringFinder {
        char[] chars;
        int stringInd;
        boolean matchCase;

        public void setParams(String string, boolean bl) {
            this.matchCase = bl;
            this.chars = (bl ? string : string.toLowerCase()).toCharArray();
        }

        @Override
        public int getFoundLength() {
            return this.chars.length;
        }

        @Override
        public void reset() {
            super.reset();
            this.stringInd = 0;
        }

        @Override
        protected int scan(char c, boolean bl) {
            if (!this.matchCase) {
                c = Character.toLowerCase(c);
            }
            if (c == this.chars[this.stringInd]) {
                ++this.stringInd;
                if (this.stringInd == this.chars.length) {
                    this.found = true;
                    return 1 - this.stringInd;
                }
                return 1;
            }
            if (this.stringInd == 0) {
                return 1;
            }
            int n = 1 - this.stringInd;
            this.stringInd = 0;
            return n;
        }
    }

    private static class StringBwdFinder
    extends GenericBwdFinder
    implements StringFinder {
        char[] chars;
        int stringInd;
        boolean matchCase;
        int endInd;

        public void setParams(String string, boolean bl) {
            this.matchCase = bl;
            this.chars = (bl ? string : string.toLowerCase()).toCharArray();
            this.endInd = this.chars.length - 1;
        }

        @Override
        public int getFoundLength() {
            return this.chars.length;
        }

        @Override
        public void reset() {
            super.reset();
            this.stringInd = this.endInd;
        }

        @Override
        protected int scan(char c, boolean bl) {
            if (!this.matchCase) {
                c = Character.toLowerCase(c);
            }
            if (c == this.chars[this.stringInd]) {
                --this.stringInd;
                if (this.stringInd == -1) {
                    this.found = true;
                    return 0;
                }
                return -1;
            }
            if (this.stringInd == this.endInd) {
                return -1;
            }
            int n = this.chars.length - 2 - this.stringInd;
            this.stringInd = this.endInd;
            return n;
        }
    }

    private static final class WholeWordsFwdFinder
    extends GenericFwdFinder
    implements StringFinder {
        char[] chars;
        int stringInd;
        boolean matchCase;
        BaseDocument doc;
        boolean insideWord;
        boolean firstCharWordPart;
        boolean wordFound;

        public void setParams(BaseDocument baseDocument, String string, boolean bl) {
            this.doc = baseDocument;
            this.matchCase = bl;
            this.chars = (bl ? string : string.toLowerCase()).toCharArray();
            this.firstCharWordPart = baseDocument.isIdentifierPart(this.chars[0]);
        }

        @Override
        public int getFoundLength() {
            return this.chars.length;
        }

        @Override
        public void reset() {
            super.reset();
            this.insideWord = false;
            this.wordFound = false;
            this.stringInd = 0;
        }

        @Override
        protected int scan(char c, boolean bl) {
            if (!this.matchCase) {
                c = Character.toLowerCase(c);
            }
            if (this.wordFound) {
                if (this.doc.isIdentifierPart(c)) {
                    this.wordFound = false;
                    this.insideWord = this.firstCharWordPart;
                    this.stringInd = 0;
                    return 1 - this.chars.length;
                }
                this.found = true;
                return -this.chars.length;
            }
            if (this.stringInd == 0) {
                if (c != this.chars[0] || this.insideWord) {
                    this.insideWord = this.doc.isIdentifierPart(c);
                    return 1;
                }
                this.stringInd = 1;
                if (this.chars.length == 1) {
                    if (bl) {
                        this.found = true;
                        return 0;
                    }
                    this.wordFound = true;
                    return 1;
                }
                return 1;
            }
            if (c == this.chars[this.stringInd]) {
                ++this.stringInd;
                if (this.stringInd == this.chars.length) {
                    if (bl) {
                        this.found = true;
                        return 1 - this.chars.length;
                    }
                    this.wordFound = true;
                    return 1;
                }
                return 1;
            }
            int n = 1 - this.stringInd;
            this.stringInd = 0;
            this.insideWord = this.firstCharWordPart;
            return n;
        }
    }

    private static abstract class GenericBwdFinder
    extends AbstractFinder {
        private GenericBwdFinder() {
        }

        @Override
        public final int find(int n, CharSequence charSequence) {
            int n2;
            boolean bl = false;
            int n3 = charSequence.length();
            for (n2 = charSequence.length() - 1; n2 >= 0 && n2 < n3; n2 += this.scan(charSequence.charAt(n2), n2 == n3)) {
                if (!this.found) continue;
                break;
            }
            return n2;
        }

        protected abstract int scan(char var1, boolean var2);
    }

    private static abstract class GenericFwdFinder
    extends AbstractFinder {
        private GenericFwdFinder() {
        }

        @Override
        public final int find(int n, CharSequence charSequence) {
            int n2;
            int n3 = charSequence.length();
            int n4 = n3 - 1;
            for (n2 = 0; n2 >= 0 && n2 < n3; n2 += this.scan(charSequence.charAt(n2), n2 == n4)) {
                if (!this.found) continue;
                break;
            }
            return n2;
        }

        protected abstract int scan(char var1, boolean var2);
    }

    private static final class WholeWordsBwdFinder
    extends GenericBwdFinder
    implements StringFinder {
        char[] chars;
        int stringInd;
        boolean matchCase;
        boolean insideWord;
        boolean lastCharWordPart;
        boolean wordFound;
        int endInd;
        BaseDocument doc;

        public void setParams(BaseDocument baseDocument, String string, boolean bl) {
            this.doc = baseDocument;
            this.matchCase = bl;
            this.chars = (bl ? string : string.toLowerCase()).toCharArray();
            this.endInd = this.chars.length - 1;
            baseDocument.isIdentifierPart(this.chars[this.endInd]);
        }

        @Override
        public int getFoundLength() {
            return this.chars.length;
        }

        @Override
        public void reset() {
            super.reset();
            this.insideWord = false;
            this.wordFound = false;
            this.stringInd = this.endInd;
        }

        @Override
        protected int scan(char c, boolean bl) {
            if (!this.matchCase) {
                c = Character.toLowerCase(c);
            }
            if (this.wordFound) {
                if (this.doc.isIdentifierPart(c)) {
                    this.wordFound = false;
                    this.insideWord = this.lastCharWordPart;
                    this.stringInd = this.endInd;
                    return this.endInd;
                }
                this.found = true;
                return 1;
            }
            if (this.stringInd == this.endInd) {
                if (c != this.chars[this.endInd] || this.insideWord) {
                    this.insideWord = this.doc.isIdentifierPart(c);
                    return -1;
                }
                this.stringInd = this.endInd - 1;
                if (this.chars.length == 1) {
                    if (bl) {
                        this.found = true;
                        return 0;
                    }
                    this.wordFound = true;
                    return -1;
                }
                return -1;
            }
            if (c == this.chars[this.stringInd]) {
                --this.stringInd;
                if (this.stringInd == -1) {
                    if (bl) {
                        this.found = true;
                        return 0;
                    }
                    this.wordFound = true;
                    return -1;
                }
                return -1;
            }
            int n = this.chars.length - 2 - this.stringInd;
            this.stringInd = this.endInd;
            this.insideWord = this.lastCharWordPart;
            return n;
        }
    }

    private static final class StringBlocksFinder
    extends AbstractBlocksFinder {
        char[] chars;
        int stringInd;
        boolean matchCase;

        public void setParams(String string, boolean bl) {
            this.matchCase = bl;
            this.chars = (bl ? string : string.toLowerCase()).toCharArray();
        }

        @Override
        public void reset() {
            super.reset();
            this.stringInd = 0;
        }

        @Override
        public int find(int n, CharSequence charSequence) {
            int n2 = 0;
            int n3 = charSequence.length();
            while (n2 >= 0 && n2 < n3) {
                char c = charSequence.charAt(n2);
                if (!this.matchCase) {
                    c = Character.toLowerCase(c);
                }
                if (c == this.chars[this.stringInd]) {
                    ++this.stringInd;
                    if (this.stringInd == this.chars.length) {
                        int n4 = n + n2 + 1;
                        this.addBlock(n4 - this.stringInd, n4);
                        this.stringInd = 0;
                    }
                    ++n2;
                    continue;
                }
                n2 += 1 - this.stringInd;
                this.stringInd = 0;
            }
            return n2;
        }
    }

    private static final class WholeWordsBlocksFinder
    extends AbstractBlocksFinder {
        char[] chars;
        int stringInd;
        boolean matchCase;
        boolean insideWord;
        boolean firstCharWordPart;
        boolean wordFound;
        BaseDocument doc;

        public void setParams(BaseDocument baseDocument, String string, boolean bl) {
            this.matchCase = bl;
            this.doc = baseDocument;
            this.chars = (bl ? string : string.toLowerCase()).toCharArray();
            this.firstCharWordPart = baseDocument.isIdentifierPart(this.chars[0]);
        }

        @Override
        public void reset() {
            super.reset();
            this.insideWord = false;
            this.wordFound = false;
            this.stringInd = 0;
        }

        @Override
        public int find(int n, CharSequence charSequence) {
            int n2 = 0;
            int n3 = charSequence.length();
            int n4 = n3 - 1;
            while (n2 >= 0 && n2 < n3) {
                int n5;
                char c = charSequence.charAt(n2);
                if (!this.matchCase) {
                    c = Character.toLowerCase(c);
                }
                if (this.wordFound) {
                    if (this.doc.isIdentifierPart(c)) {
                        this.insideWord = this.firstCharWordPart;
                        n2 -= this.chars.length - 1;
                    } else {
                        n5 = n + n2;
                        this.addBlock(n5 - this.chars.length, n5);
                        this.insideWord = false;
                        ++n2;
                    }
                    this.wordFound = false;
                    this.stringInd = 0;
                    continue;
                }
                if (this.stringInd == 0) {
                    if (c != this.chars[0] || this.insideWord) {
                        this.insideWord = this.doc.isIdentifierPart(c);
                        ++n2;
                        continue;
                    }
                    this.stringInd = 1;
                    if (this.chars.length == 1) {
                        if (n2 == n4) {
                            n5 = n + n2;
                            this.addBlock(n5, n5 + 1);
                        } else {
                            this.wordFound = true;
                        }
                    }
                    ++n2;
                    continue;
                }
                if (c == this.chars[this.stringInd]) {
                    ++this.stringInd;
                    if (this.stringInd == this.chars.length) {
                        if (n2 == n4) {
                            n5 = n + 1;
                            this.addBlock(n5 - this.stringInd, n5);
                        } else {
                            this.wordFound = true;
                        }
                    }
                    ++n2;
                    continue;
                }
                n2 += 1 - this.stringInd;
                this.stringInd = 0;
                this.insideWord = this.firstCharWordPart;
            }
            return n2;
        }
    }

    private static interface StringFinder
    extends DocFinder {
        public int getFoundLength();
    }

    private static abstract class AbstractFinder
    implements DocFinder {
        protected boolean found;

        private AbstractFinder() {
        }

        @Override
        public final boolean isFound() {
            return this.found;
        }

        @Override
        public void reset() {
            this.found = false;
        }
    }

    private static interface BlocksFinder
    extends DocFinder {
        public void setBlocks(int[] var1);

        public int[] getBlocks();
    }

    private static abstract class AbstractBlocksFinder
    extends AbstractFinder
    implements BlocksFinder {
        private static int[] EMPTY_INT_ARRAY = new int[0];
        private int[] blocks = EMPTY_INT_ARRAY;
        private int blocksInd;
        private boolean closed;

        private AbstractBlocksFinder() {
        }

        @Override
        public void reset() {
            this.blocksInd = 0;
            this.closed = false;
        }

        @Override
        public int[] getBlocks() {
            if (!this.closed) {
                this.closeBlocks();
                this.closed = true;
            }
            return this.blocks;
        }

        @Override
        public void setBlocks(int[] nArray) {
            this.blocks = nArray;
            this.closed = false;
        }

        protected void addBlock(int n, int n2) {
            if (this.blocksInd == this.blocks.length) {
                int[] nArray = new int[this.blocks.length * 2];
                System.arraycopy(this.blocks, 0, nArray, 0, this.blocks.length);
                this.blocks = nArray;
            }
            this.blocks[this.blocksInd++] = n;
            this.blocks[this.blocksInd++] = n2;
        }

        protected void closeBlocks() {
            this.addBlock(-1, -1);
        }

        public String debugBlocks() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (this.blocks[n] != -1) {
                stringBuffer.append(n / 2 + 1 + ": [" + this.blocks[n] + ", " + this.blocks[n + 1] + "]\n");
                n += 2;
            }
            return stringBuffer.toString();
        }
    }

    private static class FalseFinder
    extends AbstractFinder
    implements StringFinder {
        private FalseFinder() {
        }

        @Override
        public int find(int n, CharSequence charSequence) {
            return -1;
        }

        @Override
        public int getFoundLength() {
            return 0;
        }
    }

    private static final class FalseBlocksFinder
    extends AbstractBlocksFinder {
        private FalseBlocksFinder() {
        }

        @Override
        public int find(int n, CharSequence charSequence) {
            return -1;
        }
    }

    private static interface DocFinder {
        public int find(int var1, CharSequence var2);

        public boolean isFound();

        public void reset();
    }
}

