/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.tmswing.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class Node
implements TreeNode {
    private String fName;
    private List<Node> fChildren = new ArrayList<Node>();
    private final Node fParent;
    private boolean fCanContainChildren = false;

    public Node(String string, Node node) {
        this(string, node, false);
    }

    public Node(String string, Node node, boolean bl) {
        this.fParent = node;
        this.fCanContainChildren = bl;
        this.setName(string);
    }

    @Override
    public TreeNode getParent() {
        return this.fParent;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this.fChildren.indexOf(treeNode);
    }

    @Override
    public boolean getAllowsChildren() {
        return this.fCanContainChildren;
    }

    @Override
    public boolean isLeaf() {
        return this.fChildren.isEmpty();
    }

    public Enumeration children() {
        return Collections.enumeration(this.fChildren);
    }

    @Override
    public int getChildCount() {
        return this.fChildren.size();
    }

    @Override
    public Node getChildAt(int n) {
        return this.fChildren.get(n);
    }

    public void insertChildAt(int n, Node node) {
        if (n == this.getChildCount()) {
            this.fChildren.add(node);
        } else {
            this.fChildren.add(n, node);
        }
    }

    public void appendChild(Node node) {
        this.fChildren.add(node);
    }

    public void removeChild(Node node) {
        this.fChildren.remove(node);
    }

    public void removeAllChildren() {
        this.fChildren.clear();
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String string) {
        this.fName = string;
    }

    public boolean isCanContainChildren() {
        return this.fCanContainChildren;
    }

    public Node getChildAt(String[] stringArray) {
        assert (stringArray != null && stringArray.length > 0) : "path must be non-null and non-empty";
        String string = stringArray[0];
        for (Node node : this.fChildren) {
            if (!node.getName().equals(string)) continue;
            if (stringArray.length == 1) {
                return node;
            }
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
            return node.getChildAt(stringArray2);
        }
        return null;
    }

    public TreePath getTreePath(String[] stringArray) {
        assert (stringArray != null && stringArray.length > 0) : "path must be non-null and non-empty";
        Node node = this.getChildAt(stringArray);
        assert (node != null) : "No child node at path";
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.add(node);
        while (node.getParent() != null) {
            arrayList.add(0, (Node)node.getParent());
            node = (Node)node.getParent();
        }
        return new TreePath(arrayList.toArray(new Node[arrayList.size()]));
    }

    public String toString() {
        return this.fName;
    }
}

