/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.propertyeditor;

import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.toolbox.testmeas.propertyeditor.Constraint;
import com.mathworks.toolbox.testmeas.propertyeditor.EnumConstraintValues;
import com.mathworks.toolbox.testmeas.propertyeditor.IPropertySetter;
import com.mathworks.toolbox.testmeas.propertyeditor.Property;
import com.mathworks.toolbox.testmeas.propertyeditor.Widget;
import com.mathworks.toolbox.testmeas.tmswing.TMAbstractStyleGuideJPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;

public class RadioButtonWidget
extends Widget {
    private List<MJRadioButton> fRadioButtons = new ArrayList<MJRadioButton>();

    public RadioButtonWidget(IPropertySetter iPropertySetter, Property property) {
        super(iPropertySetter, property);
        assert (property.getConstraint() == Constraint.ENUM);
        assert (property.getConstraintValues().getClass() == EnumConstraintValues.class);
    }

    @Override
    public void addContent(TMAbstractStyleGuideJPanel tMAbstractStyleGuideJPanel) {
        EnumConstraintValues enumConstraintValues = (EnumConstraintValues)this.getProperty().getConstraintValues();
        ButtonGroup buttonGroup = new ButtonGroup();
        for (final String string : enumConstraintValues.getAllConstants()) {
            boolean bl = string.equals(this.getProperty().getValue());
            final MJRadioButton mJRadioButton = new MJRadioButton(string, bl);
            mJRadioButton.setName(string + ".RadioButton");
            mJRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RadioButtonWidget.this.set(string, (Component)mJRadioButton);
                }
            });
            buttonGroup.add((AbstractButton)mJRadioButton);
            this.fRadioButtons.add(mJRadioButton);
            tMAbstractStyleGuideJPanel.addLine((JComponent)mJRadioButton);
        }
    }

    @Override
    public void cleanup() {
        for (MJRadioButton mJRadioButton : this.fRadioButtons) {
            ActionListener[] actionListenerArray;
            for (ActionListener actionListener : actionListenerArray = mJRadioButton.getActionListeners()) {
                mJRadioButton.removeActionListener(actionListener);
            }
        }
    }

    @Override
    public void displayValue(Object object) {
        assert (object instanceof String) : "Value for a Radio button widget must be the string of the selected option";
        EnumConstraintValues enumConstraintValues = (EnumConstraintValues)this.getProperty().getConstraintValues();
        assert (enumConstraintValues.isValid(object)) : "This string is not a valid value for the Radio Buttons.";
        for (MJRadioButton mJRadioButton : this.fRadioButtons) {
            if (!mJRadioButton.getText().equals(object)) continue;
            mJRadioButton.setSelected(true);
        }
    }

    @Override
    public void enableWidget(boolean bl) {
        for (MJRadioButton mJRadioButton : this.fRadioButtons) {
            mJRadioButton.setEnabled(bl);
        }
    }
}

