/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.propertyeditor;

import com.mathworks.mwswing.MJComboBox;
import com.mathworks.toolbox.testmeas.propertyeditor.EnumConstraintValues;
import com.mathworks.toolbox.testmeas.propertyeditor.IPropertySetter;
import com.mathworks.toolbox.testmeas.propertyeditor.Property;
import com.mathworks.toolbox.testmeas.propertyeditor.Widget;
import com.mathworks.toolbox.testmeas.tmswing.TMAbstractStyleGuideJPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;

public class ComboBoxWidget
extends Widget {
    MJComboBox fComboBox = new MJComboBox();

    public ComboBoxWidget(IPropertySetter iPropertySetter, Property property) {
        super(iPropertySetter, property);
        this.fComboBox.setName(property.getName() + "combobox");
    }

    @Override
    public void addContent(TMAbstractStyleGuideJPanel tMAbstractStyleGuideJPanel) {
        EnumConstraintValues enumConstraintValues = (EnumConstraintValues)this.getProperty().getConstraintValues();
        for (String string : enumConstraintValues.getAllConstants()) {
            this.fComboBox.addItem((Object)string);
        }
        assert (enumConstraintValues.isValid(this.getProperty().getValue())) : "This current value must be contained in the enumeration.";
        this.fComboBox.setSelectedItem(this.getProperty().getValue());
        this.fComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComboBoxWidget.this.set(ComboBoxWidget.this.fComboBox.getSelectedItem(), (Component)ComboBoxWidget.this.fComboBox);
            }
        });
        tMAbstractStyleGuideJPanel.addLine((JComponent[][])new JComponent[][]{{this.fComboBox, null}}, 0, 1);
    }

    @Override
    public void cleanup() {
        this.removeActionListeners();
    }

    @Override
    public void displayValue(Object object) {
        assert (object instanceof String || object instanceof Character) : "Value in a combo box should be a string or character";
        EnumConstraintValues enumConstraintValues = (EnumConstraintValues)this.getProperty().getConstraintValues();
        assert (enumConstraintValues.isValid(object)) : "This string is not a valid value for the combo.";
        ActionListener[] actionListenerArray = this.removeActionListeners();
        this.fComboBox.setSelectedItem(object);
        for (ActionListener actionListener : actionListenerArray) {
            this.fComboBox.addActionListener(actionListener);
        }
    }

    @Override
    public void enableWidget(boolean bl) {
        this.fComboBox.setEnabled(bl);
    }

    private ActionListener[] removeActionListeners() {
        ActionListener[] actionListenerArray;
        for (ActionListener actionListener : actionListenerArray = this.fComboBox.getActionListeners()) {
            this.fComboBox.removeActionListener(actionListener);
        }
        return actionListenerArray;
    }
}

